/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import com.google.common.io.Files;
import com.griefprevention.visualization.BoundaryVisualization;
import com.griefprevention.visualization.VisualizationType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.CreateClaimResult;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.CustomizableMessage;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.SecureClaimTask;
import me.ryanhamshire.GriefPrevention.SiegeCheckupTask;
import me.ryanhamshire.GriefPrevention.SiegeData;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.UUIDFetcher;
import me.ryanhamshire.GriefPrevention.WorldGuardWrapper;
import me.ryanhamshire.GriefPrevention.events.ClaimCreatedEvent;
import me.ryanhamshire.GriefPrevention.events.ClaimDeletedEvent;
import me.ryanhamshire.GriefPrevention.events.ClaimExtendEvent;
import me.ryanhamshire.GriefPrevention.events.ClaimModifiedEvent;
import me.ryanhamshire.GriefPrevention.events.ClaimTransferEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class DataStore {
    protected ConcurrentHashMap<UUID, PlayerData> playerNameToPlayerDataMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Integer> permissionToBonusBlocksMap = new ConcurrentHashMap();
    ArrayList<Claim> claims = new ArrayList();
    ConcurrentHashMap<Long, ArrayList<Claim>> chunksToClaimsMap = new ConcurrentHashMap();
    private String[] messages;
    protected static final Pattern uuidpattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
    Long nextClaimID = 0L;
    protected static final String dataLayerFolderPath = "plugins" + File.separator + "GriefPreventionData";
    static final String playerDataFolderPath = dataLayerFolderPath + File.separator + "PlayerData";
    static final String configFilePath = dataLayerFolderPath + File.separator + "config.yml";
    static final String messagesFilePath = dataLayerFolderPath + File.separator + "messages.yml";
    static final String softMuteFilePath = dataLayerFolderPath + File.separator + "softMute.txt";
    static final String bannedWordsFilePath = dataLayerFolderPath + File.separator + "bannedWords.txt";
    protected static final int latestSchemaVersion = 3;
    private int currentSchemaVersion = -1;
    static final String SURVIVAL_VIDEO_URL = String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(ChatColor.UNDERLINE) + "bit.ly/mcgpuser" + String.valueOf(ChatColor.RESET);
    static final String CREATIVE_VIDEO_URL = String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(ChatColor.UNDERLINE) + "bit.ly/mcgpcrea" + String.valueOf(ChatColor.RESET);
    static final String SUBDIVISION_VIDEO_URL = String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(ChatColor.UNDERLINE) + "bit.ly/mcgpsub" + String.valueOf(ChatColor.RESET);
    ConcurrentHashMap<UUID, Boolean> softMuteMap = new ConcurrentHashMap();
    private WorldGuardWrapper worldGuard = null;
    private final String locationStringDelimiter = ";";
    private final HashMap<String, Long> siegeCooldownRemaining = new HashMap();

    abstract int getSchemaVersionFromStorage();

    abstract void updateSchemaVersionInStorage(int var1);

    protected int getSchemaVersion() {
        if (this.currentSchemaVersion >= 0) {
            return this.currentSchemaVersion;
        }
        this.currentSchemaVersion = this.getSchemaVersionFromStorage();
        return this.currentSchemaVersion;
    }

    protected void setSchemaVersion(int versionToSet) {
        this.currentSchemaVersion = versionToSet;
        this.updateSchemaVersionInStorage(versionToSet);
    }

    void initialize() throws Exception {
        GriefPrevention.AddLogEntry(this.claims.size() + " total claims loaded.");
        for (Claim claim : this.claims) {
            if (claim.id < this.nextClaimID) continue;
            GriefPrevention.instance.getLogger().severe("nextClaimID was lesser or equal to an already-existing claim ID!\nThis usually happens if you ran out of storage space.");
            GriefPrevention.AddLogEntry("Changing nextClaimID from " + this.nextClaimID + " to " + claim.id, CustomLogEntryTypes.Debug, false);
            this.nextClaimID = claim.id + 1L;
        }
        File playerDataFolder = new File(playerDataFolderPath);
        if (!playerDataFolder.exists()) {
            playerDataFolder.mkdirs();
        }
        this.loadMessages();
        GriefPrevention.AddLogEntry("Customizable messages loaded.");
        if (this.getSchemaVersion() < 3) {
            GriefPrevention.AddLogEntry("Please wait.  Updating data format.");
            for (Claim claim : this.claims) {
                this.saveClaim(claim);
                for (Claim subClaim : claim.children) {
                    this.saveClaim(subClaim);
                }
            }
            if (UUIDFetcher.lookupCache != null) {
                UUIDFetcher.lookupCache.clear();
                UUIDFetcher.correctedNames.clear();
            }
            GriefPrevention.AddLogEntry("Update finished.");
        }
        this.loadSoftMutes();
        this.setSchemaVersion(3);
        try {
            this.worldGuard = new WorldGuardWrapper();
            GriefPrevention.AddLogEntry("Successfully hooked into WorldGuard.");
        }
        catch (ClassCastException | IllegalArgumentException | IllegalStateException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    private void loadSoftMutes() {
        File softMuteFile = new File(softMuteFilePath);
        if (softMuteFile.exists()) {
            BufferedReader inStream = null;
            try {
                inStream = new BufferedReader(new FileReader(softMuteFile.getAbsolutePath()));
                String nextID = inStream.readLine();
                while (nextID != null) {
                    UUID playerID;
                    try {
                        playerID = UUID.fromString(nextID);
                    }
                    catch (Exception e) {
                        playerID = null;
                        GriefPrevention.AddLogEntry("Failed to parse soft mute entry as a UUID: " + nextID);
                    }
                    if (playerID != null) {
                        this.softMuteMap.put(playerID, true);
                    }
                    nextID = inStream.readLine();
                }
            }
            catch (Exception e) {
                GriefPrevention.AddLogEntry("Failed to read from the soft mute data file: " + e.toString());
                e.printStackTrace();
            }
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<String> loadBannedWords() {
        try {
            File bannedWordsFile = new File(bannedWordsFilePath);
            if (!bannedWordsFile.exists()) {
                Files.touch((File)bannedWordsFile);
                String defaultWords = "nigger\nniggers\nniger\nnigga\nnigers\nniggas\nfag\nfags\nfaggot\nfaggots\nfeggit\nfeggits\nfaggit\nfaggits\ncunt\ncunts\nwhore\nwhores\nslut\nsluts\n";
                Files.append((CharSequence)defaultWords, (File)bannedWordsFile, (Charset)Charset.forName("UTF-8"));
            }
            return Files.readLines((File)bannedWordsFile, (Charset)Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("Failed to read from the banned words data file: " + e.toString());
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    boolean toggleSoftMute(UUID playerID) {
        boolean newValue = !this.isSoftMuted(playerID);
        this.softMuteMap.put(playerID, newValue);
        this.saveSoftMutes();
        return newValue;
    }

    public boolean isSoftMuted(UUID playerID) {
        Boolean mapEntry = this.softMuteMap.get(playerID);
        return mapEntry != null && mapEntry != Boolean.FALSE;
    }

    private void saveSoftMutes() {
        BufferedWriter outStream = null;
        try {
            File softMuteFile = new File(softMuteFilePath);
            softMuteFile.createNewFile();
            outStream = new BufferedWriter(new FileWriter(softMuteFile));
            for (Map.Entry<UUID, Boolean> entry : this.softMuteMap.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                outStream.write(entry.getKey().toString());
                outStream.newLine();
            }
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("Unexpected exception saving soft mute data: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void clearCachedPlayerData(UUID playerID) {
        this.playerNameToPlayerDataMap.remove(playerID);
    }

    public synchronized int getGroupBonusBlocks(UUID playerID) {
        Player player = GriefPrevention.instance.getServer().getPlayer(playerID);
        if (player == null) {
            return 0;
        }
        int bonusBlocks = 0;
        for (Map.Entry<String, Integer> groupEntry : this.permissionToBonusBlocksMap.entrySet()) {
            if (!player.hasPermission(groupEntry.getKey())) continue;
            bonusBlocks += groupEntry.getValue().intValue();
        }
        return bonusBlocks;
    }

    public synchronized int adjustGroupBonusBlocks(String groupName, int amount) {
        Integer currentValue = this.permissionToBonusBlocksMap.get(groupName);
        if (currentValue == null) {
            currentValue = 0;
        }
        currentValue = currentValue + amount;
        this.permissionToBonusBlocksMap.put(groupName, currentValue);
        this.saveGroupBonusBlocks(groupName, currentValue);
        return currentValue;
    }

    abstract void saveGroupBonusBlocks(String var1, int var2);

    public synchronized void changeClaimOwner(Claim claim, UUID newOwnerID) {
        if (claim.parent != null) {
            throw new NoTransferException("Subdivisions can't be transferred.  Only top-level claims may change owners.");
        }
        PlayerData ownerData = null;
        if (!claim.isAdminClaim()) {
            ownerData = this.getPlayerData(claim.ownerID);
        }
        ClaimTransferEvent event = new ClaimTransferEvent(claim, newOwnerID);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        PlayerData newOwnerData = null;
        if (event.getNewOwner() != null) {
            newOwnerData = this.getPlayerData(event.getNewOwner());
        }
        claim.ownerID = event.getNewOwner();
        this.saveClaim(claim);
        if (ownerData != null) {
            ownerData.getClaims().remove(claim);
        }
        if (newOwnerData != null) {
            newOwnerData.getClaims().add(claim);
        }
    }

    synchronized void addClaim(Claim newClaim, boolean writeToStorage) {
        if (newClaim.parent != null) {
            if (!newClaim.parent.children.contains(newClaim)) {
                newClaim.parent.children.add(newClaim);
            }
            newClaim.inDataStore = true;
            if (writeToStorage) {
                this.saveClaim(newClaim);
            }
            return;
        }
        this.claims.add(newClaim);
        this.addToChunkClaimMap(newClaim);
        newClaim.inDataStore = true;
        if (!newClaim.isAdminClaim() && writeToStorage) {
            PlayerData ownerData = this.getPlayerData(newClaim.ownerID);
            ownerData.getClaims().add(newClaim);
        }
        if (writeToStorage) {
            this.saveClaim(newClaim);
        }
    }

    private void addToChunkClaimMap(Claim claim) {
        if (claim.parent != null) {
            return;
        }
        ArrayList<Long> chunkHashes = claim.getChunkHashes();
        for (Long chunkHash : chunkHashes) {
            ArrayList<Claim> claimsInChunk = this.chunksToClaimsMap.get(chunkHash);
            if (claimsInChunk == null) {
                claimsInChunk = new ArrayList();
                this.chunksToClaimsMap.put(chunkHash, claimsInChunk);
            }
            claimsInChunk.add(claim);
        }
    }

    private void removeFromChunkClaimMap(Claim claim) {
        ArrayList<Long> chunkHashes = claim.getChunkHashes();
        for (Long chunkHash : chunkHashes) {
            ArrayList<Claim> claimsInChunk = this.chunksToClaimsMap.get(chunkHash);
            if (claimsInChunk == null) continue;
            Iterator<Claim> it = claimsInChunk.iterator();
            while (it.hasNext()) {
                Claim c = it.next();
                if (!c.id.equals(claim.id)) continue;
                it.remove();
                break;
            }
            if (!claimsInChunk.isEmpty()) continue;
            this.chunksToClaimsMap.remove(chunkHash);
        }
    }

    String locationToString(Location location) {
        StringBuilder stringBuilder = new StringBuilder(location.getWorld().getName());
        stringBuilder.append(";");
        stringBuilder.append(location.getBlockX());
        stringBuilder.append(";");
        stringBuilder.append(location.getBlockY());
        stringBuilder.append(";");
        stringBuilder.append(location.getBlockZ());
        return stringBuilder.toString();
    }

    Location locationFromString(String string, List<World> validWorlds) throws Exception {
        String[] elements = string.split(";");
        if (elements.length < 4) {
            throw new Exception("Expected four distinct parts to the location string: \"" + string + "\"");
        }
        String worldName = elements[0];
        String xString = elements[1];
        String yString = elements[2];
        String zString = elements[3];
        World world = null;
        for (World w : validWorlds) {
            if (!w.getName().equalsIgnoreCase(worldName)) continue;
            world = w;
            break;
        }
        if (world == null) {
            throw new Exception("World not found: \"" + worldName + "\"");
        }
        int x = Integer.parseInt(xString);
        int y = Integer.parseInt(yString);
        int z = Integer.parseInt(zString);
        return new Location(world, (double)x, (double)y, (double)z);
    }

    public synchronized void saveClaim(Claim claim) {
        this.assignClaimID(claim);
        this.writeClaimToStorage(claim);
    }

    private void assignClaimID(Claim claim) {
        if (claim.id == null || claim.id == -1L) {
            claim.id = this.nextClaimID;
            this.incrementNextClaimID();
        }
    }

    abstract void writeClaimToStorage(Claim var1);

    abstract void incrementNextClaimID();

    public synchronized PlayerData getPlayerData(UUID playerID) {
        PlayerData playerData = this.playerNameToPlayerDataMap.get(playerID);
        if (playerData == null) {
            playerData = new PlayerData();
            playerData.playerID = playerID;
            this.playerNameToPlayerDataMap.put(playerID, playerData);
        }
        return playerData;
    }

    abstract PlayerData getPlayerDataFromStorage(UUID var1);

    public synchronized void deleteClaim(Claim claim) {
        this.deleteClaim(claim, true, false);
    }

    public synchronized void deleteClaim(Claim claim, boolean releasePets) {
        this.deleteClaim(claim, true, releasePets);
    }

    synchronized void deleteClaim(Claim claim, boolean fireEvent, boolean releasePets) {
        int j = 1;
        while (j - 1 < claim.children.size()) {
            this.deleteClaim(claim.children.get(j - 1), releasePets);
            ++j;
        }
        if (claim.parent != null) {
            Claim parentClaim = claim.parent;
            parentClaim.children.remove(claim);
        }
        claim.inDataStore = false;
        for (int i = 0; i < this.claims.size(); ++i) {
            if (!this.claims.get((int)i).id.equals(claim.id)) continue;
            this.claims.remove(i);
            break;
        }
        this.removeFromChunkClaimMap(claim);
        this.deleteClaimFromSecondaryStorage(claim);
        if (claim.ownerID != null) {
            PlayerData ownerData = this.getPlayerData(claim.ownerID);
            for (int i = 0; i < ownerData.getClaims().size(); ++i) {
                if (!ownerData.getClaims().get((int)i).id.equals(claim.id)) continue;
                ownerData.getClaims().remove(i);
                break;
            }
            this.savePlayerData(claim.ownerID, ownerData);
        }
        if (fireEvent) {
            ClaimDeletedEvent ev = new ClaimDeletedEvent(claim);
            Bukkit.getPluginManager().callEvent((Event)ev);
        }
        if (releasePets && claim.ownerID != null && claim.parent == null) {
            for (Chunk chunk : claim.getChunks()) {
                Entity[] entities;
                for (Entity entity : entities = chunk.getEntities()) {
                    AnimalTamer owner;
                    Tameable pet;
                    if (!(entity instanceof Tameable) || !(pet = (Tameable)entity).isTamed() || (owner = pet.getOwner()) == null || !owner.getUniqueId().equals(claim.ownerID)) continue;
                    pet.setTamed(false);
                    pet.setOwner(null);
                    if (pet instanceof InventoryHolder) {
                        InventoryHolder holder = (InventoryHolder)pet;
                        holder.getInventory().clear();
                    }
                    if (!(pet instanceof Sittable)) continue;
                    Sittable sittable = (Sittable)pet;
                    sittable.setSitting(false);
                }
            }
        }
    }

    abstract void deleteClaimFromSecondaryStorage(Claim var1);

    public synchronized Claim getClaimAt(Location location, boolean ignoreHeight, Claim cachedClaim) {
        return this.getClaimAt(location, ignoreHeight, false, cachedClaim);
    }

    public synchronized Claim getClaimAt(Location location, boolean ignoreHeight, boolean ignoreSubclaims, Claim cachedClaim) {
        if (cachedClaim != null && cachedClaim.inDataStore && cachedClaim.contains(location, ignoreHeight, !ignoreSubclaims)) {
            return cachedClaim;
        }
        Long chunkID = DataStore.getChunkHash(location);
        ArrayList<Claim> claimsInChunk = this.chunksToClaimsMap.get(chunkID);
        if (claimsInChunk == null) {
            return null;
        }
        for (Claim claim : claimsInChunk) {
            if (!claim.inDataStore || !claim.contains(location, ignoreHeight, false)) continue;
            if (ignoreSubclaims) {
                return claim;
            }
            for (int j = 0; j < claim.children.size(); ++j) {
                Claim subdivision = claim.children.get(j);
                if (!subdivision.inDataStore || !subdivision.contains(location, ignoreHeight, false)) continue;
                return subdivision;
            }
            return claim;
        }
        return null;
    }

    public synchronized Claim getClaim(long id) {
        for (Claim claim : this.claims) {
            if (!claim.inDataStore) continue;
            if (claim.getID() == id) {
                return claim;
            }
            for (Claim subClaim : claim.children) {
                if (subClaim.getID() != id) continue;
                return subClaim;
            }
        }
        return null;
    }

    public Collection<Claim> getClaims() {
        return Collections.unmodifiableCollection(this.claims);
    }

    public Collection<Claim> getClaims(int chunkx, int chunkz) {
        ArrayList<Claim> chunkClaims = this.chunksToClaimsMap.get(DataStore.getChunkHash(chunkx, chunkz));
        if (chunkClaims != null) {
            return Collections.unmodifiableCollection(chunkClaims);
        }
        return Collections.unmodifiableCollection(new ArrayList());
    }

    public static Long getChunkHash(long chunkx, long chunkz) {
        return chunkz ^ chunkx << 32;
    }

    public static Long getChunkHash(Location location) {
        return DataStore.getChunkHash(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public static ArrayList<Long> getChunkHashes(Claim claim) {
        return DataStore.getChunkHashes(claim.getLesserBoundaryCorner(), claim.getGreaterBoundaryCorner());
    }

    public static ArrayList<Long> getChunkHashes(Location min, Location max) {
        ArrayList<Long> hashes = new ArrayList<Long>();
        int smallX = min.getBlockX() >> 4;
        int smallZ = min.getBlockZ() >> 4;
        int largeX = max.getBlockX() >> 4;
        int largeZ = max.getBlockZ() >> 4;
        for (int x = smallX; x <= largeX; ++x) {
            for (int z = smallZ; z <= largeZ; ++z) {
                hashes.add(DataStore.getChunkHash(x, z));
            }
        }
        return hashes;
    }

    public synchronized CreateClaimResult createClaim(World world, int x1, int x2, int y1, int y2, int z1, int z2, UUID ownerID, Claim parent, Long id, Player creatingPlayer) {
        return this.createClaim(world, x1, x2, y1, y2, z1, z2, ownerID, parent, id, creatingPlayer, false);
    }

    public synchronized CreateClaimResult createClaim(World world, int x1, int x2, int y1, int y2, int z1, int z2, UUID ownerID, Claim parent, Long id, Player creatingPlayer, boolean dryRun) {
        int bigz;
        int smallz;
        int bigy;
        int smally;
        int bigx;
        int smallx;
        CreateClaimResult result = new CreateClaimResult();
        int worldMinY = world.getMinHeight();
        y1 = Math.max(worldMinY, Math.max(GriefPrevention.instance.config_claims_maxDepth, y1));
        y2 = Math.max(worldMinY, Math.max(GriefPrevention.instance.config_claims_maxDepth, y2));
        if (x1 < x2) {
            smallx = x1;
            bigx = x2;
        } else {
            smallx = x2;
            bigx = x1;
        }
        if (y1 < y2) {
            smally = y1;
            bigy = y2;
        } else {
            smally = y2;
            bigy = y1;
        }
        if (z1 < z2) {
            smallz = z1;
            bigz = z2;
        } else {
            smallz = z2;
            bigz = z1;
        }
        if (parent != null) {
            Location lesser = parent.getLesserBoundaryCorner();
            Location greater = parent.getGreaterBoundaryCorner();
            if ((double)smallx < lesser.getX() || (double)smallz < lesser.getZ() || (double)bigx > greater.getX() || (double)bigz > greater.getZ()) {
                result.succeeded = false;
                result.claim = parent;
                return result;
            }
            smally = this.sanitizeClaimDepth(parent, smally);
        }
        Location smallerBoundaryCorner = new Location(world, (double)smallx, (double)smally, (double)smallz);
        Location greaterBoundaryCorner = new Location(world, (double)bigx, (double)bigy, (double)bigz);
        if (!world.getWorldBorder().isInside(smallerBoundaryCorner) || !world.getWorldBorder().isInside(greaterBoundaryCorner)) {
            result.succeeded = false;
            return result;
        }
        if (GriefPrevention.instance.config_claims_worldModes.get(world) == ClaimsMode.Creative) {
            smallerBoundaryCorner.setY((double)world.getMinHeight());
        }
        Claim newClaim = new Claim(smallerBoundaryCorner, greaterBoundaryCorner, ownerID, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), id);
        newClaim.parent = parent;
        ArrayList<Claim> claimsToCheck = newClaim.parent != null ? newClaim.parent.children : this.claims;
        for (Claim otherClaim : claimsToCheck) {
            if (otherClaim.id == newClaim.id || !otherClaim.inDataStore || !otherClaim.overlaps(newClaim)) continue;
            result.succeeded = false;
            result.claim = otherClaim;
            return result;
        }
        if (GriefPrevention.instance.config_claims_respectWorldGuard && this.worldGuard != null && creatingPlayer != null && !this.worldGuard.canBuild(newClaim.lesserBoundaryCorner, newClaim.greaterBoundaryCorner, creatingPlayer)) {
            result.succeeded = false;
            result.claim = null;
            return result;
        }
        if (dryRun) {
            result.succeeded = true;
            result.claim = newClaim;
            return result;
        }
        this.assignClaimID(newClaim);
        ClaimCreatedEvent event = new ClaimCreatedEvent(newClaim, (CommandSender)creatingPlayer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            result.succeeded = false;
            result.claim = null;
            return result;
        }
        this.addClaim(newClaim, true);
        result.succeeded = true;
        result.claim = newClaim;
        return result;
    }

    public void savePlayerDataSync(UUID playerID, PlayerData playerData) {
        playerData.getAccruedClaimBlocks();
        playerData.getClaims();
        this.asyncSavePlayerData(playerID, playerData);
    }

    public void savePlayerData(UUID playerID, PlayerData playerData) {
        new SavePlayerDataThread(playerID, playerData).start();
    }

    public void asyncSavePlayerData(UUID playerID, PlayerData playerData) {
        this.overrideSavePlayerData(playerID, playerData);
        if (playerData.ignoreListChanged) {
            StringBuilder fileContent = new StringBuilder();
            try {
                for (UUID uuidKey : playerData.ignoredPlayers.keySet()) {
                    Boolean value = playerData.ignoredPlayers.get(uuidKey);
                    if (value == null) continue;
                    if (value.booleanValue()) {
                        fileContent.append("*");
                    }
                    fileContent.append(uuidKey);
                    fileContent.append("\n");
                }
                File playerDataFile = new File(playerDataFolderPath + File.separator + String.valueOf(playerID) + ".ignore");
                Files.write((byte[])fileContent.toString().trim().getBytes("UTF-8"), (File)playerDataFile);
            }
            catch (Exception e) {
                GriefPrevention.AddLogEntry("GriefPrevention: Unexpected exception saving data for player \"" + playerID.toString() + "\": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    abstract void overrideSavePlayerData(UUID var1, PlayerData var2);

    public synchronized void extendClaim(Claim claim, int newDepth) {
        if (claim.parent != null) {
            claim = claim.parent;
        }
        newDepth = this.sanitizeClaimDepth(claim, newDepth);
        ClaimExtendEvent event = new ClaimExtendEvent(claim, newDepth);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.setNewDepth(claim, event.getNewDepth());
    }

    private int sanitizeClaimDepth(Claim claim, int newDepth) {
        if (claim.parent != null) {
            claim = claim.parent;
        }
        int oldDepth = Math.min(claim.getLesserBoundaryCorner().getBlockY(), claim.children.stream().mapToInt(child -> child.getLesserBoundaryCorner().getBlockY()).min().orElse(Integer.MAX_VALUE));
        newDepth = Math.min(newDepth, oldDepth);
        newDepth = Math.max(newDepth, GriefPrevention.instance.config_claims_maxDepth);
        World world = Objects.requireNonNull(claim.getLesserBoundaryCorner().getWorld());
        newDepth = Math.max(newDepth, world.getMinHeight());
        return newDepth;
    }

    private void setNewDepth(Claim claim, int newDepth) {
        if (claim.parent != null) {
            claim = claim.parent;
        }
        int depth = this.sanitizeClaimDepth(claim, newDepth);
        Stream.concat(Stream.of(claim), claim.children.stream()).forEach(localClaim -> {
            localClaim.lesserBoundaryCorner.setY((double)depth);
            localClaim.greaterBoundaryCorner.setY((double)Math.max(localClaim.greaterBoundaryCorner.getBlockY(), depth));
            this.saveClaim((Claim)localClaim);
        });
    }

    public synchronized void startSiege(Player attacker, Player defender, Claim defenderClaim) {
        SiegeData siegeData = new SiegeData(attacker, defender, defenderClaim);
        PlayerData attackerData = this.getPlayerData(attacker.getUniqueId());
        PlayerData defenderData = this.getPlayerData(defender.getUniqueId());
        attackerData.siegeData = siegeData;
        defenderData.siegeData = siegeData;
        defenderClaim.siegeData = siegeData;
        SiegeCheckupTask task = new SiegeCheckupTask(siegeData);
        siegeData.checkupTaskID = GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 600L);
    }

    public synchronized void endSiege(SiegeData siegeData, String winnerName, String loserName, List<ItemStack> drops) {
        Player winner;
        boolean grantAccess = false;
        if (winnerName == null && loserName != null) {
            winnerName = siegeData.attacker.getName().equals(loserName) ? siegeData.defender.getName() : siegeData.attacker.getName();
        } else if (winnerName != null && loserName == null) {
            loserName = siegeData.attacker.getName().equals(winnerName) ? siegeData.defender.getName() : siegeData.attacker.getName();
        }
        if (siegeData.attacker.getName().equals(winnerName)) {
            grantAccess = true;
        }
        PlayerData attackerData = this.getPlayerData(siegeData.attacker.getUniqueId());
        attackerData.siegeData = null;
        PlayerData defenderData = this.getPlayerData(siegeData.defender.getUniqueId());
        defenderData.siegeData = null;
        defenderData.lastSiegeEndTimeStamp = System.currentTimeMillis();
        Long now = Calendar.getInstance().getTimeInMillis();
        Long cooldownEnd = now + (long)(60000 * GriefPrevention.instance.config_siege_cooldownEndInMinutes);
        this.siegeCooldownRemaining.put(siegeData.attacker.getName() + "_" + siegeData.defender.getName(), cooldownEnd);
        for (int i = 0; i < siegeData.claims.size(); ++i) {
            Claim claim = siegeData.claims.get(i);
            claim.siegeData = null;
            this.siegeCooldownRemaining.put(siegeData.attacker.getName() + "_" + claim.getOwnerName(), cooldownEnd);
            if (!grantAccess) continue;
            claim.doorsOpen = true;
        }
        GriefPrevention.instance.getServer().getScheduler().cancelTask(siegeData.checkupTaskID);
        if (winnerName != null && loserName != null) {
            GriefPrevention.instance.getServer().broadcastMessage(winnerName + " defeated " + loserName + " in siege warfare!");
        }
        if (grantAccess && (winner = GriefPrevention.instance.getServer().getPlayer(winnerName)) != null) {
            GriefPrevention.sendMessage(winner, TextMode.Success, Messages.SiegeWinDoorsOpen, new String[0]);
            SecureClaimTask task = new SecureClaimTask(siegeData);
            GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 20L * (long)GriefPrevention.instance.config_siege_doorsOpenSeconds);
        }
        if (drops != null) {
            Player winner2 = GriefPrevention.instance.getServer().getPlayer(winnerName);
            Player loser = GriefPrevention.instance.getServer().getPlayer(loserName);
            if (winner2 != null && loser != null) {
                for (ItemStack stack : drops) {
                    if (stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
                    HashMap wontFitItems = winner2.getInventory().addItem(new ItemStack[]{stack});
                    Object[] keys = wontFitItems.keySet().toArray();
                    Location winnerLocation = winner2.getLocation();
                    for (Map.Entry wontFitItem : wontFitItems.entrySet()) {
                        winner2.getWorld().dropItemNaturally(winnerLocation, (ItemStack)wontFitItem.getValue());
                    }
                }
                drops.clear();
            }
        }
    }

    public synchronized boolean onCooldown(Player attacker, Player defender, Claim defenderClaim) {
        long now;
        Long cooldownEnd = null;
        if (this.siegeCooldownRemaining.get(attacker.getName() + "_" + defender.getName()) != null) {
            cooldownEnd = this.siegeCooldownRemaining.get(attacker.getName() + "_" + defender.getName());
            if (Calendar.getInstance().getTimeInMillis() < cooldownEnd) {
                return true;
            }
            this.siegeCooldownRemaining.remove(attacker.getName() + "_" + defender.getName());
        }
        PlayerData defenderData = this.getPlayerData(defender.getUniqueId());
        if (defenderData.lastSiegeEndTimeStamp > 0L && (now = System.currentTimeMillis()) - defenderData.lastSiegeEndTimeStamp > 900000L) {
            return true;
        }
        if (cooldownEnd == null && this.siegeCooldownRemaining.get(attacker.getName() + "_" + defenderClaim.getOwnerName()) != null) {
            cooldownEnd = this.siegeCooldownRemaining.get(attacker.getName() + "_" + defenderClaim.getOwnerName());
            if (Calendar.getInstance().getTimeInMillis() < cooldownEnd) {
                return true;
            }
            this.siegeCooldownRemaining.remove(attacker.getName() + "_" + defenderClaim.getOwnerName());
        }
        return false;
    }

    synchronized void tryExtendSiege(Player player, Claim claim) {
        PlayerData playerData = this.getPlayerData(player.getUniqueId());
        if (playerData.siegeData == null) {
            return;
        }
        if (playerData.siegeData.claims.contains(claim)) {
            return;
        }
        if (claim.isAdminClaim()) {
            return;
        }
        Claim currentClaim = claim;
        while (!currentClaim.hasExplicitPermission(player, ClaimPermission.Access)) {
            if (currentClaim.parent == null) {
                return;
            }
            currentClaim = currentClaim.parent;
        }
        playerData.siegeData.claims.add(claim);
        claim.siegeData = playerData.siegeData;
    }

    public synchronized void deleteClaimsForPlayer(UUID playerID, boolean releasePets) {
        ArrayList<Claim> claimsToDelete = new ArrayList<Claim>();
        for (Claim claim : this.claims) {
            if (playerID != claim.ownerID && (playerID == null || !playerID.equals(claim.ownerID))) continue;
            claimsToDelete.add(claim);
        }
        for (Claim claim : claimsToDelete) {
            claim.removeSurfaceFluids(null);
            this.deleteClaim(claim, releasePets);
            if (!GriefPrevention.instance.creativeRulesApply(claim.getLesserBoundaryCorner())) continue;
            GriefPrevention.instance.restoreClaim(claim, 0L);
        }
    }

    public synchronized CreateClaimResult resizeClaim(Claim claim, int newx1, int newx2, int newy1, int newy2, int newz1, int newz2, Player resizingPlayer) {
        CreateClaimResult result = this.createClaim(claim.getLesserBoundaryCorner().getWorld(), newx1, newx2, newy1, newy2, newz1, newz2, claim.ownerID, claim.parent, claim.id, resizingPlayer, true);
        if (result.succeeded) {
            this.removeFromChunkClaimMap(claim);
            claim.lesserBoundaryCorner = result.claim.lesserBoundaryCorner;
            claim.greaterBoundaryCorner = result.claim.greaterBoundaryCorner;
            this.setNewDepth(claim, claim.getLesserBoundaryCorner().getBlockY());
            result.claim = claim;
            this.addToChunkClaimMap(claim);
        }
        return result;
    }

    void resizeClaimWithChecks(Player player, PlayerData playerData, int newx1, int newx2, int newy1, int newy2, int newz1, int newz2) {
        if (playerData.claimResizing.parent == null) {
            int newArea;
            boolean smaller;
            int newHeight;
            int newWidth;
            try {
                newWidth = Math.abs(Math.subtractExact(newx1, newx2)) + 1;
                newHeight = Math.abs(Math.subtractExact(newz1, newz2)) + 1;
            }
            catch (ArithmeticException e) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeNeedMoreBlocks, String.valueOf(Integer.MAX_VALUE));
                return;
            }
            boolean bl = smaller = newWidth < playerData.claimResizing.getWidth() || newHeight < playerData.claimResizing.getHeight();
            if (!player.hasPermission("griefprevention.adminclaims") && !playerData.claimResizing.isAdminClaim() && smaller) {
                if (newWidth < GriefPrevention.instance.config_claims_minWidth || newHeight < GriefPrevention.instance.config_claims_minWidth) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeClaimTooNarrow, String.valueOf(GriefPrevention.instance.config_claims_minWidth));
                    return;
                }
                try {
                    newArea = Math.multiplyExact(newWidth, newHeight);
                }
                catch (ArithmeticException e) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeNeedMoreBlocks, String.valueOf(Integer.MAX_VALUE));
                    return;
                }
                if (newArea < GriefPrevention.instance.config_claims_minArea) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeClaimInsufficientArea, String.valueOf(GriefPrevention.instance.config_claims_minArea));
                    return;
                }
            }
            if (!playerData.claimResizing.isAdminClaim() && player.getName().equals(playerData.claimResizing.getOwnerName())) {
                int blocksRemainingAfter;
                try {
                    newArea = Math.multiplyExact(newWidth, newHeight);
                    blocksRemainingAfter = playerData.getRemainingClaimBlocks() + (playerData.claimResizing.getArea() - newArea);
                }
                catch (ArithmeticException e) {
                    blocksRemainingAfter = -2147483647;
                }
                if (blocksRemainingAfter < 0) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeNeedMoreBlocks, String.valueOf(Math.abs(blocksRemainingAfter)));
                    this.tryAdvertiseAdminAlternatives(player);
                    return;
                }
            }
        }
        Claim oldClaim = playerData.claimResizing;
        Claim newClaim = new Claim(oldClaim);
        World world = newClaim.getLesserBoundaryCorner().getWorld();
        newClaim.lesserBoundaryCorner = new Location(world, (double)newx1, (double)newy1, (double)newz1);
        newClaim.greaterBoundaryCorner = new Location(world, (double)newx2, (double)newy2, (double)newz2);
        ClaimModifiedEvent event = new ClaimModifiedEvent(oldClaim, newClaim, (CommandSender)player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        boolean smaller = false;
        if (!(oldClaim.parent != null || newClaim.contains(oldClaim.getLesserBoundaryCorner(), true, false) && newClaim.contains(oldClaim.getGreaterBoundaryCorner(), true, false))) {
            smaller = true;
            oldClaim.removeSurfaceFluids(newClaim);
        }
        CreateClaimResult result = GriefPrevention.instance.dataStore.resizeClaim(playerData.claimResizing, newClaim.getLesserBoundaryCorner().getBlockX(), newClaim.getGreaterBoundaryCorner().getBlockX(), newClaim.getLesserBoundaryCorner().getBlockY(), newClaim.getGreaterBoundaryCorner().getBlockY(), newClaim.getLesserBoundaryCorner().getBlockZ(), newClaim.getGreaterBoundaryCorner().getBlockZ(), player);
        if (result.succeeded && result.claim != null) {
            int claimBlocksRemaining = 0;
            if (!playerData.claimResizing.isAdminClaim()) {
                UUID ownerID = playerData.claimResizing.ownerID;
                if (playerData.claimResizing.parent != null) {
                    ownerID = playerData.claimResizing.parent.ownerID;
                }
                if (ownerID == player.getUniqueId()) {
                    claimBlocksRemaining = playerData.getRemainingClaimBlocks();
                } else {
                    PlayerData ownerData = this.getPlayerData(ownerID);
                    claimBlocksRemaining = ownerData.getRemainingClaimBlocks();
                    OfflinePlayer owner = GriefPrevention.instance.getServer().getOfflinePlayer(ownerID);
                    if (!owner.isOnline()) {
                        this.clearCachedPlayerData(ownerID);
                    }
                }
            }
            GriefPrevention.sendMessage(player, TextMode.Success, Messages.ClaimResizeSuccess, String.valueOf(claimBlocksRemaining));
            BoundaryVisualization.visualizeClaim(player, result.claim, VisualizationType.CLAIM);
            if (!player.getUniqueId().equals(playerData.claimResizing.ownerID) && playerData.claimResizing.parent == null) {
                GriefPrevention.AddLogEntry(player.getName() + " resized " + playerData.claimResizing.getOwnerName() + "'s claim at " + GriefPrevention.getfriendlyLocationString(playerData.claimResizing.lesserBoundaryCorner) + ".");
            }
            if (oldClaim.getArea() < 1000 && result.claim.getArea() >= 1000 && result.claim.children.size() == 0 && !player.hasPermission("griefprevention.adminclaims")) {
                GriefPrevention.sendMessage(player, TextMode.Info, Messages.BecomeMayor, 200L, new String[0]);
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SubdivisionVideo2, 201L, SUBDIVISION_VIDEO_URL);
            }
            if (smaller && GriefPrevention.instance.creativeRulesApply(oldClaim.getLesserBoundaryCorner())) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.UnclaimCleanupWarning, new String[0]);
                GriefPrevention.instance.restoreClaim(oldClaim, 2400L);
                GriefPrevention.AddLogEntry(player.getName() + " shrank a claim @ " + GriefPrevention.getfriendlyLocationString(playerData.claimResizing.getLesserBoundaryCorner()));
            }
            playerData.claimResizing = null;
            playerData.lastShovelLocation = null;
        } else if (result.claim != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeFailOverlap, new String[0]);
            BoundaryVisualization.visualizeClaim(player, result.claim, VisualizationType.CONFLICT_ZONE);
            GriefPrevention.AddLogEntry(player.getName() + " attempted to create a claim, but conflicted with claim " + result.claim.id, CustomLogEntryTypes.Debug);
        } else {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeFailOverlapRegion, new String[0]);
        }
    }

    void tryAdvertiseAdminAlternatives(Player player) {
        if (player.hasPermission("griefprevention.adminclaims") && player.hasPermission("griefprevention.adjustclaimblocks")) {
            GriefPrevention.sendMessage(player, TextMode.Info, Messages.AdvertiseACandACB, new String[0]);
        } else if (player.hasPermission("griefprevention.adminclaims")) {
            GriefPrevention.sendMessage(player, TextMode.Info, Messages.AdvertiseAdminClaims, new String[0]);
        } else if (player.hasPermission("griefprevention.adjustclaimblocks")) {
            GriefPrevention.sendMessage(player, TextMode.Info, Messages.AdvertiseACB, new String[0]);
        }
    }

    protected void loadMessages() {
        Messages[] messageIDs = Messages.values();
        this.messages = new String[Messages.values().length];
        HashMap<String, CustomizableMessage> defaults = new HashMap<String, CustomizableMessage>();
        this.addDefault(defaults, Messages.RespectingClaims, "Now respecting claims.", null);
        this.addDefault(defaults, Messages.IgnoringClaims, "Now ignoring claims.", null);
        this.addDefault(defaults, Messages.NoCreativeUnClaim, "You can't unclaim this land.  You can only make this claim larger or create additional claims.", null);
        this.addDefault(defaults, Messages.SuccessfulAbandon, "Claims abandoned.  You now have {0} available claim blocks.", "0: remaining blocks");
        this.addDefault(defaults, Messages.RestoreNatureActivate, "Ready to restore some nature!  Right click to restore nature, and use /basicclaims to stop.", null);
        this.addDefault(defaults, Messages.RestoreNatureAggressiveActivate, "Aggressive mode activated.  Do NOT use this underneath anything you want to keep!  Right click to aggressively restore nature, and use /basicclaims to stop.", null);
        this.addDefault(defaults, Messages.FillModeActive, "Fill mode activated with radius {0}.  Right click an area to fill.", "0: fill radius");
        this.addDefault(defaults, Messages.TransferClaimPermission, "That command requires the administrative claims permission.", null);
        this.addDefault(defaults, Messages.TransferClaimMissing, "There's no claim here.  Stand in the administrative claim you want to transfer.", null);
        this.addDefault(defaults, Messages.TransferClaimAdminOnly, "Only administrative claims may be transferred to a player.", null);
        this.addDefault(defaults, Messages.PlayerNotFound2, "No player by that name has logged in recently.", null);
        this.addDefault(defaults, Messages.TransferTopLevel, "Only top level claims (not subdivisions) may be transferred.  Stand outside of the subdivision and try again.", null);
        this.addDefault(defaults, Messages.TransferSuccess, "Claim transferred.", null);
        this.addDefault(defaults, Messages.TrustListNoClaim, "Stand inside the claim you're curious about.", null);
        this.addDefault(defaults, Messages.ClearPermsOwnerOnly, "Only the claim owner can clear all permissions.", null);
        this.addDefault(defaults, Messages.UntrustIndividualAllClaims, "Revoked {0}'s access to ALL your claims.  To set permissions for a single claim, stand inside it.", "0: untrusted player");
        this.addDefault(defaults, Messages.UntrustEveryoneAllClaims, "Cleared permissions in ALL your claims.  To set permissions for a single claim, stand inside it.", null);
        this.addDefault(defaults, Messages.NoPermissionTrust, "You don't have {0}'s permission to manage permissions here.", "0: claim owner's name");
        this.addDefault(defaults, Messages.ClearPermissionsOneClaim, "Cleared permissions in this claim.  To set permission for ALL your claims, stand outside them.", null);
        this.addDefault(defaults, Messages.UntrustIndividualSingleClaim, "Revoked {0}'s access to this claim.  To set permissions for a ALL your claims, stand outside them.", "0: untrusted player");
        this.addDefault(defaults, Messages.OnlySellBlocks, "Claim blocks may only be sold, not purchased.", null);
        this.addDefault(defaults, Messages.BlockPurchaseCost, "Each claim block costs {0}.  Your balance is {1}.", "0: cost of one block; 1: player's account balance");
        this.addDefault(defaults, Messages.ClaimBlockLimit, "You've reached your claim block limit.  You can't purchase more.", null);
        this.addDefault(defaults, Messages.InsufficientFunds, "You don't have enough money.  You need {0}, but you only have {1}.", "0: total cost; 1: player's account balance");
        this.addDefault(defaults, Messages.MaxBonusReached, "Can't purchase {0} more claim blocks. The server has a limit of {1} bonus claim blocks.", "0: block count; 1: bonus claims limit");
        this.addDefault(defaults, Messages.PurchaseConfirmation, "Withdrew {0} from your account.  You now have {1} available claim blocks.", "0: total cost; 1: remaining blocks");
        this.addDefault(defaults, Messages.OnlyPurchaseBlocks, "Claim blocks may only be purchased, not sold.", null);
        this.addDefault(defaults, Messages.BlockSaleValue, "Each claim block is worth {0}.  You have {1} available for sale.", "0: block value; 1: available blocks");
        this.addDefault(defaults, Messages.NotEnoughBlocksForSale, "You don't have that many claim blocks available for sale.", null);
        this.addDefault(defaults, Messages.BlockSaleConfirmation, "Deposited {0} in your account.  You now have {1} available claim blocks.", "0: amount deposited; 1: remaining blocks");
        this.addDefault(defaults, Messages.AdminClaimsMode, "Administrative claims mode active.  Any claims created will be free and editable by other administrators.", null);
        this.addDefault(defaults, Messages.BasicClaimsMode, "Returned to basic claim creation mode.", null);
        this.addDefault(defaults, Messages.SubdivisionMode, "Subdivision mode.  Use your shovel to create subdivisions in your existing claims.  Use /basicclaims to exit.", null);
        this.addDefault(defaults, Messages.SubdivisionVideo2, "Click for Subdivision Help: {0}", "0:video URL");
        this.addDefault(defaults, Messages.DeleteClaimMissing, "There's no claim here.", null);
        this.addDefault(defaults, Messages.DeletionSubdivisionWarning, "This claim includes subdivisions.  If you're sure you want to delete it, use /deleteclaim again.", null);
        this.addDefault(defaults, Messages.DeleteSuccess, "Claim deleted.", null);
        this.addDefault(defaults, Messages.CantDeleteAdminClaim, "You don't have permission to delete administrative claims.", null);
        this.addDefault(defaults, Messages.DeleteAllSuccess, "Deleted all of {0}'s claims.", "0: owner's name");
        this.addDefault(defaults, Messages.NoDeletePermission, "You don't have permission to delete claims.", null);
        this.addDefault(defaults, Messages.AllAdminDeleted, "Deleted all administrative claims.", null);
        this.addDefault(defaults, Messages.AdjustBlocksSuccess, "Adjusted {0}'s bonus claim blocks by {1}.  New total bonus blocks: {2}.", "0: player; 1: adjustment; 2: new total");
        this.addDefault(defaults, Messages.AdjustBlocksAllSuccess, "Adjusted all online players' bonus claim blocks by {0}.", "0: adjustment amount");
        this.addDefault(defaults, Messages.NotTrappedHere, "You can build here.  Save yourself.", null);
        this.addDefault(defaults, Messages.RescuePending, "If you stay put for 10 seconds, you'll be teleported out.  Please wait.", null);
        this.addDefault(defaults, Messages.NonSiegeWorld, "Siege is disabled here.", null);
        this.addDefault(defaults, Messages.AlreadySieging, "You're already involved in a siege.", null);
        this.addDefault(defaults, Messages.AlreadyUnderSiegePlayer, "{0} is already under siege.  Join the party!", "0: defending player");
        this.addDefault(defaults, Messages.NotSiegableThere, "{0} isn't protected there.", "0: defending player");
        this.addDefault(defaults, Messages.SiegeTooFarAway, "You're too far away to siege.", null);
        this.addDefault(defaults, Messages.NoSiegeYourself, "You cannot siege yourself, don't be silly", null);
        this.addDefault(defaults, Messages.NoSiegeDefenseless, "That player is defenseless.  Go pick on somebody else.", null);
        this.addDefault(defaults, Messages.AlreadyUnderSiegeArea, "That area is already under siege.  Join the party!", null);
        this.addDefault(defaults, Messages.NoSiegeAdminClaim, "Siege is disabled in this area.", null);
        this.addDefault(defaults, Messages.SiegeOnCooldown, "You're still on siege cooldown for this defender or claim.  Find another victim.", null);
        this.addDefault(defaults, Messages.SiegeAlert, "You're under siege!  If you log out now, you will die.  You must defeat {0}, wait for him to give up, or escape.", "0: attacker name");
        this.addDefault(defaults, Messages.SiegeConfirmed, "The siege has begun!  If you log out now, you will die.  You must defeat {0}, chase him away, or admit defeat and walk away.", "0: defender name");
        this.addDefault(defaults, Messages.AbandonClaimMissing, "Stand in the claim you want to delete, or consider /abandonallclaims.", null);
        this.addDefault(defaults, Messages.NotYourClaim, "This isn't your claim.", null);
        this.addDefault(defaults, Messages.DeleteTopLevelClaim, "To delete a subdivision, stand inside it.  Otherwise, use /abandontoplevelclaim to delete this claim and all subdivisions.", null);
        this.addDefault(defaults, Messages.AbandonSuccess, "Claim abandoned.  You now have {0} available claim blocks.", "0: remaining claim blocks");
        this.addDefault(defaults, Messages.ConfirmAbandonAllClaims, "Are you sure you want to abandon ALL of your claims?  Please confirm with /abandonallclaims confirm", null);
        this.addDefault(defaults, Messages.CantGrantThatPermission, "You can't grant a permission you don't have yourself.", null);
        this.addDefault(defaults, Messages.GrantPermissionNoClaim, "Stand inside the claim where you want to grant permission.", null);
        this.addDefault(defaults, Messages.GrantPermissionConfirmation, "Granted {0} permission to {1} {2}.", "0: target player; 1: permission description; 2: scope (changed claims)");
        this.addDefault(defaults, Messages.ManageUniversalPermissionsInstruction, "To manage permissions for ALL your claims, stand outside them.", null);
        this.addDefault(defaults, Messages.ManageOneClaimPermissionsInstruction, "To manage permissions for a specific claim, stand inside it.", null);
        this.addDefault(defaults, Messages.CollectivePublic, "the public", "as in 'granted the public permission to...'");
        this.addDefault(defaults, Messages.BuildPermission, "build", null);
        this.addDefault(defaults, Messages.ContainersPermission, "access containers and animals", null);
        this.addDefault(defaults, Messages.AccessPermission, "use buttons and levers", null);
        this.addDefault(defaults, Messages.PermissionsPermission, "manage permissions", null);
        this.addDefault(defaults, Messages.LocationCurrentClaim, "in this claim", null);
        this.addDefault(defaults, Messages.LocationAllClaims, "in all your claims", null);
        this.addDefault(defaults, Messages.PvPImmunityStart, "You're protected from attack by other players as long as your inventory is empty.", null);
        this.addDefault(defaults, Messages.SiegeNoDrop, "You can't give away items while involved in a siege.", null);
        this.addDefault(defaults, Messages.DonateItemsInstruction, "To give away the item(s) in your hand, left-click the chest again.", null);
        this.addDefault(defaults, Messages.ChestFull, "This chest is full.", null);
        this.addDefault(defaults, Messages.DonationSuccess, "Item(s) transferred to chest!", null);
        this.addDefault(defaults, Messages.PlayerTooCloseForFire2, "You can't start a fire this close to another player.", null);
        this.addDefault(defaults, Messages.TooDeepToClaim, "This chest can't be protected because it's too deep underground.  Consider moving it.", null);
        this.addDefault(defaults, Messages.ChestClaimConfirmation, "This chest is protected.", null);
        this.addDefault(defaults, Messages.AutomaticClaimNotification, "This chest and nearby blocks are protected from breakage and theft.", null);
        this.addDefault(defaults, Messages.AutomaticClaimOtherClaimTooClose, "Cannot create a claim for your chest, there is another claim too close!", null);
        this.addDefault(defaults, Messages.UnprotectedChestWarning, "This chest is NOT protected.  Consider using a golden shovel to expand an existing claim or to create a new one.", null);
        this.addDefault(defaults, Messages.ThatPlayerPvPImmune, "You can't injure defenseless players.", null);
        this.addDefault(defaults, Messages.CantFightWhileImmune, "You can't fight someone while you're protected from PvP.", null);
        this.addDefault(defaults, Messages.NoDamageClaimedEntity, "That belongs to {0}.", "0: owner name");
        this.addDefault(defaults, Messages.ShovelBasicClaimMode, "Shovel returned to basic claims mode.", null);
        this.addDefault(defaults, Messages.RemainingBlocks, "You may claim up to {0} more blocks.", "0: remaining blocks");
        this.addDefault(defaults, Messages.CreativeBasicsVideo2, "Click for Land Claim Help: {0}", "{0}: video URL");
        this.addDefault(defaults, Messages.SurvivalBasicsVideo2, "Click for Land Claim Help: {0}", "{0}: video URL");
        this.addDefault(defaults, Messages.TrappedChatKeyword, "trapped;stuck", "When mentioned in chat, players get information about the /trapped command (multiple words can be separated with semi-colons)");
        this.addDefault(defaults, Messages.TrappedInstructions, "Are you trapped in someone's land claim?  Try the /trapped command.", null);
        this.addDefault(defaults, Messages.PvPNoDrop, "You can't drop items while in PvP combat.", null);
        this.addDefault(defaults, Messages.SiegeNoTeleport, "You can't teleport out of a besieged area.", null);
        this.addDefault(defaults, Messages.BesiegedNoTeleport, "You can't teleport into a besieged area.", null);
        this.addDefault(defaults, Messages.SiegeNoContainers, "You can't access containers while involved in a siege.", null);
        this.addDefault(defaults, Messages.PvPNoContainers, "You can't access containers during PvP combat.", null);
        this.addDefault(defaults, Messages.PvPImmunityEnd, "Now you can fight with other players.", null);
        this.addDefault(defaults, Messages.NoBedPermission, "{0} hasn't given you permission to sleep here.", "0: claim owner");
        this.addDefault(defaults, Messages.NoWildernessBuckets, "You may only dump buckets inside your claim(s) or underground.", null);
        this.addDefault(defaults, Messages.NoLavaNearOtherPlayer, "You can't place lava this close to {0}.", "0: nearby player");
        this.addDefault(defaults, Messages.TooFarAway, "That's too far away.", null);
        this.addDefault(defaults, Messages.BlockNotClaimed, "No one has claimed this block.", null);
        this.addDefault(defaults, Messages.BlockClaimed, "That block has been claimed by {0}.", "0: claim owner");
        this.addDefault(defaults, Messages.SiegeNoShovel, "You can't use your shovel tool while involved in a siege.", null);
        this.addDefault(defaults, Messages.RestoreNaturePlayerInChunk, "Unable to restore.  {0} is in that chunk.", "0: nearby player");
        this.addDefault(defaults, Messages.NoCreateClaimPermission, "You don't have permission to claim land.", null);
        this.addDefault(defaults, Messages.ResizeClaimTooNarrow, "This new size would be too small.  Claims must be at least {0} blocks wide.", "0: minimum claim width");
        this.addDefault(defaults, Messages.ResizeNeedMoreBlocks, "You don't have enough blocks for this size.  You need {0} more.", "0: how many needed");
        this.addDefault(defaults, Messages.ClaimResizeSuccess, "Claim resized.  {0} available claim blocks remaining.", "0: remaining blocks");
        this.addDefault(defaults, Messages.ResizeFailOverlap, "Can't resize here because it would overlap another nearby claim.", null);
        this.addDefault(defaults, Messages.ResizeStart, "Resizing claim.  Use your shovel again at the new location for this corner.", null);
        this.addDefault(defaults, Messages.ResizeFailOverlapSubdivision, "You can't create a subdivision here because it would overlap another subdivision.  Consider /abandonclaim to delete it, or use your shovel at a corner to resize it.", null);
        this.addDefault(defaults, Messages.SubdivisionStart, "Subdivision corner set!  Use your shovel at the location for the opposite corner of this new subdivision.", null);
        this.addDefault(defaults, Messages.CreateSubdivisionOverlap, "Your selected area overlaps another subdivision.", null);
        this.addDefault(defaults, Messages.SubdivisionSuccess, "Subdivision created!  Use /trust to share it with friends.", null);
        this.addDefault(defaults, Messages.CreateClaimFailOverlap, "You can't create a claim here because it would overlap your other claim.  Use /abandonclaim to delete it, or use your shovel at a corner to resize it.", null);
        this.addDefault(defaults, Messages.CreateClaimFailOverlapOtherPlayer, "You can't create a claim here because it would overlap {0}'s claim.", "0: other claim owner");
        this.addDefault(defaults, Messages.ClaimsDisabledWorld, "Land claims are disabled in this world.", null);
        this.addDefault(defaults, Messages.ClaimStart, "Claim corner set!  Use the shovel again at the opposite corner to claim a rectangle of land.  To cancel, put your shovel away.", null);
        this.addDefault(defaults, Messages.NewClaimTooNarrow, "This claim would be too small.  Any claim must be at least {0} blocks wide.", "0: minimum claim width");
        this.addDefault(defaults, Messages.ResizeClaimInsufficientArea, "This claim would be too small.  Any claim must use at least {0} total claim blocks.", "0: minimum claim area");
        this.addDefault(defaults, Messages.CreateClaimInsufficientBlocks, "You don't have enough blocks to claim that entire area.  You need {0} more blocks.", "0: additional blocks needed");
        this.addDefault(defaults, Messages.AbandonClaimAdvertisement, "To delete another claim and free up some blocks, use /abandonclaim.", null);
        this.addDefault(defaults, Messages.CreateClaimFailOverlapShort, "Your selected area overlaps an existing claim.", null);
        this.addDefault(defaults, Messages.CreateClaimSuccess, "Claim created!  Use /trust to share it with friends.", null);
        this.addDefault(defaults, Messages.SiegeWinDoorsOpen, "Congratulations!  Buttons and levers are temporarily unlocked.", null);
        this.addDefault(defaults, Messages.RescueAbortedMoved, "You moved!  Rescue cancelled.", null);
        this.addDefault(defaults, Messages.SiegeDoorsLockedEjection, "Looting time is up!  Ejected from the claim.", null);
        this.addDefault(defaults, Messages.NoModifyDuringSiege, "Claims can't be modified while under siege.", null);
        this.addDefault(defaults, Messages.OnlyOwnersModifyClaims, "Only {0} can modify this claim.", "0: owner name");
        this.addDefault(defaults, Messages.NoBuildUnderSiege, "This claim is under siege by {0}.  No one can build here.", "0: attacker name");
        this.addDefault(defaults, Messages.NoBuildPvP, "You can't build in claims during PvP combat.", null);
        this.addDefault(defaults, Messages.NoBuildPermission, "You don't have {0}'s permission to build here.", "0: owner name");
        this.addDefault(defaults, Messages.NonSiegeMaterial, "That material is too tough to break.", null);
        this.addDefault(defaults, Messages.NoOwnerBuildUnderSiege, "You can't make changes while under siege.", null);
        this.addDefault(defaults, Messages.NoAccessPermission, "You don't have {0}'s permission to use that.", "0: owner name.  access permission controls buttons, levers, and beds");
        this.addDefault(defaults, Messages.NoContainersSiege, "This claim is under siege by {0}.  No one can access containers here right now.", "0: attacker name");
        this.addDefault(defaults, Messages.NoContainersPermission, "You don't have {0}'s permission to use that.", "0: owner's name.  containers also include crafting blocks");
        this.addDefault(defaults, Messages.OwnerNameForAdminClaims, "an administrator", "as in 'You don't have an administrator's permission to build here.'");
        this.addDefault(defaults, Messages.UnknownPlayerName, "someone", "Name used for unknown players. UUID will be appended if available: \"someone (01234567-0123-0123-0123-0123456789ab)\"");
        this.addDefault(defaults, Messages.ClaimTooSmallForEntities, "This claim isn't big enough for that.  Try enlarging it.", null);
        this.addDefault(defaults, Messages.TooManyEntitiesInClaim, "This claim has too many entities already.  Try enlarging the claim or removing some animals, monsters, paintings, or minecarts.", null);
        this.addDefault(defaults, Messages.YouHaveNoClaims, "You don't have any land claims.", null);
        this.addDefault(defaults, Messages.ConfirmFluidRemoval, "Abandoning this claim will remove lava inside the claim.  If you're sure, use /abandonclaim again.", null);
        this.addDefault(defaults, Messages.AutoBanNotify, "Auto-banned {0}({1}).  See logs for details.", null);
        this.addDefault(defaults, Messages.AdjustGroupBlocksSuccess, "Adjusted bonus claim blocks for players with the {0} permission by {1}.  New total: {2}.", "0: permission; 1: adjustment amount; 2: new total bonus");
        this.addDefault(defaults, Messages.InvalidPermissionID, "Please specify a player name, or a permission in [brackets].", null);
        this.addDefault(defaults, Messages.HowToClaimRegex, "(^|.*\\W)how\\W.*\\W(claim|protect|lock)(\\W.*|$)", "This is a Java Regular Expression.  Look it up before editing!  It's used to tell players about the demo video when they ask how to claim land.");
        this.addDefault(defaults, Messages.NoBuildOutsideClaims, "You can't build here unless you claim some land first.", null);
        this.addDefault(defaults, Messages.PlayerOfflineTime, "  Last login: {0} days ago.", "0: number of full days since last login");
        this.addDefault(defaults, Messages.BuildingOutsideClaims, "Other players can build here, too.  Consider creating a land claim to protect your work!", null);
        this.addDefault(defaults, Messages.TrappedWontWorkHere, "Sorry, unable to find a safe location to teleport you to.  Contact an admin.", null);
        this.addDefault(defaults, Messages.CommandBannedInPvP, "You can't use that command while in PvP combat.", null);
        this.addDefault(defaults, Messages.UnclaimCleanupWarning, "The land you've unclaimed may be changed by other players or cleaned up by administrators.  If you've built something there you want to keep, you should reclaim it.", null);
        this.addDefault(defaults, Messages.BuySellNotConfigured, "Sorry, buying and selling claim blocks is disabled.", null);
        this.addDefault(defaults, Messages.NoTeleportPvPCombat, "You can't teleport while fighting another player.", null);
        this.addDefault(defaults, Messages.NoTNTDamageAboveSeaLevel, "Warning: TNT will not destroy blocks above sea level.", null);
        this.addDefault(defaults, Messages.NoTNTDamageClaims, "Warning: TNT will not destroy claimed blocks.", null);
        this.addDefault(defaults, Messages.IgnoreClaimsAdvertisement, "To override, use /ignoreclaims.", null);
        this.addDefault(defaults, Messages.NoPermissionForCommand, "You don't have permission to do that.", null);
        this.addDefault(defaults, Messages.ClaimsListNoPermission, "You don't have permission to get information about another player's land claims.", null);
        this.addDefault(defaults, Messages.ExplosivesDisabled, "This claim is now protected from explosions.  Use /claimexplosions again to disable.", null);
        this.addDefault(defaults, Messages.ExplosivesEnabled, "This claim is now vulnerable to explosions.  Use /claimexplosions again to re-enable protections.", null);
        this.addDefault(defaults, Messages.ClaimExplosivesAdvertisement, "To allow explosives to destroy blocks in this land claim, use /claimexplosions.", null);
        this.addDefault(defaults, Messages.PlayerInPvPSafeZone, "That player is in a PvP safe zone.", null);
        this.addDefault(defaults, Messages.NoPistonsOutsideClaims, "Warning: Pistons won't move blocks outside land claims.", null);
        this.addDefault(defaults, Messages.SoftMuted, "Soft-muted {0}.", "0: The changed player's name.");
        this.addDefault(defaults, Messages.UnSoftMuted, "Un-soft-muted {0}.", "0: The changed player's name.");
        this.addDefault(defaults, Messages.DropUnlockAdvertisement, "Other players can't pick up your dropped items unless you /unlockdrops first.", null);
        this.addDefault(defaults, Messages.PickupBlockedExplanation, "You can't pick this up unless {0} uses /unlockdrops.", "0: The item stack's owner.");
        this.addDefault(defaults, Messages.DropUnlockConfirmation, "Unlocked your drops.  Other players may now pick them up (until you die again).", null);
        this.addDefault(defaults, Messages.DropUnlockOthersConfirmation, "Unlocked {0}'s drops.", "0: The owner of the unlocked drops.");
        this.addDefault(defaults, Messages.AdvertiseACandACB, "You may use /acb to give yourself more claim blocks, or /adminclaims to create a free administrative claim.", null);
        this.addDefault(defaults, Messages.AdvertiseAdminClaims, "You could create an administrative land claim instead using /adminclaims, which you'd share with other administrators.", null);
        this.addDefault(defaults, Messages.AdvertiseACB, "You may use /acb to give yourself more claim blocks.", null);
        this.addDefault(defaults, Messages.NotYourPet, "That belongs to {0} until it's given to you with /givepet.", "0: owner name");
        this.addDefault(defaults, Messages.PetGiveawayConfirmation, "Pet transferred.", null);
        this.addDefault(defaults, Messages.PetTransferCancellation, "Pet giveaway cancelled.", null);
        this.addDefault(defaults, Messages.ReadyToTransferPet, "Ready to transfer!  Right-click the pet you'd like to give away, or cancel with /givepet cancel.", null);
        this.addDefault(defaults, Messages.AvoidGriefClaimLand, "Prevent grief!  If you claim your land, you will be grief-proof.", null);
        this.addDefault(defaults, Messages.BecomeMayor, "Subdivide your land claim and become a mayor!", null);
        this.addDefault(defaults, Messages.ClaimCreationFailedOverClaimCountLimit, "You've reached your limit on land claims.  Use /abandonclaim to remove one before creating another.", null);
        this.addDefault(defaults, Messages.CreateClaimFailOverlapRegion, "You can't claim all of this because you're not allowed to build here.", null);
        this.addDefault(defaults, Messages.ResizeFailOverlapRegion, "You don't have permission to build there, so you can't claim that area.", null);
        this.addDefault(defaults, Messages.ShowNearbyClaims, "Found {0} land claims.", "0: Number of claims found.");
        this.addDefault(defaults, Messages.NoChatUntilMove, "Sorry, but you have to move a little more before you can chat.  We get lots of spam bots here.  :)", null);
        this.addDefault(defaults, Messages.SiegeImmune, "That player is immune to /siege.", null);
        this.addDefault(defaults, Messages.SetClaimBlocksSuccess, "Updated accrued claim blocks.", null);
        this.addDefault(defaults, Messages.IgnoreConfirmation, "You're now ignoring chat messages from that player.", null);
        this.addDefault(defaults, Messages.UnIgnoreConfirmation, "You're no longer ignoring chat messages from that player.", null);
        this.addDefault(defaults, Messages.NotIgnoringPlayer, "You're not ignoring that player.", null);
        this.addDefault(defaults, Messages.SeparateConfirmation, "Those players will now ignore each other in chat.", null);
        this.addDefault(defaults, Messages.UnSeparateConfirmation, "Those players will no longer ignore each other in chat.", null);
        this.addDefault(defaults, Messages.NotIgnoringAnyone, "You're not ignoring anyone.", null);
        this.addDefault(defaults, Messages.TrustListHeader, "Explicit permissions here:", "0: The claim's owner");
        this.addDefault(defaults, Messages.Manage, "Manage", null);
        this.addDefault(defaults, Messages.Build, "Build", null);
        this.addDefault(defaults, Messages.Containers, "Containers", null);
        this.addDefault(defaults, Messages.Access, "Access", null);
        this.addDefault(defaults, Messages.HasSubclaimRestriction, "This subclaim does not inherit permissions from the parent", null);
        this.addDefault(defaults, Messages.StartBlockMath, "{0} blocks from play + {1} bonus = {2} total.", null);
        this.addDefault(defaults, Messages.ClaimsListHeader, "Claims:", null);
        this.addDefault(defaults, Messages.ContinueBlockMath, " (-{0} blocks)", null);
        this.addDefault(defaults, Messages.EndBlockMath, " = {0} blocks left to spend", null);
        this.addDefault(defaults, Messages.NoClaimDuringPvP, "You can't claim lands during PvP combat.", null);
        this.addDefault(defaults, Messages.UntrustAllOwnerOnly, "Only the claim owner can clear all its permissions.", null);
        this.addDefault(defaults, Messages.ManagersDontUntrustManagers, "Only the claim owner can demote a manager.", null);
        this.addDefault(defaults, Messages.PlayerNotIgnorable, "You can't ignore that player.", null);
        this.addDefault(defaults, Messages.NoEnoughBlocksForChestClaim, "Because you don't have any claim blocks available, no automatic land claim was created for you.  You can use /claimslist to monitor your available claim block total.", null);
        this.addDefault(defaults, Messages.MustHoldModificationToolForThat, "You must be holding a golden shovel to do that.", null);
        this.addDefault(defaults, Messages.StandInClaimToResize, "Stand inside the land claim you want to resize.", null);
        this.addDefault(defaults, Messages.ClaimsExtendToSky, "Land claims always extend to max build height.", null);
        this.addDefault(defaults, Messages.ClaimsAutoExtendDownward, "Land claims auto-extend deeper into the ground when you place blocks under them.", null);
        this.addDefault(defaults, Messages.MinimumRadius, "Minimum radius is {0}.", "0: minimum radius");
        this.addDefault(defaults, Messages.RadiusRequiresGoldenShovel, "You must be holding a golden shovel when specifying a radius.", null);
        this.addDefault(defaults, Messages.ClaimTooSmallForActiveBlocks, "This claim isn't big enough to support any active block types (hoppers, spawners, beacons...).  Make the claim bigger first.", null);
        this.addDefault(defaults, Messages.TooManyActiveBlocksInClaim, "This claim is at its limit for active block types (hoppers, spawners, beacons...).  Either make it bigger, or remove other active blocks first.", null);
        this.addDefault(defaults, Messages.BookAuthor, "BigScary", null);
        this.addDefault(defaults, Messages.BookTitle, "How to Claim Land", null);
        this.addDefault(defaults, Messages.BookLink, "Click: {0}", "{0}: video URL");
        this.addDefault(defaults, Messages.BookIntro, "Claim land to protect your stuff!  Click the link above to learn land claims in 3 minutes or less.  :)", null);
        this.addDefault(defaults, Messages.BookTools, "Our claim tools are {0} and {1}.", "0: claim modification tool name; 1:claim information tool name");
        this.addDefault(defaults, Messages.BookDisabledChestClaims, "  On this server, placing a chest will NOT claim land for you.", null);
        this.addDefault(defaults, Messages.BookUsefulCommands, "Useful Commands:", null);
        this.addDefault(defaults, Messages.NoProfanity, "Please moderate your language.", null);
        this.addDefault(defaults, Messages.IsIgnoringYou, "That player is ignoring you.", null);
        this.addDefault(defaults, Messages.ConsoleOnlyCommand, "That command may only be executed from the server console.", null);
        this.addDefault(defaults, Messages.WorldNotFound, "World not found.", null);
        this.addDefault(defaults, Messages.TooMuchIpOverlap, "Sorry, there are too many players logged in with your IP address.", null);
        this.addDefault(defaults, Messages.StandInSubclaim, "You need to be standing in a subclaim to restrict it", null);
        this.addDefault(defaults, Messages.SubclaimRestricted, "This subclaim's permissions will no longer inherit from the parent claim", null);
        this.addDefault(defaults, Messages.SubclaimUnrestricted, "This subclaim's permissions will now inherit from the parent claim", null);
        this.addDefault(defaults, Messages.NetherPortalTrapDetectionMessage, "It seems you might be stuck inside a nether portal. We will rescue you in a few seconds if that is the case!", "Sent to player on join, if they left while inside a nether portal.");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(messagesFilePath));
        for (Messages messageID : messageIDs) {
            CustomizableMessage messageData = defaults.get(messageID.name());
            if (messageData == null) {
                GriefPrevention.AddLogEntry("Missing message for " + messageID.name() + ".  Please contact the developer.");
                messageData = new CustomizableMessage(messageID, "Missing message!  ID: " + messageID.name() + ".  Please contact a server admin.", null);
            }
            this.messages[messageID.ordinal()] = config.getString("Messages." + messageID.name() + ".Text", messageData.text);
            config.set("Messages." + messageID.name() + ".Text", (Object)this.messages[messageID.ordinal()]);
            if (messageID != Messages.HowToClaimRegex) {
                this.messages[messageID.ordinal()] = this.messages[messageID.ordinal()].replace('$', '\u00a7');
            }
            if (messageData.notes == null) continue;
            messageData.notes = config.getString("Messages." + messageID.name() + ".Notes", messageData.notes);
            config.set("Messages." + messageID.name() + ".Notes", (Object)messageData.notes);
        }
        try {
            config.options().header("Use a YAML editor like NotepadPlusPlus to edit this file.  \nAfter editing, back up your changes before reloading the server in case you made a syntax error.  \nUse dollar signs ($) for formatting codes, which are documented here: http://minecraft.gamepedia.com/Formatting_codes");
            config.save(messagesFilePath);
        }
        catch (IOException exception) {
            GriefPrevention.AddLogEntry("Unable to write to the configuration file at \"" + messagesFilePath + "\"");
        }
        defaults.clear();
        System.gc();
    }

    private void addDefault(HashMap<String, CustomizableMessage> defaults, Messages id, String text, String notes) {
        CustomizableMessage message = new CustomizableMessage(id, text, notes);
        defaults.put(id.name(), message);
    }

    public synchronized String getMessage(Messages messageID, String ... args) {
        String message = this.messages[messageID.ordinal()];
        for (int i = 0; i < args.length; ++i) {
            String param = args[i];
            message = message.replace("{" + i + "}", param);
        }
        return message;
    }

    protected List<String> convertNameListToUUIDList(List<String> names) {
        if (this.getSchemaVersion() >= 1) {
            return names;
        }
        ArrayList<String> resultNames = new ArrayList<String>();
        for (String name : names) {
            if (name.startsWith("[") || name.equals("public")) {
                resultNames.add(name);
                continue;
            }
            UUID playerID = null;
            try {
                playerID = UUIDFetcher.getUUIDOf(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (playerID == null) continue;
            resultNames.add(playerID.toString());
        }
        return resultNames;
    }

    abstract void close();

    Set<Claim> getNearbyClaims(Location location) {
        HashSet<Claim> claims = new HashSet<Claim>();
        Chunk lesserChunk = location.getWorld().getChunkAt(location.subtract(150.0, 0.0, 150.0));
        Chunk greaterChunk = location.getWorld().getChunkAt(location.add(300.0, 0.0, 300.0));
        for (int chunk_x = lesserChunk.getX(); chunk_x <= greaterChunk.getX(); ++chunk_x) {
            for (int chunk_z = lesserChunk.getZ(); chunk_z <= greaterChunk.getZ(); ++chunk_z) {
                Chunk chunk = location.getWorld().getChunkAt(chunk_x, chunk_z);
                Long chunkID = DataStore.getChunkHash(chunk.getBlock(0, 0, 0).getLocation());
                ArrayList<Claim> claimsInChunk = this.chunksToClaimsMap.get(chunkID);
                if (claimsInChunk == null) continue;
                for (Claim claim : claimsInChunk) {
                    if (!claim.inDataStore || !claim.getLesserBoundaryCorner().getWorld().equals((Object)location.getWorld())) continue;
                    claims.add(claim);
                }
            }
        }
        return claims;
    }

    void deleteClaimsInWorld(World world, boolean deleteAdminClaims) {
        for (int i = 0; i < this.claims.size(); ++i) {
            Claim claim = this.claims.get(i);
            if (!claim.getLesserBoundaryCorner().getWorld().equals((Object)world) || !deleteAdminClaims && claim.isAdminClaim()) continue;
            this.deleteClaim(claim, false, false);
            --i;
        }
    }

    public class NoTransferException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        NoTransferException(String message) {
            super(message);
        }
    }

    private class SavePlayerDataThread
    extends Thread {
        private final UUID playerID;
        private final PlayerData playerData;

        SavePlayerDataThread(UUID playerID, PlayerData playerData) {
            this.playerID = playerID;
            this.playerData = playerData;
        }

        @Override
        public void run() {
            this.playerData.getAccruedClaimBlocks();
            this.playerData.getClaims();
            DataStore.this.asyncSavePlayerData(this.playerID, this.playerData);
        }
    }
}

