/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.Collection;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.events.AccrueClaimBlocksEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

class DeliverClaimBlocksTask
implements Runnable {
    private final Player player;
    private final GriefPrevention instance;
    private final int idleThresholdSquared;

    public DeliverClaimBlocksTask(Player player, GriefPrevention instance) {
        this.player = player;
        this.instance = instance;
        this.idleThresholdSquared = instance.config_claims_accruedIdleThreshold * instance.config_claims_accruedIdleThreshold;
    }

    @Override
    public void run() {
        if (this.player == null) {
            Collection players = GriefPrevention.instance.getServer().getOnlinePlayers();
            long i = 0L;
            for (Player onlinePlayer : players) {
                DeliverClaimBlocksTask newTask = new DeliverClaimBlocksTask(onlinePlayer, this.instance);
                this.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)newTask, i++);
            }
            return;
        }
        if (!this.player.isOnline()) {
            return;
        }
        DataStore dataStore = this.instance.dataStore;
        PlayerData playerData = dataStore.getPlayerData(this.player.getUniqueId());
        boolean isIdle = false;
        try {
            isIdle = this.player.isInsideVehicle() || this.player.getLocation().getBlock().isLiquid() || playerData.lastAfkCheckLocation != null && !(playerData.lastAfkCheckLocation.distanceSquared(this.player.getLocation()) > (double)this.idleThresholdSquared);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        playerData.lastAfkCheckLocation = this.player.getLocation();
        try {
            int accrualRate = this.instance.config_claims_blocksAccruedPerHour_default;
            if (isIdle) {
                if (this.instance.config_claims_accruedIdlePercent <= 0) {
                    GriefPrevention.AddLogEntry(this.player.getName() + " wasn't active enough to accrue claim blocks this round.", CustomLogEntryTypes.Debug, true);
                    return;
                }
                accrualRate = (int)((double)accrualRate * ((double)this.instance.config_claims_accruedIdlePercent / 100.0));
            }
            AccrueClaimBlocksEvent event = new AccrueClaimBlocksEvent(this.player, accrualRate, isIdle);
            this.instance.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                GriefPrevention.AddLogEntry(this.player.getName() + " claim block delivery was canceled by another plugin.", CustomLogEntryTypes.Debug, true);
                return;
            }
            accrualRate = event.getBlocksToAccrue();
            if (accrualRate < 0) {
                accrualRate = 0;
            }
            playerData.accrueBlocks(accrualRate);
            GriefPrevention.AddLogEntry("Delivering " + event.getBlocksToAccrue() + " blocks to " + this.player.getName(), CustomLogEntryTypes.Debug, true);
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("Problem delivering claim blocks to player " + this.player.getName() + ":");
            e.printStackTrace();
        }
    }
}

