/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import me.ryanhamshire.GriefPrevention.GriefPrevention;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyHandler
implements Listener {
    private final GriefPrevention instance;
    private boolean setupDone = false;
    private EconomyWrapper economy = null;

    public EconomyHandler(GriefPrevention instance) {
        this.instance = instance;
    }

    EconomyWrapper getWrapper() {
        this.loadEconomy(false);
        return this.economy;
    }

    @EventHandler
    private void onPluginEnable(PluginEnableEvent event) {
        this.loadEconomy(true);
    }

    @EventHandler
    private void onPluginDisable(PluginDisableEvent event) {
        this.loadEconomy(true);
    }

    private void loadEconomy(boolean setupState) {
        if (setupState != this.setupDone) {
            return;
        }
        if (!(this.instance.config_economy_claimBlocksPurchaseCost > 0.0) && !(this.instance.config_economy_claimBlocksSellValue > 0.0)) {
            this.finishSetup(false, null);
            return;
        }
        try {
            Class.forName("net.milkbowl.vault.economy.Economy");
        }
        catch (ClassNotFoundException e) {
            this.finishSetup(false, "ERROR: GriefPrevention requires Vault for economy integration.");
            return;
        }
        RegisteredServiceProvider registration = this.instance.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null) {
            this.finishSetup(false, "ERROR: Vault was unable to find a supported economy plugin.  Either install a Vault-compatible economy plugin, or set both of the economy config variables to zero.");
            return;
        }
        Economy newEconomy = (Economy)registration.getProvider();
        if (this.economy != null && this.economy.getEconomy().equals((Object)newEconomy)) {
            return;
        }
        this.setupDone = false;
        this.economy = new EconomyWrapper(newEconomy);
        this.finishSetup(true, "Hooked into economy: " + this.economy.economy.getName() + ". Ready to buy/sell claim blocks!");
    }

    private void finishSetup(boolean ready, String log) {
        if (!ready) {
            this.economy = null;
        }
        if (log != null && !this.setupDone) {
            GriefPrevention.AddLogEntry(log);
        }
        this.setupDone = true;
    }

    static class EconomyWrapper {
        private final Economy economy;

        private EconomyWrapper(Economy economy) {
            this.economy = economy;
        }

        Economy getEconomy() {
            return this.economy;
        }
    }
}

