/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.List;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;

class EntityCleanupTask
implements Runnable {
    private final double percentageStart;

    public EntityCleanupTask(double percentageStart) {
        this.percentageStart = percentageStart;
    }

    @Override
    public void run() {
        ArrayList<World> worlds = new ArrayList<World>();
        for (World world : GriefPrevention.instance.getServer().getWorlds()) {
            if (GriefPrevention.instance.config_claims_worldModes.get(world) != ClaimsMode.Creative) continue;
            worlds.add(world);
        }
        for (World world : worlds) {
            List entities = world.getEntities();
            int k = (int)((double)entities.size() * (this.percentageStart + 0.1));
            Claim cachedClaim = null;
            for (int j = (int)((double)entities.size() * this.percentageStart); j < entities.size() && j < k; ++j) {
                Entity entity = (Entity)entities.get(j);
                boolean remove = false;
                if (entity instanceof Boat) {
                    Boat boat = (Boat)entity;
                    if (boat.isEmpty()) {
                        remove = true;
                    }
                } else if (entity instanceof Vehicle) {
                    Vehicle vehicle = (Vehicle)entity;
                    if (vehicle.getVelocity().lengthSquared() != 0.0) {
                        if (vehicle.isEmpty() || !(vehicle.getPassenger() instanceof Player)) {
                            remove = true;
                        }
                    } else {
                        Material material = world.getBlockAt(vehicle.getLocation()).getType();
                        if (material != Material.RAIL && material != Material.POWERED_RAIL && material != Material.DETECTOR_RAIL) {
                            remove = true;
                        }
                    }
                } else if (!(entity instanceof Player)) {
                    Claim claim = GriefPrevention.instance.dataStore.getClaimAt(entity.getLocation(), false, cachedClaim);
                    if (claim != null) {
                        cachedClaim = claim;
                    } else {
                        remove = true;
                    }
                }
                if (!remove) continue;
                GriefPrevention.AddLogEntry("Removing entity " + entity.getType().name() + " @ " + String.valueOf(entity.getLocation()), CustomLogEntryTypes.Debug, true);
                entity.remove();
            }
        }
        ArrayList<Claim> claims = GriefPrevention.instance.dataStore.claims;
        int k = (int)((double)claims.size() * (this.percentageStart + 0.05));
        for (int j = (int)((double)claims.size() * this.percentageStart); j < claims.size() && j < k; ++j) {
            Claim claim = (Claim)claims.get(j);
            if (!GriefPrevention.instance.creativeRulesApply(claim.getLesserBoundaryCorner())) continue;
            claim.allowMoreEntities(true);
        }
        double nextRunPercentageStart = this.percentageStart + 0.05;
        if (nextRunPercentageStart > 0.99) {
            nextRunPercentageStart = 0.0;
        }
        EntityCleanupTask task = new EntityCleanupTask(nextRunPercentageStart);
        GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task, 1200L);
    }
}

