/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.EntityEventHandler;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.events.PreventPvPEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionEffectTypeCategory;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDamageHandler
implements Listener {
    private static final Set<PotionEffectType> GRIEF_EFFECTS = Set.of(PotionEffectType.INSTANT_DAMAGE, PotionEffectType.POISON, PotionEffectType.WITHER, PotionEffectType.JUMP_BOOST, PotionEffectType.LEVITATION);
    private static final Set<EntityType> TEMPTABLE_SEMI_HOSTILES = Set.of(EntityType.HOGLIN, EntityType.POLAR_BEAR, EntityType.PANDA);
    @NotNull
    private final DataStore dataStore;
    @NotNull
    private final GriefPrevention instance;
    @NotNull
    private final NamespacedKey luredByPlayer;

    EntityDamageHandler(@NotNull DataStore dataStore, @NotNull GriefPrevention plugin) {
        this.dataStore = dataStore;
        this.instance = plugin;
        this.luredByPlayer = new NamespacedKey((Plugin)plugin, "lured_by_player");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityTarget(@NotNull EntityTargetEvent event) {
        if (!this.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!TEMPTABLE_SEMI_HOSTILES.contains(event.getEntityType())) {
            return;
        }
        if (event.getReason() == EntityTargetEvent.TargetReason.TEMPT) {
            event.getEntity().getPersistentDataContainer().set(this.luredByPlayer, PersistentDataType.BYTE, (Object)1);
        } else {
            event.getEntity().getPersistentDataContainer().remove(this.luredByPlayer);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamage(@NotNull EntityDamageEvent event) {
        this.handleEntityDamageEvent(event, true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityCombustByEntity(@NotNull EntityCombustByEntityEvent event) {
        this.handleEntityDamageEvent(event, false);
    }

    private void handleEntityDamageEvent(@NotNull EntityCombustByEntityEvent event, boolean sendMessages) {
        Entity entity;
        Projectile projectile;
        ProjectileSource projectileSource;
        if (this.isHostile(event.getEntity())) {
            return;
        }
        if (event.getEntity() instanceof Horse && !this.instance.config_claims_protectHorses) {
            return;
        }
        if (event.getEntity() instanceof Donkey && !this.instance.config_claims_protectDonkeys) {
            return;
        }
        if (event.getEntity() instanceof Mule && !this.instance.config_claims_protectDonkeys) {
            return;
        }
        if (event.getEntity() instanceof Llama && !this.instance.config_claims_protectLlamas) {
            return;
        }
        if (event.getEntityType() == EntityType.ITEM && event.getEntity().hasMetadata("GP_ITEMOWNER")) {
            event.setCancelled(true);
        }
        if (this.handlePetDamageByEnvironment(event)) {
            return;
        }
        if (event.getCombuster() instanceof LightningStrike && event.getCombuster().hasMetadata("GP_TRIDENT")) {
            event.setCancelled(true);
            return;
        }
        Player attacker = null;
        Projectile arrow = null;
        Entity damageSource = event.getCombuster();
        if (damageSource instanceof Player) {
            Player damager;
            attacker = damager = (Player)damageSource;
        } else if (damageSource instanceof Projectile && (projectileSource = (arrow = (projectile = (Projectile)damageSource)).getShooter()) instanceof Player) {
            Player shooter;
            attacker = shooter = (Player)projectileSource;
        }
        if (this.instance.pvpRulesApply(event.getEntity().getWorld()) && (entity = event.getEntity()) instanceof Player) {
            Player defender = (Player)entity;
            if (attacker != null && this.handlePvpDamageByPlayer(event, attacker, defender, sendMessages)) {
                return;
            }
        }
        if (!this.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
            return;
        }
        if (this.handleClaimedBuildTrustDamageByEntity(event, attacker, sendMessages)) {
            return;
        }
        if (this.handleCreatureDamageByEntity(event, attacker, arrow, sendMessages)) {
            return;
        }
    }

    private void handleEntityDamageEvent(@NotNull EntityDamageEvent event, boolean sendMessages) {
        Projectile projectile;
        ProjectileSource projectileSource;
        if (this.isHostile(event.getEntity())) {
            return;
        }
        if (event.getEntity() instanceof Horse && !this.instance.config_claims_protectHorses) {
            return;
        }
        if (event.getEntity() instanceof Donkey && !this.instance.config_claims_protectDonkeys) {
            return;
        }
        if (event.getEntity() instanceof Mule && !this.instance.config_claims_protectDonkeys) {
            return;
        }
        if (event.getEntity() instanceof Llama && !this.instance.config_claims_protectLlamas) {
            return;
        }
        if (event.getEntityType() == EntityType.ITEM && event.getEntity().hasMetadata("GP_ITEMOWNER")) {
            event.setCancelled(true);
        }
        if (this.handlePetDamageByEnvironment(event)) {
            return;
        }
        if (this.handleEntityDamageByBlockExplosion(event)) {
            return;
        }
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent subEvent = (EntityDamageByEntityEvent)event;
        if (subEvent.getDamager() instanceof LightningStrike && subEvent.getDamager().hasMetadata("GP_TRIDENT")) {
            event.setCancelled(true);
            return;
        }
        Player attacker = null;
        Projectile arrow = null;
        Entity damageSource = subEvent.getDamager();
        if (damageSource instanceof Player) {
            Player damager;
            attacker = damager = (Player)damageSource;
        } else if (damageSource instanceof Projectile && (projectileSource = (arrow = (projectile = (Projectile)damageSource)).getShooter()) instanceof Player) {
            Player shooter;
            attacker = shooter = (Player)projectileSource;
        }
        if (this.instance.pvpRulesApply(event.getEntity().getWorld())) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player defender = (Player)entity;
                if (this.handlePvpDamageByPet(subEvent, attacker, defender)) {
                    return;
                }
                if (this.handlePvpDamageByLingeringPotion(subEvent, attacker, defender)) {
                    return;
                }
                if (attacker != null && this.handlePvpDamageByPlayer(subEvent, attacker, defender, sendMessages)) {
                    return;
                }
            } else {
                entity = event.getEntity();
                if (entity instanceof Tameable) {
                    Tameable tameable = (Tameable)entity;
                    if (attacker != null && this.handlePvpPetDamageByPlayer(subEvent, tameable, attacker, sendMessages)) {
                        return;
                    }
                }
            }
        }
        if (!this.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
            return;
        }
        if (this.handleClaimedBuildTrustDamageByEntity(subEvent, attacker, sendMessages)) {
            return;
        }
        if (this.handleCreatureDamageByEntity(subEvent, attacker, arrow, sendMessages)) {
            return;
        }
    }

    private boolean isHostile(@NotNull Entity entity) {
        if (entity instanceof Monster) {
            return true;
        }
        EntityType type = entity.getType();
        if (type == EntityType.GHAST || type == EntityType.MAGMA_CUBE || type == EntityType.SHULKER) {
            return true;
        }
        if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            return slime.getSize() > 0 || slime.getTicksLived() < 1200;
        }
        if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            return rabbit.getRabbitType() == Rabbit.Type.THE_KILLER_BUNNY;
        }
        if (TEMPTABLE_SEMI_HOSTILES.contains(type) && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return !entity.getPersistentDataContainer().has(this.luredByPlayer, PersistentDataType.BYTE) && mob.getTarget() != null;
        }
        return false;
    }

    private boolean handlePetDamageByEnvironment(@NotNull EntityDamageEvent event) {
        Tameable tameable;
        Entity entity;
        if (this.instance.pvpRulesApply(event.getEntity().getWorld()) || !((entity = event.getEntity()) instanceof Tameable) || !(tameable = (Tameable)entity).isTamed()) {
            return false;
        }
        switch (event.getCause()) {
            case BLOCK_EXPLOSION: 
            case ENTITY_EXPLOSION: 
            case FALLING_BLOCK: 
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: 
            case SUFFOCATION: 
            case CONTACT: 
            case DROWNING: {
                event.setCancelled(true);
                return true;
            }
        }
        return false;
    }

    private boolean handlePetDamageByEnvironment(@NotNull EntityCombustByEntityEvent event) {
        Tameable tameable;
        Entity entity;
        return !this.instance.pvpRulesApply(event.getEntity().getWorld()) && (entity = event.getEntity()) instanceof Tameable && (tameable = (Tameable)entity).isTamed();
    }

    private boolean handleEntityDamageByBlockExplosion(@NotNull EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            return false;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            return false;
        }
        Claim claim = this.dataStore.getClaimAt(entity.getLocation(), false, null);
        if (claim == null) {
            return false;
        }
        event.setCancelled(true);
        return true;
    }

    private boolean handlePvpDamageByLingeringPotion(@NotNull EntityDamageByEntityEvent event, @Nullable Player attacker, @NotNull Player damaged) {
        if (event.getDamager().getType() != EntityType.AREA_EFFECT_CLOUD) {
            return false;
        }
        PlayerData damagedData = this.dataStore.getPlayerData(damaged.getUniqueId());
        if (this.instance.config_pvp_protectFreshSpawns && damagedData.pvpImmune) {
            event.setCancelled(true);
            return true;
        }
        Claim damagedClaim = this.dataStore.getClaimAt(damaged.getLocation(), false, damagedData.lastClaim);
        if (damagedClaim != null) {
            damagedData.lastClaim = damagedClaim;
            if (this.instance.claimIsPvPSafeZone(damagedClaim)) {
                PreventPvPEvent pvpEvent = new PreventPvPEvent(damagedClaim, attacker, (Entity)damaged);
                Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                if (!pvpEvent.isCancelled()) {
                    event.setCancelled(true);
                }
                return true;
            }
        }
        return false;
    }

    private boolean handlePvpDamageByPlayer(@NotNull EntityDamageByEntityEvent event, @NotNull Player attacker, @NotNull Player defender, boolean sendMessages) {
        if (attacker == defender) {
            return false;
        }
        PlayerData defenderData = this.dataStore.getPlayerData(defender.getUniqueId());
        PlayerData attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
        if (this.instance.config_pvp_protectFreshSpawns && (attackerData.pvpImmune || defenderData.pvpImmune)) {
            event.setCancelled(true);
            if (sendMessages) {
                GriefPrevention.sendMessage(attacker, TextMode.Err, attackerData.pvpImmune ? Messages.CantFightWhileImmune : Messages.ThatPlayerPvPImmune, new String[0]);
            }
            return true;
        }
        if (attackerData.ignoreClaims || !this.instance.config_pvp_noCombatInPlayerLandClaims && !this.instance.config_pvp_noCombatInAdminLandClaims) {
            return false;
        }
        Consumer<Messages> cancelHandler = message -> {
            event.setCancelled(true);
            if (sendMessages) {
                GriefPrevention.sendMessage(attacker, TextMode.Err, message, new String[0]);
            }
        };
        return this.handlePvpInClaim(attacker, defender, attacker.getLocation(), attackerData, () -> cancelHandler.accept(Messages.CantFightWhileImmune)) || this.handlePvpInClaim(attacker, defender, defender.getLocation(), defenderData, () -> cancelHandler.accept(Messages.PlayerInPvPSafeZone));
    }

    private boolean handlePvpDamageByPlayer(@NotNull EntityCombustByEntityEvent event, @NotNull Player attacker, @NotNull Player defender, boolean sendMessages) {
        if (attacker == defender) {
            return false;
        }
        PlayerData defenderData = this.dataStore.getPlayerData(defender.getUniqueId());
        PlayerData attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
        if (this.instance.config_pvp_protectFreshSpawns && (attackerData.pvpImmune || defenderData.pvpImmune)) {
            event.setCancelled(true);
            if (sendMessages) {
                GriefPrevention.sendMessage(attacker, TextMode.Err, attackerData.pvpImmune ? Messages.CantFightWhileImmune : Messages.ThatPlayerPvPImmune, new String[0]);
            }
            return true;
        }
        if (attackerData.ignoreClaims || !this.instance.config_pvp_noCombatInPlayerLandClaims && !this.instance.config_pvp_noCombatInAdminLandClaims) {
            return false;
        }
        Consumer<Messages> cancelHandler = message -> {
            event.setCancelled(true);
            if (sendMessages) {
                GriefPrevention.sendMessage(attacker, TextMode.Err, message, new String[0]);
            }
        };
        return this.handlePvpInClaim(attacker, defender, attacker.getLocation(), attackerData, () -> cancelHandler.accept(Messages.CantFightWhileImmune)) || this.handlePvpInClaim(attacker, defender, defender.getLocation(), defenderData, () -> cancelHandler.accept(Messages.PlayerInPvPSafeZone));
    }

    private boolean handlePvpDamageByPet(@NotNull EntityDamageByEntityEvent event, @Nullable Player attacker, @NotNull Player defender) {
        Tameable pet;
        Entity entity = event.getDamager();
        if (!(entity instanceof Tameable) || !(pet = (Tameable)entity).isTamed() || pet.getOwner() == null) {
            return false;
        }
        PlayerData defenderData = this.dataStore.getPlayerData(defender.getUniqueId());
        Runnable cancelHandler = () -> {
            event.setCancelled(true);
            pet.setTarget(null);
        };
        if (defenderData.pvpImmune) {
            cancelHandler.run();
            return true;
        }
        return this.handlePvpInClaim(attacker, defender, defender.getLocation(), defenderData, cancelHandler);
    }

    private boolean handlePvpPetDamageByPlayer(@NotNull EntityDamageByEntityEvent event, @NotNull Tameable pet, @NotNull Player attacker, boolean sendMessages) {
        Claim claim;
        if (!pet.isTamed()) {
            return false;
        }
        AnimalTamer owner = pet.getOwner();
        if (owner == null) {
            return false;
        }
        if (attacker.equals((Object)owner)) {
            return true;
        }
        PlayerData attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
        if (attackerData.ignoreClaims) {
            return true;
        }
        if (attackerData.pvpImmune) {
            event.setCancelled(true);
            if (sendMessages) {
                GriefPrevention.sendMessage(attacker, TextMode.Err, Messages.CantFightWhileImmune, new String[0]);
            }
            return true;
        }
        if (event.getEntity().getType() == EntityType.WOLF && pet.getTarget() == attacker) {
            return true;
        }
        if (!this.instance.config_pvp_protectPets) {
            claim = this.dataStore.getClaimAt(event.getEntity().getLocation(), false, attackerData.lastClaim);
            if (claim == null) {
                return true;
            }
            attackerData.lastClaim = claim;
        } else {
            claim = new Claim(event.getEntity().getLocation(), event.getEntity().getLocation(), null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null);
        }
        PreventPvPEvent pvpEvent = new PreventPvPEvent(claim, attacker, (Entity)pet);
        Bukkit.getPluginManager().callEvent((Event)pvpEvent);
        if (!pvpEvent.isCancelled()) {
            event.setCancelled(true);
            if (sendMessages) {
                String ownerName = GriefPrevention.lookupPlayerName(owner);
                Object message = this.dataStore.getMessage(Messages.NoDamageClaimedEntity, ownerName);
                if (attacker.hasPermission("griefprevention.ignoreclaims")) {
                    message = (String)message + "  " + this.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                }
                GriefPrevention.sendMessage(attacker, TextMode.Err, (String)message);
            }
        }
        return true;
    }

    private boolean handlePvpInClaim(@Nullable Player attacker, @NotNull Player defender, @NotNull Location location, @NotNull PlayerData playerData, @NotNull Runnable cancelHandler) {
        if (playerData.inPvpCombat()) {
            return false;
        }
        Claim claim = this.dataStore.getClaimAt(location, false, playerData.lastClaim);
        if (claim == null || !this.instance.claimIsPvPSafeZone(claim)) {
            return false;
        }
        playerData.lastClaim = claim;
        PreventPvPEvent pvpEvent = new PreventPvPEvent(claim, attacker, (Entity)defender);
        Bukkit.getPluginManager().callEvent((Event)pvpEvent);
        if (!pvpEvent.isCancelled()) {
            cancelHandler.run();
        }
        return true;
    }

    private boolean handleClaimedBuildTrustDamageByEntity(@NotNull EntityDamageByEntityEvent event, @Nullable Player attacker, boolean sendMessages) {
        Claim claim;
        EvokerFangs fangs;
        Projectile projectile;
        Entity entity;
        EntityType entityType = event.getEntityType();
        if (entityType != EntityType.ITEM_FRAME && entityType != EntityType.GLOW_ITEM_FRAME && entityType != EntityType.ARMOR_STAND && entityType != EntityType.VILLAGER && entityType != EntityType.END_CRYSTAL && entityType != EntityType.ITEM_DISPLAY) {
            return false;
        }
        if (entityType == EntityType.VILLAGER && (!this.instance.config_claims_protectCreatures || event.getDamager() instanceof Zombie || event.getDamager() instanceof Raider || event.getDamager() instanceof Vex || (entity = event.getDamager()) instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof Raider || (entity = event.getDamager()) instanceof EvokerFangs && (fangs = (EvokerFangs)entity).getOwner() instanceof Raider)) {
            return true;
        }
        Claim cachedClaim = null;
        if (attacker != null) {
            PlayerData playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
            cachedClaim = playerData.lastClaim;
        }
        if ((claim = this.dataStore.getClaimAt(event.getEntity().getLocation(), false, cachedClaim)) == null) {
            return false;
        }
        if (attacker == null) {
            event.setCancelled(true);
            return true;
        }
        Supplier<String> failureReason = claim.checkPermission(attacker, ClaimPermission.Build, (Event)event);
        if (failureReason == null) {
            return false;
        }
        event.setCancelled(true);
        if (sendMessages) {
            GriefPrevention.sendMessage(attacker, TextMode.Err, failureReason.get());
        }
        return true;
    }

    private boolean handleClaimedBuildTrustDamageByEntity(@NotNull EntityCombustByEntityEvent event, @Nullable Player attacker, boolean sendMessages) {
        Claim claim;
        EvokerFangs fangs;
        Projectile projectile;
        Entity entity;
        EntityType entityType = event.getEntityType();
        if (entityType != EntityType.ITEM_FRAME && entityType != EntityType.GLOW_ITEM_FRAME && entityType != EntityType.ARMOR_STAND && entityType != EntityType.VILLAGER && entityType != EntityType.END_CRYSTAL) {
            return false;
        }
        if (entityType == EntityType.VILLAGER && (!this.instance.config_claims_protectCreatures || event.getCombuster() instanceof Zombie || event.getCombuster() instanceof Raider || event.getCombuster() instanceof Vex || (entity = event.getCombuster()) instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof Raider || (entity = event.getCombuster()) instanceof EvokerFangs && (fangs = (EvokerFangs)entity).getOwner() instanceof Raider)) {
            return true;
        }
        Claim cachedClaim = null;
        if (attacker != null) {
            PlayerData playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
            cachedClaim = playerData.lastClaim;
        }
        if ((claim = this.dataStore.getClaimAt(event.getEntity().getLocation(), false, cachedClaim)) == null) {
            return false;
        }
        if (attacker == null) {
            event.setCancelled(true);
            return true;
        }
        Supplier<String> failureReason = claim.checkPermission(attacker, ClaimPermission.Build, (Event)event);
        if (failureReason == null) {
            return false;
        }
        event.setCancelled(true);
        if (sendMessages) {
            GriefPrevention.sendMessage(attacker, TextMode.Err, failureReason.get());
        }
        return true;
    }

    private boolean handleCreatureDamageByEntity(@NotNull EntityDamageByEntityEvent event, @Nullable Player attacker, @Nullable Projectile arrow, boolean sendMessages) {
        Supplier<String> noContainersReason;
        Claim claim;
        if (!(event.getEntity() instanceof Creature) || !this.instance.config_claims_protectCreatures) {
            return false;
        }
        if (this.handlePetDamageByEntity(event, attacker, sendMessages)) {
            return true;
        }
        Entity damageSource = event.getDamager();
        EntityType damageSourceType = damageSource.getType();
        if (!(attacker != null || damageSourceType == EntityType.CREEPER || damageSourceType == EntityType.WITHER || damageSourceType == EntityType.END_CRYSTAL || damageSourceType == EntityType.AREA_EFFECT_CLOUD || damageSourceType == EntityType.WITCH || damageSource instanceof Projectile || damageSource instanceof Explosive || damageSource instanceof ExplosiveMinecart)) {
            return true;
        }
        Claim cachedClaim = null;
        PlayerData playerData = null;
        if (attacker != null) {
            playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
            cachedClaim = playerData.lastClaim;
        }
        if ((claim = this.dataStore.getClaimAt(event.getEntity().getLocation(), false, cachedClaim)) == null) {
            return false;
        }
        if (attacker == null) {
            event.setCancelled(true);
            if (arrow != null) {
                arrow.remove();
            }
            return true;
        }
        playerData.lastClaim = claim;
        boolean bl = damageSourceType != EntityType.FIREWORK_ROCKET;
        Supplier<String> override = null;
        if (sendMessages &= bl) {
            Player finalAttacker = attacker;
            override = () -> {
                Object message = this.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
                if (finalAttacker.hasPermission("griefprevention.ignoreclaims")) {
                    message = (String)message + "  " + this.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                }
                return message;
            };
        }
        if ((noContainersReason = claim.checkPermission(attacker, ClaimPermission.Inventory, (Event)event, override)) == null) {
            return true;
        }
        event.setCancelled(true);
        this.preventInfiniteBounce(arrow, event.getEntity());
        if (sendMessages) {
            GriefPrevention.sendMessage(attacker, TextMode.Err, noContainersReason.get());
        }
        return true;
    }

    private boolean handleCreatureDamageByEntity(@NotNull EntityCombustByEntityEvent event, @Nullable Player attacker, @Nullable Projectile arrow, boolean sendMessages) {
        Supplier<String> noContainersReason;
        Claim claim;
        if (!(event.getEntity() instanceof Creature) || !this.instance.config_claims_protectCreatures) {
            return false;
        }
        Entity damageSource = event.getCombuster();
        EntityType damageSourceType = damageSource.getType();
        if (!(attacker != null || damageSourceType == EntityType.CREEPER || damageSourceType == EntityType.WITHER || damageSourceType == EntityType.END_CRYSTAL || damageSourceType == EntityType.AREA_EFFECT_CLOUD || damageSourceType == EntityType.WITCH || damageSource instanceof Projectile || damageSource instanceof Explosive || damageSource instanceof ExplosiveMinecart)) {
            return true;
        }
        Claim cachedClaim = null;
        PlayerData playerData = null;
        if (attacker != null) {
            playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
            cachedClaim = playerData.lastClaim;
        }
        if ((claim = this.dataStore.getClaimAt(event.getEntity().getLocation(), false, cachedClaim)) == null) {
            return false;
        }
        if (attacker == null) {
            event.setCancelled(true);
            if (arrow != null) {
                arrow.remove();
            }
            return true;
        }
        playerData.lastClaim = claim;
        boolean bl = damageSourceType != EntityType.FIREWORK_ROCKET;
        Supplier<String> override = null;
        if (sendMessages &= bl) {
            Player finalAttacker = attacker;
            override = () -> {
                Object message = this.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
                if (finalAttacker.hasPermission("griefprevention.ignoreclaims")) {
                    message = (String)message + "  " + this.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                }
                return message;
            };
        }
        if ((noContainersReason = claim.checkPermission(attacker, ClaimPermission.Inventory, (Event)event, override)) == null) {
            return true;
        }
        event.setCancelled(true);
        this.preventInfiniteBounce(arrow, event.getEntity());
        if (sendMessages) {
            GriefPrevention.sendMessage(attacker, TextMode.Err, noContainersReason.get());
        }
        return true;
    }

    private boolean handlePetDamageByEntity(@NotNull EntityDamageByEntityEvent event, @Nullable Player attacker, boolean sendMessages) {
        Tameable tameable;
        Entity entity = event.getEntity();
        if (!(entity instanceof Tameable) || !(tameable = (Tameable)entity).isTamed()) {
            return event.getEntityType() == EntityType.WOLF;
        }
        AnimalTamer owner = tameable.getOwner();
        if (owner == null) {
            return tameable.getType() == EntityType.WOLF;
        }
        if (attacker == null) {
            return false;
        }
        if (attacker.equals((Object)owner)) {
            return true;
        }
        PlayerData attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
        if (attackerData.ignoreClaims) {
            return true;
        }
        if (tameable.getType() == EntityType.WOLF && tameable.getTarget() != null && tameable.getTarget() == attacker) {
            return true;
        }
        event.setCancelled(true);
        if (sendMessages) {
            String ownerName = GriefPrevention.lookupPlayerName(owner);
            Object message = this.dataStore.getMessage(Messages.NoDamageClaimedEntity, ownerName);
            if (attacker.hasPermission("griefprevention.ignoreclaims")) {
                message = (String)message + "  " + this.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
            }
            GriefPrevention.sendMessage(attacker, TextMode.Err, (String)message);
        }
        return true;
    }

    private void preventInfiniteBounce(@Nullable Projectile projectile, @NotNull Entity entity) {
        if (projectile != null) {
            if (projectile.getType() == EntityType.TRIDENT) {
                projectile.teleport(entity);
                projectile.setVelocity(new Vector());
            } else {
                projectile.remove();
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityDamageByEntityMonitor(@NotNull EntityDamageByEntityEvent event) {
        long now;
        Projectile arrow;
        ProjectileSource projectileSource;
        Player defender;
        Entity entity;
        if (event.getDamage() == 0.0 || !((entity = event.getEntity()) instanceof Player) || !this.instance.pvpRulesApply((defender = (Player)entity).getWorld())) {
            return;
        }
        Player attacker = null;
        Entity damageSource = event.getDamager();
        if (damageSource instanceof Player) {
            Player damager;
            attacker = damager = (Player)damageSource;
        } else if (damageSource instanceof Projectile && (projectileSource = (arrow = (Projectile)damageSource).getShooter()) instanceof Player) {
            Player shooter;
            attacker = shooter = (Player)projectileSource;
        }
        if (attacker == null || attacker == defender) {
            return;
        }
        PlayerData defenderData = this.dataStore.getPlayerData(defender.getUniqueId());
        PlayerData attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
        defenderData.lastPvpTimestamp = now = Calendar.getInstance().getTimeInMillis();
        defenderData.lastPvpPlayer = attacker.getName();
        attackerData.lastPvpTimestamp = now;
        attackerData.lastPvpPlayer = defender.getName();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onVehicleDamage(@NotNull VehicleDamageEvent event) {
        Claim claim;
        if (!this.instance.config_claims_preventTheft) {
            return;
        }
        if (!this.instance.claimsEnabledForWorld(event.getVehicle().getWorld())) {
            return;
        }
        Player attacker = null;
        Projectile arrow = null;
        Entity damageSource = event.getAttacker();
        EntityType damageSourceType = null;
        if (damageSource != null) {
            Projectile projectile;
            ProjectileSource projectileSource;
            damageSourceType = damageSource.getType();
            if (damageSource instanceof Player) {
                Player player;
                attacker = player = (Player)damageSource;
            } else if (damageSource instanceof Projectile && (projectileSource = (arrow = (projectile = (Projectile)damageSource)).getShooter()) instanceof Player) {
                Player shooter;
                attacker = shooter = (Player)projectileSource;
            }
        }
        if (attacker == null && damageSourceType != EntityType.CREEPER && damageSourceType != EntityType.WITHER && damageSourceType != EntityType.TNT) {
            return;
        }
        Claim cachedClaim = null;
        PlayerData playerData = null;
        if (attacker != null) {
            playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
            cachedClaim = playerData.lastClaim;
        }
        if ((claim = this.dataStore.getClaimAt(event.getVehicle().getLocation(), false, cachedClaim)) == null) {
            return;
        }
        if (attacker == null) {
            event.setCancelled(true);
            if (arrow != null) {
                arrow.remove();
            }
            return;
        }
        Player finalAttacker = attacker;
        Supplier<String> override = () -> {
            Object message = this.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
            if (finalAttacker.hasPermission("griefprevention.ignoreclaims")) {
                message = (String)message + "  " + this.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
            }
            return message;
        };
        Supplier<String> noContainersReason = claim.checkPermission(attacker, ClaimPermission.Inventory, (Event)event, override);
        if (noContainersReason != null) {
            event.setCancelled(true);
            this.preventInfiniteBounce(arrow, (Entity)event.getVehicle());
            GriefPrevention.sendMessage(attacker, TextMode.Err, noContainersReason.get());
        }
        playerData.lastClaim = claim;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPotionSplash(@NotNull PotionSplashEvent event) {
        ThrownPotion potion = event.getPotion();
        ProjectileSource projectileSource = potion.getShooter();
        if (projectileSource == null) {
            return;
        }
        Player thrower = projectileSource instanceof Player ? (Player)projectileSource : null;
        AtomicBoolean messagedPlayer = new AtomicBoolean(false);
        Collection effects = potion.getEffects();
        for (PotionEffect effect : effects) {
            PotionEffectType effectType = effect.getType();
            if (GRIEF_EFFECTS.contains(effectType)) {
                Claim cachedClaim = null;
                for (LivingEntity affected : event.getAffectedEntities()) {
                    Claim claim;
                    if (affected == thrower || affected.getType() != EntityType.VILLAGER && !(affected instanceof Animals) || (claim = this.dataStore.getClaimAt(affected.getLocation(), false, cachedClaim)) == null) continue;
                    cachedClaim = claim;
                    if (thrower == null) {
                        if (EntityEventHandler.isBlockSourceInClaim(projectileSource, claim)) continue;
                        event.setIntensity(affected, 0.0);
                        continue;
                    }
                    Supplier<String> override = () -> this.instance.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
                    Supplier<String> noContainersReason = claim.checkPermission(thrower, ClaimPermission.Inventory, (Event)event, override);
                    if (noContainersReason == null) continue;
                    event.setIntensity(affected, 0.0);
                    if (!messagedPlayer.compareAndSet(false, true)) continue;
                    GriefPrevention.sendMessage(thrower, TextMode.Err, noContainersReason.get());
                }
            }
            if (thrower == null) {
                return;
            }
            if (effectType.getCategory() == PotionEffectTypeCategory.BENEFICIAL) continue;
            for (LivingEntity affected : event.getAffectedEntities()) {
                if (affected == thrower || !(affected instanceof Player)) continue;
                Player affectedPlayer = (Player)affected;
                if (!this.instance.config_pvp_noCombatInPlayerLandClaims && !this.instance.config_pvp_noCombatInAdminLandClaims) continue;
                PlayerData playerData = this.dataStore.getPlayerData(thrower.getUniqueId());
                Consumer<Messages> cancelHandler = message -> {
                    event.setIntensity(affected, 0.0);
                    if (messagedPlayer.compareAndSet(false, true)) {
                        GriefPrevention.sendMessage(thrower, TextMode.Err, message, new String[0]);
                    }
                };
                if (this.handlePvpInClaim(thrower, affectedPlayer, thrower.getLocation(), playerData, () -> cancelHandler.accept(Messages.CantFightWhileImmune))) continue;
                playerData = this.dataStore.getPlayerData(affectedPlayer.getUniqueId());
                this.handlePvpInClaim(thrower, affectedPlayer, affectedPlayer.getLocation(), playerData, () -> cancelHandler.accept(Messages.PlayerInPvPSafeZone));
            }
        }
    }
}

