/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PendingItemProtection;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.events.ProtectDeathDropsEvent;
import org.bukkit.Bukkit;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityEventHandler
implements Listener {
    private final DataStore dataStore;
    private final GriefPrevention instance;

    public EntityEventHandler(DataStore dataStore, GriefPrevention plugin) {
        this.dataStore = dataStore;
        this.instance = plugin;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityFormBlock(EntityBlockFormEvent event) {
        Player player;
        String noBuildReason;
        Entity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER && (noBuildReason = GriefPrevention.instance.allowBuild(player = (Player)event.getEntity(), event.getBlock().getLocation(), event.getNewState().getType())) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityChangeBLock(EntityChangeBlockEvent event) {
        if (!GriefPrevention.instance.config_endermenMoveBlocks && event.getEntityType() == EntityType.ENDERMAN) {
            event.setCancelled(true);
        } else if (!GriefPrevention.instance.config_silverfishBreakBlocks && event.getEntityType() == EntityType.SILVERFISH) {
            event.setCancelled(true);
        } else if (!GriefPrevention.instance.config_rabbitsEatCrops && event.getEntityType() == EntityType.RABBIT) {
            event.setCancelled(true);
        } else if (!GriefPrevention.instance.config_claims_ravagersBreakBlocks && event.getEntityType() == EntityType.RAVAGER) {
            event.setCancelled(true);
        } else if (GriefPrevention.instance.config_claims_worldModes.get(event.getBlock().getWorld()) == ClaimsMode.Disabled) {
            return;
        }
        if (event.getEntity() instanceof Projectile) {
            this.handleProjectileChangeBlock(event, (Projectile)event.getEntity());
        } else if (event.getEntityType() == EntityType.WITHER) {
            Claim claim = this.dataStore.getClaimAt(event.getBlock().getLocation(), false, null);
            if (!(claim == null || claim.areExplosivesAllowed && GriefPrevention.instance.config_blockClaimExplosions)) {
                event.setCancelled(true);
            }
        } else if (event.getTo() == Material.DIRT && event.getBlock().getType() == Material.FARMLAND) {
            if (event.getEntityType() != EntityType.PLAYER) {
                event.setCancelled(true);
            } else {
                Block block;
                Player player = (Player)event.getEntity();
                if (GriefPrevention.instance.allowBreak(player, block = event.getBlock(), block.getLocation()) != null) {
                    event.setCancelled(true);
                }
            }
        } else if (event.getBlock().getType() == Material.POWDER_SNOW && event.getTo() == Material.AIR) {
            this.handleEntityMeltPowderedSnow(event);
        } else if (event.getEntity() instanceof Vehicle && !event.getEntity().getPassengers().isEmpty()) {
            Block block;
            Entity driver = (Entity)event.getEntity().getPassengers().get(0);
            if (driver instanceof Player && GriefPrevention.instance.allowBreak((Player)driver, block = event.getBlock(), block.getLocation()) != null) {
                event.setCancelled(true);
            }
        } else if (event.getEntityType() == EntityType.FALLING_BLOCK) {
            FallingBlock entity = (FallingBlock)event.getEntity();
            Block block = event.getBlock();
            if (event.getTo() == Material.AIR) {
                entity.setMetadata("GP_FALLINGBLOCK", (MetadataValue)new FixedMetadataValue((Plugin)GriefPrevention.instance, (Object)block.getLocation()));
            } else {
                List values = entity.getMetadata("GP_FALLINGBLOCK");
                if (values.size() < 1) {
                    return;
                }
                Location originalLocation = (Location)((MetadataValue)values.get(0)).value();
                Location newLocation = block.getLocation();
                if (originalLocation.getBlockX() != newLocation.getBlockX() || originalLocation.getBlockZ() != newLocation.getBlockZ()) {
                    if (GriefPrevention.instance.config_claims_worldModes.get(newLocation.getWorld()) == ClaimsMode.Creative) {
                        event.setCancelled(true);
                        entity.remove();
                        return;
                    }
                    Claim claim = this.dataStore.getClaimAt(newLocation, false, null);
                    if (claim != null && !claim.contains(originalLocation, false, false)) {
                        event.setCancelled(true);
                        if (entity.isDead()) {
                            return;
                        }
                        entity.remove();
                        ItemStack itemStack = new ItemStack(entity.getBlockData().getMaterial(), 1);
                        block.getWorld().dropItemNaturally(entity.getLocation(), itemStack);
                    }
                }
            }
        }
    }

    private void handleProjectileChangeBlock(EntityChangeBlockEvent event, Projectile projectile) {
        Block block = event.getBlock();
        Claim claim = this.dataStore.getClaimAt(block.getLocation(), false, null);
        if (claim == null) {
            if (this.instance.creativeRulesApply(block.getLocation()) || this.instance.config_claims_worldModes.get(block.getWorld()) == ClaimsMode.SurvivalRequiringClaims) {
                event.setCancelled(true);
                return;
            }
            return;
        }
        ProjectileSource shooter = projectile.getShooter();
        if (shooter instanceof Player) {
            Supplier<String> denial = claim.checkPermission((Player)shooter, ClaimPermission.Build, (Event)event);
            if (denial != null) {
                GriefPrevention.sendMessage((Player)shooter, TextMode.Err, denial.get());
                event.setCancelled(true);
            }
            return;
        }
        if (EntityEventHandler.isBlockSourceInClaim(shooter, claim)) {
            return;
        }
        if (GriefPrevention.instance.config_mobProjectilesChangeBlocks && shooter instanceof Mob) {
            return;
        }
        event.setCancelled(true);
    }

    private void handleEntityMeltPowderedSnow(@NotNull EntityChangeBlockEvent event) {
        Player player = null;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player localPlayer;
            player = localPlayer = (Player)entity;
        } else {
            entity = event.getEntity();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                LivingEntity livingEntity = mob.getTarget();
                if (livingEntity instanceof Player) {
                    Player localPlayer;
                    player = localPlayer = (Player)livingEntity;
                } else if (mob.isLeashed() && (livingEntity = mob.getLeashHolder()) instanceof Player) {
                    Player localPlayer;
                    player = localPlayer = (Player)livingEntity;
                }
            }
        }
        if (player != null) {
            Block block = event.getBlock();
            if (GriefPrevention.instance.allowBreak(player, block, block.getLocation()) != null) {
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(true);
        }
    }

    static boolean isBlockSourceInClaim(@Nullable ProjectileSource projectileSource, @Nullable Claim claim) {
        return projectileSource instanceof BlockProjectileSource && GriefPrevention.instance.dataStore.getClaimAt(((BlockProjectileSource)projectileSource).getBlock().getLocation(), false, claim) == claim;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onFallingBlockEnterPortal(EntityPortalEnterEvent event) {
        if (event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        event.getEntity().removeMetadata("GP_FALLINGBLOCK", (Plugin)this.instance);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onZombieBreakDoor(EntityBreakDoorEvent event) {
        if (!GriefPrevention.instance.config_zombiesBreakDoors) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent event) {
        Material material = event.getBlock().getType();
        if (material == Material.FARMLAND) {
            if (!GriefPrevention.instance.config_creaturesTrampleCrops) {
                event.setCancelled(true);
            } else {
                Entity rider = event.getEntity().getPassenger();
                if (rider != null && rider.getType() == EntityType.PLAYER) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityExplode(EntityExplodeEvent explodeEvent) {
        if (explodeEvent.blockList().isEmpty()) {
            return;
        }
        if (explodeEvent.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            this.handleExplodeInteract(explodeEvent.getLocation(), explodeEvent.getEntity(), explodeEvent.blockList(), (Event)explodeEvent);
        } else {
            this.handleExplosion(explodeEvent.getLocation(), explodeEvent.getEntity(), explodeEvent.blockList());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockExplode(BlockExplodeEvent explodeEvent) {
        if (explodeEvent.blockList().isEmpty()) {
            return;
        }
        if (explodeEvent.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            this.handleExplodeInteract(explodeEvent.getBlock().getLocation(), null, explodeEvent.blockList(), (Event)explodeEvent);
        } else {
            this.handleExplosion(explodeEvent.getBlock().getLocation(), null, explodeEvent.blockList());
        }
    }

    void handleExplodeInteract(@NotNull Location location, @Nullable Entity entity, @NotNull List<Block> blocks, @NotNull Event event) {
        Projectile projectile;
        World world = location.getWorld();
        if (world == null || !GriefPrevention.instance.claimsEnabledForWorld(world)) {
            return;
        }
        Player player = null;
        PlayerData playerData = null;
        ProjectileSource source = null;
        if (entity instanceof Projectile && (source = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
            player = (Player)source;
            playerData = this.dataStore.getPlayerData(player.getUniqueId());
        }
        ArrayList<Block> removed = new ArrayList<Block>();
        Claim cachedClaim = playerData != null ? playerData.lastClaim : null;
        for (Block block : blocks) {
            Claim claim;
            if (block.getType().isAir() || (claim = this.dataStore.getClaimAt(block.getLocation(), false, cachedClaim)) == null) continue;
            cachedClaim = claim;
            if (player == null) {
                if (EntityEventHandler.isBlockSourceInClaim(source, claim)) continue;
                removed.add(block);
                continue;
            }
            if (claim.checkPermission(player, ClaimPermission.Access, event) == null) continue;
            removed.add(block);
        }
        if (playerData != null && cachedClaim != null) {
            playerData.lastClaim = cachedClaim;
        }
        blocks.removeAll(removed);
    }

    void handleExplosion(@NotNull Location location, @Nullable Entity entity, @NotNull List<Block> blocks) {
        boolean applySurfaceRules;
        World world = location.getWorld();
        if (world == null || !GriefPrevention.instance.claimsEnabledForWorld(world)) {
            return;
        }
        boolean isCreeper = entity != null && entity.getType() == EntityType.CREEPER;
        boolean bl = applySurfaceRules = world.getEnvironment() == World.Environment.NORMAL && (isCreeper && GriefPrevention.instance.config_blockSurfaceCreeperExplosions || !isCreeper && GriefPrevention.instance.config_blockSurfaceOtherExplosions);
        if (GriefPrevention.instance.creativeRulesApply(location)) {
            for (int i = 0; i < blocks.size(); ++i) {
                blocks.remove(i--);
            }
            return;
        }
        ArrayList<Block> explodedBlocks = new ArrayList<Block>();
        Claim cachedClaim = null;
        for (Block block : blocks) {
            Material material;
            boolean breakable;
            if (block.getType().isAir()) continue;
            Claim claim = this.dataStore.getClaimAt(block.getLocation(), false, cachedClaim);
            if (claim != null) {
                cachedClaim = claim;
            }
            if (claim != null && (claim.areExplosivesAllowed || !GriefPrevention.instance.config_blockClaimExplosions)) {
                explodedBlocks.add(block);
                continue;
            }
            if (claim != null && claim.siegeData != null && (breakable = GriefPrevention.instance.config_siege_blocks.contains(material = block.getType())) || claim != null || applySurfaceRules && block.getLocation().getBlockY() >= GriefPrevention.instance.getSeaLevel(world) - 7) continue;
            explodedBlocks.add(block);
        }
        blocks.clear();
        blocks.addAll(explodedBlocks);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        if (GriefPrevention.instance.creativeRulesApply(event.getLocation())) {
            event.setCancelled(true);
        }
        ArrayList<PendingItemProtection> watchList = GriefPrevention.instance.pendingItemWatchList;
        Item newItem = event.getEntity();
        Long now = null;
        for (int i = 0; i < watchList.size(); ++i) {
            PendingItemProtection pendingProtection = watchList.get(i);
            if (now == null) {
                now = System.currentTimeMillis();
            }
            if (pendingProtection.expirationTimestamp < now) {
                watchList.remove(i--);
                continue;
            }
            if (pendingProtection.itemStack.getAmount() != newItem.getItemStack().getAmount() || pendingProtection.itemStack.getType() != newItem.getItemStack().getType()) continue;
            Location spawn = event.getLocation();
            Location expected = pendingProtection.location;
            if (!spawn.getWorld().equals((Object)expected.getWorld()) || spawn.getX() < expected.getX() - 5.0 || spawn.getX() > expected.getX() + 5.0 || spawn.getZ() < expected.getZ() - 5.0 || spawn.getZ() > expected.getZ() + 5.0 || spawn.getY() < expected.getY() - 15.0 || spawn.getY() > expected.getY() + 3.0) continue;
            newItem.setMetadata("GP_ITEMOWNER", (MetadataValue)new FixedMetadataValue((Plugin)GriefPrevention.instance, (Object)pendingProtection.owner));
            watchList.remove(i);
            break;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExpBottle(ExpBottleEvent event) {
        if (GriefPrevention.instance.creativeRulesApply(event.getEntity().getLocation())) {
            event.setExperience(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (!GriefPrevention.instance.creativeRulesApply(event.getLocation())) {
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG && reason != CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM && reason != CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN && event.getEntityType() != EntityType.ARMOR_STAND) {
            event.setCancelled(true);
            return;
        }
        Claim claim = this.dataStore.getClaimAt(event.getLocation(), false, null);
        if (claim == null || claim.allowMoreEntities(true) != null) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        World world;
        boolean isPvPWorld;
        LivingEntity entity = event.getEntity();
        if (!GriefPrevention.instance.claimsEnabledForWorld(entity.getWorld())) {
            return;
        }
        if (GriefPrevention.instance.creativeRulesApply(entity.getLocation())) {
            event.setDroppedExp(0);
            event.getDrops().clear();
        }
        if (entity.getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)entity;
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.siegeData != null) {
            this.dataStore.endSiege(playerData.siegeData, null, player.getName(), event.getDrops());
        }
        if ((isPvPWorld = GriefPrevention.instance.pvpRulesApply(world = entity.getWorld())) && GriefPrevention.instance.config_lockDeathDropsInPvpWorlds || !isPvPWorld && GriefPrevention.instance.config_lockDeathDropsInNonPvpWorlds) {
            Claim claim = this.dataStore.getClaimAt(player.getLocation(), false, playerData.lastClaim);
            ProtectDeathDropsEvent protectionEvent = new ProtectDeathDropsEvent(claim);
            Bukkit.getPluginManager().callEvent((Event)protectionEvent);
            if (!protectionEvent.isCancelled()) {
                long expirationTime = System.currentTimeMillis() + 3000L;
                Location deathLocation = player.getLocation();
                UUID playerID = player.getUniqueId();
                List drops = event.getDrops();
                for (ItemStack stack : drops) {
                    GriefPrevention.instance.pendingItemWatchList.add(new PendingItemProtection(deathLocation, playerID, expirationTime, stack));
                }
                playerData.dropsAreUnlocked = false;
                playerData.receivedDropUnlockAdvertisement = false;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onItemMerge(ItemMergeEvent event) {
        Item item = event.getEntity();
        List data = item.getMetadata("GP_ITEMOWNER");
        event.setCancelled(data != null && data.size() > 0);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityPickup(EntityChangeBlockEvent event) {
        if (event.getEntity().getType() == EntityType.ENDERMAN && this.dataStore.getClaimAt(event.getBlock().getLocation(), false, null) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onHangingBreak(HangingBreakEvent event) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getCause() == HangingBreakEvent.RemoveCause.PHYSICS) {
            return;
        }
        if (event.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION) {
            event.setCancelled(true);
            return;
        }
        if (!(event instanceof HangingBreakByEntityEvent)) {
            event.setCancelled(true);
            return;
        }
        HangingBreakByEntityEvent entityEvent = (HangingBreakByEntityEvent)event;
        Entity remover = entityEvent.getRemover();
        if (remover.getType() != EntityType.PLAYER) {
            event.setCancelled(true);
            return;
        }
        Player playerRemover = (Player)entityEvent.getRemover();
        String noBuildReason = GriefPrevention.instance.allowBuild(playerRemover, event.getEntity().getLocation(), Material.AIR);
        if (noBuildReason != null) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(playerRemover, TextMode.Err, noBuildReason);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPaintingPlace(HangingPlaceEvent event) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getBlock().getWorld())) {
            return;
        }
        String noBuildReason = GriefPrevention.instance.allowBuild(event.getPlayer(), event.getEntity().getLocation(), Material.PAINTING);
        if (noBuildReason != null) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(event.getPlayer(), TextMode.Err, noBuildReason);
            return;
        }
        if (GriefPrevention.instance.creativeRulesApply(event.getEntity().getLocation())) {
            PlayerData playerData = this.dataStore.getPlayerData(event.getPlayer().getUniqueId());
            Claim claim = this.dataStore.getClaimAt(event.getBlock().getLocation(), false, playerData.lastClaim);
            if (claim == null) {
                return;
            }
            String noEntitiesReason = claim.allowMoreEntities(false);
            if (noEntitiesReason != null) {
                GriefPrevention.sendMessage(event.getPlayer(), TextMode.Err, noEntitiesReason);
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onEntityPickUpItem(@NotNull EntityPickupItemEvent event) {
        if (event.getEntity() instanceof Monster) {
            return;
        }
        Player player = null;
        if (event.getEntity() instanceof Player) {
            player = (Player)event.getEntity();
        }
        this.protectLockedDrops(event, player);
        this.preventPvpSpawnCamp(event, player);
    }

    private void protectLockedDrops(@NotNull EntityPickupItemEvent event, @Nullable Player player) {
        Object object;
        Item item = event.getItem();
        List data = item.getMetadata("GP_ITEMOWNER");
        if (data.isEmpty() || !((object = ((MetadataValue)data.get(0)).value()) instanceof UUID)) {
            return;
        }
        UUID ownerID = (UUID)object;
        OfflinePlayer owner = this.instance.getServer().getOfflinePlayer(ownerID);
        if (!owner.isOnline() || Objects.equals(player, owner)) {
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(ownerID);
        if (playerData.dropsAreUnlocked) {
            return;
        }
        event.setCancelled(true);
        if (player == null) {
            return;
        }
        if (!playerData.receivedDropUnlockAdvertisement) {
            GriefPrevention.sendMessage(owner.getPlayer(), TextMode.Instr, Messages.DropUnlockAdvertisement, new String[0]);
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.PickupBlockedExplanation, GriefPrevention.lookupPlayerName(ownerID));
            playerData.receivedDropUnlockAdvertisement = true;
        }
    }

    private void preventPvpSpawnCamp(@NotNull EntityPickupItemEvent event, @Nullable Player player) {
        if (player == null || !this.instance.pvpRulesApply(player.getWorld())) {
            return;
        }
        if (this.instance.config_pvp_protectFreshSpawns && this.instance.getItemInHand(player, EquipmentSlot.HAND).getType() == Material.AIR) {
            PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
            if (playerData.pvpImmune) {
                long now = Calendar.getInstance().getTimeInMillis();
                long elapsedSinceLastSpawn = now - playerData.lastSpawn;
                if (elapsedSinceLastSpawn < 10000L) {
                    event.setCancelled(true);
                    return;
                }
                playerData.pvpImmune = false;
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.PvPImmunityEnd, new String[0]);
            }
        }
    }
}

