/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.DatabaseDataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.UUIDFetcher;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class FlatFileDataStore
extends DataStore {
    private static final String claimDataFolderPath = dataLayerFolderPath + File.separator + "ClaimData";
    private static final String nextClaimIdFilePath = claimDataFolderPath + File.separator + "_nextClaimID";
    private static final String schemaVersionFilePath = dataLayerFolderPath + File.separator + "_schemaVersion";

    static boolean hasData() {
        File claimsDataFolder = new File(claimDataFolderPath);
        return claimsDataFolder.exists();
    }

    FlatFileDataStore() throws Exception {
        this.initialize();
    }

    @Override
    void initialize() throws Exception {
        File[] files;
        boolean newDataStore = false;
        File playerDataFolder = new File(playerDataFolderPath);
        File claimDataFolder = new File(claimDataFolderPath);
        if (!playerDataFolder.exists() || !claimDataFolder.exists()) {
            newDataStore = true;
            playerDataFolder.mkdirs();
            claimDataFolder.mkdirs();
        }
        if (newDataStore) {
            this.setSchemaVersion(3);
        }
        for (File file : files = playerDataFolder.listFiles()) {
            String groupName;
            if (!file.isFile() || !file.getName().startsWith("$") || (groupName = file.getName().substring(1)) == null || groupName.isEmpty()) continue;
            BufferedReader inStream = null;
            try {
                inStream = new BufferedReader(new FileReader(file.getAbsolutePath()));
                String line = inStream.readLine();
                int groupBonusBlocks = Integer.parseInt(line);
                this.permissionToBonusBlocksMap.put(groupName, groupBonusBlocks);
            }
            catch (Exception e) {
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                GriefPrevention.AddLogEntry(errors.toString(), CustomLogEntryTypes.Exception);
            }
            try {
                if (inStream == null) continue;
                inStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        File nextClaimIdFile = new File(nextClaimIdFilePath);
        if (nextClaimIdFile.exists()) {
            BufferedReader inStream = null;
            try {
                inStream = new BufferedReader(new FileReader(nextClaimIdFile.getAbsolutePath()));
                String line = inStream.readLine();
                this.nextClaimID = Long.parseLong(line);
            }
            catch (Exception line) {
                // empty catch block
            }
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException line) {
                // empty catch block
            }
        }
        if (this.getSchemaVersion() == 0) {
            files = playerDataFolder.listFiles();
            ArrayList<String> namesToConvert = new ArrayList<String>();
            for (File playerFile : files) {
                namesToConvert.add(playerFile.getName());
            }
            try {
                UUIDFetcher fetcher = new UUIDFetcher(namesToConvert);
                fetcher.call();
            }
            catch (Exception e) {
                GriefPrevention.AddLogEntry("Failed to resolve a batch of names to UUIDs.  Details:" + e.getMessage());
                e.printStackTrace();
            }
            for (File playerFile : files) {
                File correctedCasingFile;
                String currentFilename = playerFile.getName();
                String correctedCasing = UUIDFetcher.correctedNames.get(currentFilename);
                if (correctedCasing != null && !currentFilename.equals(correctedCasing) && (correctedCasingFile = new File(playerDataFolder.getPath() + File.separator + correctedCasing)).exists()) continue;
                UUID playerID = null;
                try {
                    playerID = UUIDFetcher.getUUIDOf(currentFilename);
                    if (playerID == null) continue;
                    playerFile.renameTo(new File(playerDataFolder, playerID.toString()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        files = claimDataFolder.listFiles();
        if (this.getSchemaVersion() <= 1) {
            this.loadClaimData_Legacy(files);
        } else {
            this.loadClaimData(files);
        }
        super.initialize();
    }

    void loadClaimData_Legacy(File[] files) throws Exception {
        List validWorlds = Bukkit.getServer().getWorlds();
        for (int i = 0; i < files.length; ++i) {
            long claimID;
            if (!files[i].isFile() || files[i].getName().startsWith("_")) continue;
            try {
                claimID = Long.parseLong(files[i].getName());
            }
            catch (Exception e) {
                claimID = this.nextClaimID;
                this.incrementNextClaimID();
                File newFile = new File(claimDataFolderPath + File.separator + String.valueOf(this.nextClaimID));
                files[i].renameTo(newFile);
                files[i] = newFile;
            }
            BufferedReader inStream = null;
            String lesserCornerString = "";
            try {
                Claim topLevelClaim = null;
                inStream = new BufferedReader(new FileReader(files[i].getAbsolutePath()));
                String line = inStream.readLine();
                while (line != null) {
                    Matcher match;
                    if (line.toLowerCase().startsWith("sub:")) {
                        line = inStream.readLine();
                    }
                    if ((match = uuidpattern.matcher(line.trim())).find()) {
                        line = inStream.readLine();
                    }
                    lesserCornerString = line;
                    Location lesserBoundaryCorner = this.locationFromString(lesserCornerString, validWorlds);
                    line = inStream.readLine();
                    Location greaterBoundaryCorner = this.locationFromString(line, validWorlds);
                    String ownerName = line = inStream.readLine();
                    UUID ownerID = null;
                    if (ownerName.isEmpty() || ownerName.startsWith("--")) {
                        ownerID = null;
                    } else if (this.getSchemaVersion() == 0) {
                        try {
                            ownerID = UUIDFetcher.getUUIDOf(ownerName);
                        }
                        catch (Exception ex) {
                            GriefPrevention.AddLogEntry("Couldn't resolve this name to a UUID: " + ownerName + ".");
                            GriefPrevention.AddLogEntry("  Converted land claim to administrative @ " + lesserBoundaryCorner.toString());
                        }
                    } else {
                        try {
                            ownerID = UUID.fromString(ownerName);
                        }
                        catch (Exception ex) {
                            GriefPrevention.AddLogEntry("Error - this is not a valid UUID: " + ownerName + ".");
                            GriefPrevention.AddLogEntry("  Converted land claim to administrative @ " + lesserBoundaryCorner.toString());
                        }
                    }
                    line = inStream.readLine();
                    List<String> builderNames = Arrays.asList(line.split(";"));
                    builderNames = this.convertNameListToUUIDList(builderNames);
                    line = inStream.readLine();
                    List<String> containerNames = Arrays.asList(line.split(";"));
                    containerNames = this.convertNameListToUUIDList(containerNames);
                    line = inStream.readLine();
                    List<String> accessorNames = Arrays.asList(line.split(";"));
                    accessorNames = this.convertNameListToUUIDList(accessorNames);
                    line = inStream.readLine();
                    if (line == null) {
                        line = "";
                    }
                    List<String> managerNames = Arrays.asList(line.split(";"));
                    managerNames = this.convertNameListToUUIDList(managerNames);
                    line = inStream.readLine();
                    while (line != null && !line.contains("===")) {
                        line = inStream.readLine();
                    }
                    if (topLevelClaim == null) {
                        topLevelClaim = new Claim(lesserBoundaryCorner, greaterBoundaryCorner, ownerID, builderNames, containerNames, accessorNames, managerNames, claimID);
                        topLevelClaim.modifiedDate = new Date(files[i].lastModified());
                        this.addClaim(topLevelClaim, false);
                    } else {
                        Claim subdivision = new Claim(lesserBoundaryCorner, greaterBoundaryCorner, null, builderNames, containerNames, accessorNames, managerNames, null);
                        subdivision.modifiedDate = new Date(files[i].lastModified());
                        subdivision.parent = topLevelClaim;
                        topLevelClaim.children.add(subdivision);
                        subdivision.inDataStore = true;
                    }
                    line = inStream.readLine();
                }
                inStream.close();
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("World not found")) {
                    GriefPrevention.AddLogEntry("Failed to load a claim " + files[i].getName() + " because its world isn't loaded (yet?).  Please delete the claim file or contact the GriefPrevention developer with information about which plugin(s) you're using to load or create worlds.  " + lesserCornerString);
                    inStream.close();
                }
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                GriefPrevention.AddLogEntry("Failed to load claim " + files[i].getName() + ". This usually occurs when your server runs out of storage space, causing any file saves to corrupt. Fix or delete the file found in GriefPreventionData/ClaimData/" + files[i].getName(), CustomLogEntryTypes.Debug, false);
                GriefPrevention.AddLogEntry(files[i].getName() + " " + errors.toString(), CustomLogEntryTypes.Exception);
            }
            try {
                if (inStream == null) continue;
                inStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void loadClaimData(File[] files) throws Exception {
        ConcurrentHashMap<Claim, Long> orphans = new ConcurrentHashMap<Claim, Long>();
        for (int i = 0; i < files.length; ++i) {
            long claimID;
            if (!files[i].isFile() || files[i].getName().startsWith("_")) continue;
            if (!files[i].getName().endsWith(".yml")) {
                files[i].delete();
                continue;
            }
            try {
                claimID = Long.parseLong(files[i].getName().split("\\.")[0]);
            }
            catch (Exception e) {
                claimID = this.nextClaimID;
                this.incrementNextClaimID();
                File newFile = new File(claimDataFolderPath + File.separator + String.valueOf(this.nextClaimID) + ".yml");
                files[i].renameTo(newFile);
                files[i] = newFile;
            }
            try {
                ArrayList<Long> out_parentID = new ArrayList<Long>();
                Claim claim = this.loadClaim(files[i], out_parentID, claimID);
                if (out_parentID.size() == 0 || out_parentID.get(0) == -1L) {
                    this.addClaim(claim, false);
                    continue;
                }
                orphans.put(claim, out_parentID.get(0));
                continue;
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("World not found")) {
                    GriefPrevention.AddLogEntry("Failed to load a claim (ID:" + claimID + ") because its world isn't loaded (yet?).  If this is not expected, delete this claim.");
                    continue;
                }
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                GriefPrevention.AddLogEntry(files[i].getName() + " " + errors.toString(), CustomLogEntryTypes.Exception);
            }
        }
        for (Claim child : orphans.keySet()) {
            Claim parent = this.getClaim((Long)orphans.get(child));
            if (parent == null) continue;
            child.parent = parent;
            this.addClaim(child, false);
        }
    }

    Claim loadClaim(File file, ArrayList<Long> out_parentID, long claimID) throws IOException, InvalidConfigurationException, Exception {
        List lines = Files.readLines((File)file, (Charset)Charset.forName("UTF-8"));
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(line).append('\n');
        }
        return this.loadClaim(builder.toString(), out_parentID, file.lastModified(), claimID, Bukkit.getServer().getWorlds());
    }

    Claim loadClaim(String input, ArrayList<Long> out_parentID, long lastModifiedDate, long claimID, List<World> validWorlds) throws InvalidConfigurationException, Exception {
        Claim claim = null;
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.loadFromString(input);
        Location lesserBoundaryCorner = this.locationFromString(yaml.getString("Lesser Boundary Corner"), validWorlds);
        Location greaterBoundaryCorner = this.locationFromString(yaml.getString("Greater Boundary Corner"), validWorlds);
        String ownerIdentifier = yaml.getString("Owner");
        UUID ownerID = null;
        if (!ownerIdentifier.isEmpty()) {
            try {
                ownerID = UUID.fromString(ownerIdentifier);
            }
            catch (Exception ex) {
                GriefPrevention.AddLogEntry("Error - this is not a valid UUID: " + ownerIdentifier + ".");
                GriefPrevention.AddLogEntry("  Converted land claim to administrative @ " + lesserBoundaryCorner.toString());
            }
        }
        List builders = yaml.getStringList("Builders");
        List containers = yaml.getStringList("Containers");
        List accessors = yaml.getStringList("Accessors");
        List managers = yaml.getStringList("Managers");
        boolean inheritNothing = yaml.getBoolean("inheritNothing");
        out_parentID.add(yaml.getLong("Parent Claim ID", -1L));
        claim = new Claim(lesserBoundaryCorner, greaterBoundaryCorner, ownerID, builders, containers, accessors, managers, inheritNothing, claimID);
        claim.modifiedDate = new Date(lastModifiedDate);
        claim.id = claimID;
        return claim;
    }

    String getYamlForClaim(Claim claim) {
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("Lesser Boundary Corner", (Object)this.locationToString(claim.lesserBoundaryCorner));
        yaml.set("Greater Boundary Corner", (Object)this.locationToString(claim.greaterBoundaryCorner));
        String ownerID = "";
        if (claim.ownerID != null) {
            ownerID = claim.ownerID.toString();
        }
        yaml.set("Owner", (Object)ownerID);
        ArrayList<String> builders = new ArrayList<String>();
        ArrayList<String> containers = new ArrayList<String>();
        ArrayList<String> accessors = new ArrayList<String>();
        ArrayList<String> managers = new ArrayList<String>();
        claim.getPermissions(builders, containers, accessors, managers);
        yaml.set("Builders", builders);
        yaml.set("Containers", containers);
        yaml.set("Accessors", accessors);
        yaml.set("Managers", managers);
        Long parentID = -1L;
        if (claim.parent != null) {
            parentID = claim.parent.id;
        }
        yaml.set("Parent Claim ID", (Object)parentID);
        yaml.set("inheritNothing", (Object)claim.getSubclaimRestrictions());
        return yaml.saveToString();
    }

    @Override
    synchronized void writeClaimToStorage(Claim claim) {
        String claimID = String.valueOf(claim.id);
        String yaml = this.getYamlForClaim(claim);
        try {
            File claimFile = new File(claimDataFolderPath + File.separator + claimID + ".yml");
            claimFile.createNewFile();
            Files.write((byte[])yaml.getBytes("UTF-8"), (File)claimFile);
        }
        catch (Exception e) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            GriefPrevention.AddLogEntry(claimID + " " + errors.toString(), CustomLogEntryTypes.Exception);
        }
    }

    @Override
    synchronized void deleteClaimFromSecondaryStorage(Claim claim) {
        String claimID = String.valueOf(claim.id);
        File claimFile = new File(claimDataFolderPath + File.separator + claimID + ".yml");
        if (claimFile.exists() && !claimFile.delete()) {
            GriefPrevention.AddLogEntry("Error: Unable to delete claim file \"" + claimFile.getAbsolutePath() + "\".");
        }
    }

    @Override
    synchronized PlayerData getPlayerDataFromStorage(UUID playerID) {
        File playerFile = new File(playerDataFolderPath + File.separator + playerID.toString());
        PlayerData playerData = new PlayerData();
        playerData.playerID = playerID;
        if (playerFile.exists()) {
            boolean needRetry = false;
            int retriesRemaining = 5;
            Exception latestException = null;
            do {
                try {
                    needRetry = false;
                    List lines = Files.readLines((File)playerFile, (Charset)Charset.forName("UTF-8"));
                    Iterator iterator = lines.iterator();
                    iterator.next();
                    String accruedBlocksString = (String)iterator.next();
                    playerData.setAccruedClaimBlocks(Integer.parseInt(accruedBlocksString));
                    String bonusBlocksString = (String)iterator.next();
                    playerData.setBonusClaimBlocks(Integer.parseInt(bonusBlocksString));
                }
                catch (Exception e) {
                    latestException = e;
                    needRetry = true;
                    --retriesRemaining;
                }
                try {
                    if (!needRetry) continue;
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (needRetry && retriesRemaining >= 0);
            if (needRetry) {
                StringWriter errors = new StringWriter();
                latestException.printStackTrace(new PrintWriter(errors));
                GriefPrevention.AddLogEntry("Failed to load PlayerData for " + String.valueOf(playerID) + ". This usually occurs when your server runs out of storage space, causing any file saves to corrupt. Fix or delete the file in GriefPrevetionData/PlayerData/" + String.valueOf(playerID), CustomLogEntryTypes.Debug, false);
                GriefPrevention.AddLogEntry(String.valueOf(playerID) + " " + errors.toString(), CustomLogEntryTypes.Exception);
            }
        }
        return playerData;
    }

    @Override
    public void overrideSavePlayerData(UUID playerID, PlayerData playerData) {
        if (playerID == null) {
            return;
        }
        StringBuilder fileContent = new StringBuilder();
        try {
            fileContent.append("\n");
            fileContent.append(String.valueOf(playerData.getAccruedClaimBlocks()));
            fileContent.append("\n");
            fileContent.append(String.valueOf(playerData.getBonusClaimBlocks()));
            fileContent.append("\n");
            fileContent.append("\n");
            File playerDataFile = new File(playerDataFolderPath + File.separator + playerID.toString());
            Files.write((byte[])fileContent.toString().getBytes("UTF-8"), (File)playerDataFile);
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("GriefPrevention: Unexpected exception saving data for player \"" + playerID.toString() + "\": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    synchronized void incrementNextClaimID() {
        Long l = this.nextClaimID;
        this.nextClaimID = this.nextClaimID + 1L;
        BufferedWriter outStream = null;
        try {
            File nextClaimIdFile = new File(nextClaimIdFilePath);
            nextClaimIdFile.createNewFile();
            outStream = new BufferedWriter(new FileWriter(nextClaimIdFile));
            outStream.write(String.valueOf(this.nextClaimID));
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("Unexpected exception saving next claim ID: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    synchronized void saveGroupBonusBlocks(String groupName, int currentValue) {
        BufferedWriter outStream = null;
        try {
            File groupDataFile = new File(playerDataFolderPath + File.separator + "$" + groupName);
            groupDataFile.createNewFile();
            outStream = new BufferedWriter(new FileWriter(groupDataFile));
            outStream.write(String.valueOf(currentValue));
            outStream.newLine();
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("Unexpected exception saving data for group \"" + groupName + "\": " + e.getMessage());
        }
        try {
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void migrateData(DatabaseDataStore databaseStore) {
        File playersBackupFolder;
        File claimsBackupFolder;
        File[] fileArray;
        for (Claim claim : this.claims) {
            databaseStore.addClaim(claim, true);
            for (Claim child : claim.children) {
                databaseStore.addClaim(child, true);
            }
        }
        for (Map.Entry entry : this.permissionToBonusBlocksMap.entrySet()) {
            databaseStore.saveGroupBonusBlocks((String)entry.getKey(), (Integer)entry.getValue());
        }
        File playerDataFolder = new File(playerDataFolderPath);
        for (File file : fileArray = playerDataFolder.listFiles()) {
            if (!file.isFile() || file.isHidden() || file.getName().startsWith("$") || file.getName().startsWith("_") || file.getName().endsWith(".ignore")) continue;
            UUID playerID = UUID.fromString(file.getName());
            databaseStore.savePlayerData(playerID, this.getPlayerData(playerID));
            this.clearCachedPlayerData(playerID);
        }
        if (this.nextClaimID > databaseStore.nextClaimID) {
            databaseStore.setNextClaimID(this.nextClaimID);
        }
        int i = 0;
        do {
            Object claimsFolderBackupPath = claimDataFolderPath;
            if (i > 0) {
                claimsFolderBackupPath = (String)claimsFolderBackupPath + String.valueOf(i);
            }
            claimsBackupFolder = new File((String)claimsFolderBackupPath);
            Object playersFolderBackupPath = playerDataFolderPath;
            if (i > 0) {
                playersFolderBackupPath = (String)playersFolderBackupPath + String.valueOf(i);
            }
            playersBackupFolder = new File((String)playersFolderBackupPath);
            ++i;
        } while (claimsBackupFolder.exists() || playersBackupFolder.exists());
        File claimsFolder = new File(claimDataFolderPath);
        File playersFolder = new File(playerDataFolderPath);
        claimsFolder.renameTo(claimsBackupFolder);
        playersFolder.renameTo(playersBackupFolder);
        GriefPrevention.AddLogEntry("Backed your file system data up to " + claimsBackupFolder.getName() + " and " + playersBackupFolder.getName() + ".");
        GriefPrevention.AddLogEntry("If your migration encountered any problems, you can restore those data with a quick copy/paste.");
        GriefPrevention.AddLogEntry("When you're satisfied that all your data have been safely migrated, consider deleting those folders.");
    }

    @Override
    synchronized void close() {
    }

    @Override
    int getSchemaVersionFromStorage() {
        File schemaVersionFile = new File(schemaVersionFilePath);
        if (schemaVersionFile.exists()) {
            BufferedReader inStream = null;
            int schemaVersion = 0;
            try {
                inStream = new BufferedReader(new FileReader(schemaVersionFile.getAbsolutePath()));
                String line = inStream.readLine();
                schemaVersion = Integer.parseInt(line);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return schemaVersion;
        }
        this.updateSchemaVersionInStorage(0);
        return 0;
    }

    @Override
    void updateSchemaVersionInStorage(int versionToSet) {
        BufferedWriter outStream = null;
        try {
            File schemaVersionFile = new File(schemaVersionFilePath);
            schemaVersionFile.createNewFile();
            outStream = new BufferedWriter(new FileWriter(schemaVersionFile));
            outStream.write(String.valueOf(versionToSet));
        }
        catch (Exception e) {
            GriefPrevention.AddLogEntry("Unexpected exception saving schema version: " + e.getMessage());
        }
        try {
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

