/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.TextMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;

class PlayerRescueTask
implements Runnable {
    private final Location location;
    private Location destination;
    private final Player player;

    public PlayerRescueTask(Player player, Location location, Location destination) {
        this.player = player;
        this.location = location;
        this.destination = destination;
    }

    @Override
    public void run() {
        if (!this.player.isOnline()) {
            return;
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(this.player.getUniqueId());
        playerData.pendingTrapped = false;
        if (!this.player.getLocation().getWorld().equals((Object)this.location.getWorld()) || this.player.getLocation().distance(this.location) > 3.0) {
            GriefPrevention.sendMessage(this.player, TextMode.Err, Messages.RescueAbortedMoved, new String[0]);
            return;
        }
        if (this.destination == null) {
            this.destination = GriefPrevention.instance.ejectPlayer(this.player);
        } else {
            this.player.teleport(this.destination);
        }
        GriefPrevention.AddLogEntry("Rescued trapped player " + this.player.getName() + " from " + GriefPrevention.getfriendlyLocationString(this.location) + " to " + GriefPrevention.getfriendlyLocationString(this.destination) + ".");
    }
}

