/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention.util;

import com.griefprevention.util.IntVector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundingBox
implements Cloneable {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    @NotNull
    public static BoundingBox ofBlocks(@NotNull Collection<Block> blocks) {
        if (blocks.size() == 0) {
            throw new IllegalArgumentException("Cannot create bounding box with no blocks!");
        }
        Iterator<Block> iterator = blocks.iterator();
        BoundingBox box = new BoundingBox(iterator.next());
        while (iterator.hasNext()) {
            Block block = iterator.next();
            box.union(block.getX(), block.getY(), block.getZ());
        }
        return box;
    }

    protected BoundingBox(int x1, int y1, int z1, int x2, int y2, int z2, boolean verify) {
        if (verify) {
            this.verify(x1, y1, z1, x2, y2, z2);
        } else {
            this.minX = x1;
            this.maxX = x2;
            this.minY = y1;
            this.maxY = y2;
            this.minZ = z1;
            this.maxZ = z2;
        }
    }

    public BoundingBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        this(x1, y1, z1, x2, y2, z2, true);
    }

    private BoundingBox(@NotNull Location pos1, @NotNull Location pos2, boolean verify) {
        this(pos1.getBlockX(), pos1.getBlockY(), pos1.getBlockZ(), pos2.getBlockX(), pos2.getBlockY(), pos2.getBlockZ(), verify);
    }

    public BoundingBox(@NotNull Location pos1, @NotNull Location pos2) {
        this(pos1, pos2, true);
    }

    public BoundingBox(@NotNull IntVector pos1, @NotNull IntVector pos2) {
        this(pos1.x(), pos1.y(), pos1.z(), pos2.x(), pos2.y(), pos2.z(), true);
    }

    public BoundingBox(@NotNull Vector pos1, @NotNull Vector pos2) {
        this(pos1.getBlockX(), pos1.getBlockY(), pos1.getBlockZ(), pos2.getBlockX(), pos2.getBlockY(), pos2.getBlockZ(), true);
    }

    public BoundingBox(@NotNull Claim claim) {
        this(claim.getLesserBoundaryCorner(), claim.getGreaterBoundaryCorner(), false);
        this.maxY = Objects.requireNonNull(claim.getLesserBoundaryCorner().getWorld()).getMaxHeight();
    }

    public BoundingBox(@NotNull Block block) {
        this(block.getX(), block.getY(), block.getZ(), block.getX(), block.getY(), block.getZ(), false);
    }

    public BoundingBox(@NotNull org.bukkit.util.BoundingBox boundingBox) {
        this((int)boundingBox.getMinX(), (int)boundingBox.getMinY(), (int)boundingBox.getMinZ(), (int)Math.max(boundingBox.getMinX(), boundingBox.getMaxX() - 1.0E-4), (int)Math.max(boundingBox.getMinY(), boundingBox.getMaxY() - 1.0E-4), (int)Math.max(boundingBox.getMinZ(), boundingBox.getMaxZ() - 1.0E-4), false);
    }

    private void verify(int x1, int y1, int z1, int x2, int y2, int z2) {
        if (x1 < x2) {
            this.minX = x1;
            this.maxX = x2;
        } else {
            this.minX = x2;
            this.maxX = x1;
        }
        if (y1 < y2) {
            this.minY = y1;
            this.maxY = y2;
        } else {
            this.minY = y2;
            this.maxY = y1;
        }
        if (z1 < z2) {
            this.minZ = z1;
            this.maxZ = z2;
        } else {
            this.minZ = z2;
            this.maxZ = z1;
        }
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    @NotNull
    public Vector getMin() {
        return new Vector(this.minX, this.minY, this.minZ);
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    @NotNull
    public Vector getMax() {
        return new Vector(this.maxX, this.maxY, this.maxZ);
    }

    public int getLength() {
        return this.maxX - this.minX + 1;
    }

    public int getHeight() {
        return this.maxY - this.minY + 1;
    }

    public int getWidth() {
        return this.maxZ - this.minZ + 1;
    }

    public double getCenterX() {
        return (double)this.minX + (double)this.getLength() / 2.0;
    }

    public double getCenterY() {
        return (double)this.minY + (double)this.getHeight() / 2.0;
    }

    public double getCenterZ() {
        return (double)this.minZ + (double)this.getWidth() / 2.0;
    }

    @NotNull
    public Vector getCenter() {
        return new Vector(this.getCenterX(), this.getCenterY(), this.getCenterZ());
    }

    public int getArea() {
        return this.getLength() * this.getWidth();
    }

    public int getVolume() {
        return this.getArea() * this.getHeight();
    }

    public void copy(@NotNull BoundingBox other) {
        this.minX = other.minX;
        this.minY = other.minY;
        this.minZ = other.minZ;
        this.maxX = other.maxX;
        this.maxY = other.maxY;
        this.maxZ = other.maxZ;
    }

    public void resize(@NotNull BlockFace direction, int magnitude) {
        if (magnitude == 0 || direction == BlockFace.SELF) {
            return;
        }
        Vector vector = direction.getDirection().multiply(magnitude);
        int modX = NumberConversions.round((double)vector.getX());
        int modY = NumberConversions.round((double)vector.getY());
        int modZ = NumberConversions.round((double)vector.getZ());
        if (modX == 0 && modY == 0 && modZ == 0) {
            return;
        }
        if (direction.getModX() > 0) {
            this.maxX += modX;
        } else {
            this.minX += modX;
        }
        if (direction.getModY() > 0) {
            this.maxY += modY;
        } else {
            this.minY += modY;
        }
        if (direction.getModZ() > 0) {
            this.maxZ += modZ;
        } else {
            this.minZ += modZ;
        }
        if (magnitude < 0) {
            this.verify(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }

    public void move(@NotNull BlockFace direction, int magnitude) {
        if (magnitude == 0 || direction == BlockFace.SELF) {
            return;
        }
        Vector vector = direction.getDirection().multiply(magnitude);
        int blockX = NumberConversions.round((double)vector.getX());
        this.minX += blockX;
        this.maxX += blockX;
        int blockY = NumberConversions.round((double)vector.getY());
        this.minY += blockY;
        this.maxY += blockY;
        int blockZ = NumberConversions.round((double)vector.getZ());
        this.minZ += blockZ;
        this.maxZ += blockZ;
    }

    public void union(int x, int y, int z) {
        this.minX = Math.min(x, this.minX);
        this.maxX = Math.max(x, this.maxX);
        this.minY = Math.min(y, this.minY);
        this.maxY = Math.max(y, this.maxY);
        this.minZ = Math.min(z, this.minZ);
        this.maxZ = Math.max(z, this.maxZ);
    }

    public void union(@NotNull Block position) {
        this.union(position.getX(), position.getY(), position.getZ());
    }

    public void union(@NotNull IntVector position) {
        this.union(position.x(), position.y(), position.z());
    }

    public void union(@NotNull Vector position) {
        this.union(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    public void union(@NotNull Location position) {
        this.union(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    public void union(@NotNull BoundingBox other) {
        this.minX = Math.min(this.minX, other.minX);
        this.maxX = Math.max(this.maxX, other.maxX);
        this.minY = Math.min(this.minY, other.minY);
        this.maxY = Math.max(this.maxY, other.maxY);
        this.minZ = Math.min(this.minZ, other.minZ);
        this.maxZ = Math.max(this.maxZ, other.maxZ);
    }

    private boolean contains2dInternal(int minX, int minZ, int maxX, int maxZ) {
        return minX >= this.minX && maxX <= this.maxX && minZ >= this.minZ && maxZ <= this.maxZ;
    }

    public boolean contains2d(int x, int z) {
        return this.contains2dInternal(x, z, x, z);
    }

    public boolean contains2d(@NotNull IntVector position) {
        return this.contains2d(position.x(), position.z());
    }

    public boolean contains2d(@NotNull Vector position) {
        return this.contains2d(position.getBlockX(), position.getBlockZ());
    }

    public boolean contains2d(@NotNull Location position) {
        return this.contains2d(position.getBlockX(), position.getBlockZ());
    }

    public boolean contains2d(@NotNull Block position) {
        return this.contains2d(position.getX(), position.getZ());
    }

    public boolean contains2d(int x1, int z1, int x2, int z2) {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        if (x1 < x2) {
            minX = x1;
            maxX = x2;
        } else {
            minX = x2;
            maxX = x1;
        }
        if (z1 < z2) {
            minZ = z1;
            maxZ = z2;
        } else {
            minZ = z2;
            maxZ = z1;
        }
        return this.contains2dInternal(minX, minZ, maxX, maxZ);
    }

    public boolean contains2d(@NotNull BoundingBox other) {
        return this.contains2dInternal(other.minX, other.minZ, other.maxX, other.maxZ);
    }

    private boolean containsInternal(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.contains2dInternal(minX, minZ, maxX, maxZ) && minY >= this.minY && maxY <= this.maxY;
    }

    public boolean contains(int x, int y, int z) {
        return this.containsInternal(x, y, z, x, y, z);
    }

    public boolean contains(@NotNull IntVector position) {
        return this.contains(position.x(), position.y(), position.z());
    }

    public boolean contains(@NotNull Vector position) {
        return this.contains(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    public boolean contains(@NotNull Location position) {
        return this.contains(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    public boolean contains(@NotNull Block position) {
        return this.contains(position.getX(), position.getY(), position.getZ());
    }

    public boolean contains(int x1, int y1, int z1, int x2, int y2, int z2) {
        return this.contains(new BoundingBox(x1, y1, z1, x2, y2, z2));
    }

    public boolean contains(@NotNull BoundingBox other) {
        return this.containsInternal(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    public boolean intersects(@NotNull BoundingBox other) {
        return this.minX <= other.maxX && this.maxX >= other.minX && this.minY <= other.maxY && this.maxY >= other.minY && this.minZ <= other.maxZ && this.maxZ >= other.minZ;
    }

    @Nullable
    public BoundingBox intersection(@NotNull BoundingBox other) {
        if (!this.intersects(other)) {
            return null;
        }
        return new BoundingBox(Math.max(this.minX, other.minX), Math.max(this.minY, other.minY), Math.max(this.minZ, other.minZ), Math.min(this.maxX, other.maxX), Math.min(this.maxY, other.maxY), Math.min(this.maxZ, other.maxZ), false);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)o;
        return this.minX == other.minX && this.minY == other.minY && this.minZ == other.minZ && this.maxX == other.maxX && this.maxY == other.maxY && this.maxZ == other.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @NotNull
    public String toString() {
        return "BoundingBox{minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + "}";
    }

    @NotNull
    public BoundingBox clone() {
        try {
            return (BoundingBox)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

