/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modObserverPlugin;

import java.util.logging.Logger;
import net.sn0wix_.modObserverPlugin.commands.ConfigurationCommand;
import net.sn0wix_.modObserverPlugin.config.Config;
import net.sn0wix_.modObserverPlugin.listeners.Events;
import net.sn0wix_.modObserverPlugin.networking.PacketHandler;
import net.sn0wix_.modObserverPlugin.players.OnlinePlayersToCheck;
import net.sn0wix_.modObserverPlugin.players.WaitingForResponsePlayers;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class ModObserverPlugin
extends JavaPlugin {
    public static Plugin PLUGIN;
    public static Logger LOGGER;
    public static FileConfiguration CONFIG;
    public static final String MOD_ID = "mod_observer";
    public static BukkitRunnable pluginTicker;

    public void onEnable() {
        LOGGER = this.getLogger();
        LOGGER.info("----------------ModObserver----------------");
        PLUGIN = this;
        CONFIG = this.getConfig();
        Config.loadValues(CONFIG);
        this.saveConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        pluginTicker = new BukkitRunnable(){

            public void run() {
                if (!WaitingForResponsePlayers.isEmpty()) {
                    WaitingForResponsePlayers.checkForTimedOuts().forEach(player -> {
                        if (player.getSender() != null) {
                            player.getSender().sendMessage(ChatColor.RED + "Mod packet request has timed out!");
                        }
                    });
                }
                OnlinePlayersToCheck.tick();
            }
        };
        pluginTicker.runTaskTimer((Plugin)this, 69L, 20L);
        if (Config.ALLOW_COMMAND_INTERFACE.booleanValue()) {
            try {
                this.getCommand("modObserver").setExecutor((CommandExecutor)new ConfigurationCommand());
            }
            catch (NullPointerException e) {
                LOGGER.warning("Could not register command interface. Configuration must be done directly in the config file.");
            }
        }
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "mod_observer:mods_for_approval", PacketHandler::receive);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "mod_observer:mods_for_approval");
        LOGGER.info("ModObserver initialized!");
        LOGGER.info("Here is a quick tutorial: \nWhen joining for the first time, it might not let you in, so execute /modobserver ignoredPlayers add <yourName>\nThis will add you to the Ignored players list, so you won't be checked.\nOnce you are in game, execute /modobserver help to view the help message.\nAnd don't forget to remove yourself from the Ignored players list: /modobserver ignoredPlayers remove <yourName>");
        LOGGER.info("If this plugin gives you errors when someone is kicked, ignore them.");
        LOGGER.info("----------------ModObserver----------------");
    }

    public void onDisable() {
        Config.saveValues(CONFIG);
        this.saveConfig();
        pluginTicker.cancel();
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this, "mod_observer:mods_for_approval");
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "mod_observer:mods_for_approval");
        LOGGER.info("ModObserver disabled!");
    }
}

