/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modObserverPlugin.commands;

import java.time.Instant;
import net.sn0wix_.modObserverPlugin.commands.ConfirmCommand;
import net.sn0wix_.modObserverPlugin.commands.ModObserverCommandArg;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ConfirmCommandArg
extends ModObserverCommandArg {
    private long timeOfParentExecution = 0L;
    private final int timeToReact;
    private boolean wasExecuted = false;
    private String sender = "";
    private final String warningMessage;

    public ConfirmCommandArg(String command, int secondsToReact, String warningMessage, ModObserverCommandArg.ModObserverCommandExecutor executor) {
        super(command, executor);
        this.timeToReact = secondsToReact;
        this.warningMessage = warningMessage;
    }

    public boolean checkForValidResponseTime() {
        return Instant.now().getEpochSecond() - (long)this.timeToReact <= this.timeOfParentExecution;
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] argsAfterLastCommand) {
        if (!this.wasExecuted) {
            if (ConfirmCommand.containsSender(sender.getName())) {
                if (ConfirmCommand.isLate(sender.getName())) {
                    ConfirmCommand.remove(sender.getName());
                } else {
                    sender.sendMessage(ChatColor.RED + "You have already a command to confirm. Please wait for: " + ConfirmCommand.getRemainingTime(sender.getName()) + "s");
                    return;
                }
            }
            this.wasExecuted = true;
            this.sender = sender.getName();
            this.timeOfParentExecution = Instant.now().getEpochSecond();
            sender.sendMessage(this.warningMessage);
            ConfirmCommand.addSenderToQueue(this);
        } else {
            this.wasExecuted = false;
            super.execute(sender, command, label, argsAfterLastCommand);
            ConfirmCommand.remove(sender.getName());
        }
    }

    public String getSender() {
        return this.sender;
    }

    public int getRemainingTime() {
        return (int)Math.abs(Instant.now().getEpochSecond() - this.timeOfParentExecution - (long)this.timeToReact);
    }
}

