/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modObserverPlugin.commands;

import java.util.List;
import java.util.Optional;
import net.sn0wix_.modObserverPlugin.ModObserverPlugin;
import net.sn0wix_.modObserverPlugin.config.Config;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ModObserverCommandArg {
    private final String command;
    private final List<ModObserverCommandArg> subCommands;
    private final ModObserverCommandExecutor executor;
    private Optional<ModObserverCommandTabCompleter> tabCompleter = Optional.empty();

    public ModObserverCommandArg(String command, List<ModObserverCommandArg> subCommands, ModObserverCommandExecutor executor) {
        this.command = command;
        this.subCommands = subCommands;
        this.executor = executor;
    }

    public ModObserverCommandArg(String command, List<ModObserverCommandArg> subCommands, ModObserverCommandExecutor executor, ModObserverCommandTabCompleter tabCompleter) {
        this.command = command;
        this.executor = executor;
        this.tabCompleter = Optional.of(tabCompleter);
        this.subCommands = subCommands;
    }

    public ModObserverCommandArg(String command, ModObserverCommandExecutor executor, ModObserverCommandTabCompleter tabCompleter) {
        this.command = command;
        this.executor = executor;
        this.tabCompleter = Optional.of(tabCompleter);
        this.subCommands = List.of();
    }

    public ModObserverCommandArg(String command, ModObserverCommandExecutor executor) {
        this.command = command;
        this.executor = executor;
        this.subCommands = List.of();
    }

    public String getCommand() {
        return this.command;
    }

    public List<ModObserverCommandArg> getSubCommands() {
        return this.subCommands;
    }

    public void execute(CommandSender sender, Command command, String label, String[] argsAfterLastCommand) {
        this.executor.execute(sender, command, label, argsAfterLastCommand);
        Config.saveValues(ModObserverPlugin.CONFIG);
    }

    public List<String> onTabCompleted(CommandSender commandSender, Command command, String label, String[] argsAfterLastCommand) {
        if (this.tabCompleter.isPresent()) {
            return this.tabCompleter.get().execute(commandSender, command, label, argsAfterLastCommand);
        }
        return List.of();
    }

    @FunctionalInterface
    public static interface ModObserverCommandExecutor {
        public void execute(CommandSender var1, Command var2, String var3, String[] var4);
    }

    @FunctionalInterface
    public static interface ModObserverCommandTabCompleter {
        public List<String> execute(CommandSender var1, Command var2, String var3, String[] var4);
    }
}

