/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modObserverPlugin.config;

import java.util.ArrayList;
import java.util.List;
import net.sn0wix_.modObserverPlugin.ModObserverPlugin;
import org.bukkit.configuration.file.FileConfiguration;

public class Config {
    public static Mode MODE;
    public static List<String> REQUIRED_MODS;
    public static List<String> WHITELISTED_MODS;
    public static List<String> BLACKLISTED_MODS;
    public static String REQUIRED_MODS_MESSAGE;
    public static String PROHIBITED_MODS_FOUND_MESSAGE;
    public static String MOD_OBSERVER_REQUIRED_MESSAGE;
    public static ArrayList<String> IGNORED_PLAYERS;
    public static ArrayList<String> BLACKLISTED_PLAYERS;
    public static boolean ALLOW_VERIFICATION_TIMER;
    public static int VERIFICATION_TIMER_DELAY;
    public static Boolean ALLOW_COMMAND_INTERFACE;
    public static Boolean MODOBSERVER_REQUIRED;
    private static final String MODE_PATH = "mode";
    private static final String REQUIRED_MODS_PATH = "required_mods";
    private static final String WHITELISTED_MODS_PATH = "whitelisted_mods";
    private static final String BLACKLISTED_MODS_PATH = "blacklisted_mods";
    private static final String REQUIRED_MODS_MESSAGE_PATH = "required_mods_message";
    private static final String PROHIBITED_MODS_FOUND_MESSAGE_PATH = "prohibited_mods_found_message";
    private static final String MOD_OBSERVER_REQUIRED_MESSAGE_PATH = "mod_observer_required_message";
    private static final String IGNORED_PLAYERS_PATH = "ignored_players";
    private static final String BLACKLISTED_PLAYERS_PATH = "blacklisted_players";
    private static final String ALLOW_VERIFICATION_TIMER_PATH = "allow_verification_timer";
    private static final String VERIFICATION_TIMER_VALUE_PATH = "verification_timer_delay_in_sec";
    private static final String ALLOW_COMMAND_INTERFACE_PATH = "allow_command_interface";
    private static final String MODOBSERVER_REQUIRED_PATH = "modobserver_required";

    public static void loadDefaults(FileConfiguration config) {
        String mode = config.getString(MODE_PATH);
        for (Mode value : Mode.values()) {
            if (mode == null || !mode.equals(value.getName())) continue;
            MODE = value;
        }
        if (MODE == null) {
            MODE = Mode.WHITELIST;
            ModObserverPlugin.LOGGER.warning("Found illegal property value, mode: " + mode + ", setting mode to \"whitelist\"");
        }
        try {
            WHITELISTED_MODS = config.getDefaults().getStringList(WHITELISTED_MODS_PATH);
            BLACKLISTED_MODS = config.getDefaults().getStringList(BLACKLISTED_MODS_PATH);
            REQUIRED_MODS = config.getDefaults().getStringList(REQUIRED_MODS_PATH);
            REQUIRED_MODS_MESSAGE = config.getDefaults().getString(REQUIRED_MODS_MESSAGE_PATH);
            PROHIBITED_MODS_FOUND_MESSAGE = config.getDefaults().getString(PROHIBITED_MODS_FOUND_MESSAGE_PATH);
            MOD_OBSERVER_REQUIRED_MESSAGE = config.getDefaults().getString(MOD_OBSERVER_REQUIRED_MESSAGE_PATH);
            IGNORED_PLAYERS = (ArrayList)config.getDefaults().getStringList(IGNORED_PLAYERS_PATH);
            BLACKLISTED_PLAYERS = (ArrayList)config.getDefaults().getStringList(BLACKLISTED_PLAYERS_PATH);
            ALLOW_VERIFICATION_TIMER = config.getDefaults().getBoolean(ALLOW_VERIFICATION_TIMER_PATH);
            VERIFICATION_TIMER_DELAY = config.getDefaults().getInt(VERIFICATION_TIMER_VALUE_PATH);
            ALLOW_COMMAND_INTERFACE = config.getDefaults().getBoolean(ALLOW_COMMAND_INTERFACE_PATH);
            MODOBSERVER_REQUIRED = config.getDefaults().getBoolean(MODOBSERVER_REQUIRED_PATH);
        }
        catch (NullPointerException e) {
            ModObserverPlugin.LOGGER.warning("Can not load config defaults! Try deleting current config file to load them. If the issue persists, download the plugin again.");
        }
        Config.saveValues(ModObserverPlugin.CONFIG);
    }

    public static void loadValues(FileConfiguration config) {
        String mode = config.getString(MODE_PATH);
        for (Mode value : Mode.values()) {
            if (mode == null || !mode.equals(value.getName())) continue;
            MODE = value;
        }
        if (MODE == null) {
            MODE = Mode.WHITELIST;
            ModObserverPlugin.LOGGER.warning("Found illegal property value, mode: " + mode + ", setting mode to \"whitelist\"");
        }
        WHITELISTED_MODS = config.getStringList(WHITELISTED_MODS_PATH);
        BLACKLISTED_MODS = config.getStringList(BLACKLISTED_MODS_PATH);
        REQUIRED_MODS = config.getStringList(REQUIRED_MODS_PATH);
        REQUIRED_MODS_MESSAGE = config.getString(REQUIRED_MODS_MESSAGE_PATH);
        PROHIBITED_MODS_FOUND_MESSAGE = config.getString(PROHIBITED_MODS_FOUND_MESSAGE_PATH);
        MOD_OBSERVER_REQUIRED_MESSAGE = config.getString(MOD_OBSERVER_REQUIRED_MESSAGE_PATH);
        IGNORED_PLAYERS = (ArrayList)config.getStringList(IGNORED_PLAYERS_PATH);
        BLACKLISTED_PLAYERS = (ArrayList)config.getStringList(BLACKLISTED_PLAYERS_PATH);
        ALLOW_VERIFICATION_TIMER = config.getBoolean(ALLOW_VERIFICATION_TIMER_PATH);
        VERIFICATION_TIMER_DELAY = config.getInt(VERIFICATION_TIMER_VALUE_PATH);
        ALLOW_COMMAND_INTERFACE = config.getBoolean(ALLOW_COMMAND_INTERFACE_PATH);
        MODOBSERVER_REQUIRED = config.getBoolean(MODOBSERVER_REQUIRED_PATH);
        Config.saveValues(ModObserverPlugin.CONFIG);
    }

    public static void saveValues(FileConfiguration config) {
        config.setComments(MODE_PATH, List.of("EDIT THIS FILE ONLY IF THE SERVER IS NOT RUNNING, OTHERWISE ALL CHANGES WILL BE LOST!", "USE /modobserver TO CONFIGURE THE PLUGIN IN-GAME", "Can have values: \"whitelist\", which will allow only the whitelisted mods, or \"blacklist\", which will allow everything else, except the blacklisted mods."));
        config.setComments(REQUIRED_MODS_PATH, List.of("Mods that the user must have installed. Disable this by leaving it empty."));
        config.setComments(WHITELISTED_MODS_PATH, List.of("Whitelist for mods, use modid of the mod.", "What is modid? https://fabricmc.net/wiki/tutorial:terms", "The default whitelist has all the mods, that are needed for ModObserver to work.", "If you deleted these mods, you can use /modobserver whitelist addDefaults to add them back."));
        config.setComments(BLACKLISTED_MODS_PATH, List.of("Blacklist for mods."));
        config.setComments(REQUIRED_MODS_MESSAGE_PATH, List.of("Message that is sent when the player doesn't have required mods. Use <$MODS$> where you want the list to be added."));
        config.setComments(PROHIBITED_MODS_FOUND_MESSAGE_PATH, List.of("This message will be the kick message if the player has prohibited mods."));
        config.setComments(MOD_OBSERVER_REQUIRED_MESSAGE, List.of("Message that will show up, if the player tries to connect without ModObserver."));
        config.setComments(IGNORED_PLAYERS_PATH, List.of("Players that bypass the mod check. Use player names, not uuids."));
        config.setComments(ALLOW_VERIFICATION_TIMER_PATH, List.of("Checks online players consistently every x seconds"));
        config.setComments(ALLOW_COMMAND_INTERFACE_PATH, List.of("You can turn off commands used to configure this plugin. Updating this option requires server restart.", "If you turn this off, /modobserver will still show up in the commands list, but it won't do anything."));
        config.setComments(MODOBSERVER_REQUIRED_PATH, List.of("If this setting is set to false, players don't need to have ModObserver installed"));
        config.setComments(BLACKLISTED_PLAYERS_PATH, List.of("If modobserver_required is set to false, you can use this list to force specific players to use ModObserver"));
        config.set(MODE_PATH, (Object)MODE.getName());
        config.set(WHITELISTED_MODS_PATH, WHITELISTED_MODS);
        config.set(BLACKLISTED_MODS_PATH, BLACKLISTED_MODS);
        config.set(REQUIRED_MODS_PATH, REQUIRED_MODS);
        config.set(REQUIRED_MODS_MESSAGE_PATH, (Object)REQUIRED_MODS_MESSAGE);
        config.set(PROHIBITED_MODS_FOUND_MESSAGE_PATH, (Object)PROHIBITED_MODS_FOUND_MESSAGE);
        config.set(MOD_OBSERVER_REQUIRED_MESSAGE_PATH, (Object)MOD_OBSERVER_REQUIRED_MESSAGE);
        config.set(IGNORED_PLAYERS_PATH, IGNORED_PLAYERS);
        config.set(BLACKLISTED_PLAYERS_PATH, BLACKLISTED_PLAYERS);
        config.set(ALLOW_VERIFICATION_TIMER_PATH, (Object)ALLOW_VERIFICATION_TIMER);
        config.set(VERIFICATION_TIMER_VALUE_PATH, (Object)VERIFICATION_TIMER_DELAY);
        config.set(ALLOW_COMMAND_INTERFACE_PATH, (Object)ALLOW_COMMAND_INTERFACE);
        config.set(MODOBSERVER_REQUIRED_PATH, (Object)MODOBSERVER_REQUIRED);
    }

    public static List<String> getDefaultWhitelist(FileConfiguration configuration) {
        try {
            return configuration.getDefaults().getStringList(WHITELISTED_MODS_PATH);
        }
        catch (NullPointerException e) {
            ModObserverPlugin.LOGGER.warning("Could not load default whitelist!");
            return null;
        }
    }

    public static enum Mode {
        WHITELIST("whitelist"),
        BLACKLIST("blacklist");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

