/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modObserverPlugin.players;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.sn0wix_.modObserverPlugin.Util;

public class IncomingPlayers {
    private static final ArrayList<IncomingPlayer> PLAYERS = new ArrayList();

    public static boolean containsPlayer(String playerName) {
        AtomicBoolean bl = new AtomicBoolean(false);
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName)) {
                bl.set(true);
            }
        });
        return bl.get();
    }

    public static void removePlayer(String playerName) {
        PLAYERS.removeIf(player -> player.getName().equals(playerName));
    }

    public static void addPlayer(String playerName) {
        PLAYERS.add(new IncomingPlayer(playerName));
    }

    public static void setApproved(String playerName) {
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName)) {
                incomingPlayer.setApproved(true);
            }
        });
    }

    public static void setHasSendPacket(String playerName) {
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName)) {
                incomingPlayer.setHasSendPacket(true);
            }
        });
    }

    public static boolean hasSendPacket(String playerName) {
        AtomicBoolean bl = new AtomicBoolean(false);
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName) && incomingPlayer.hasSendPacket()) {
                bl.set(true);
            }
        });
        return bl.get();
    }

    public static boolean isApproved(String playerName) {
        AtomicBoolean bl = new AtomicBoolean(false);
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName) && incomingPlayer.isApproved()) {
                bl.set(true);
            }
        });
        return bl.get();
    }

    public static String getMissingRequiredMods(String playerName) {
        AtomicReference modsList = new AtomicReference(new ArrayList());
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName)) {
                modsList.set(incomingPlayer.getNonApprovedMods());
            }
        });
        return Util.getModString(modsList.get());
    }

    public static void addMissingRequiredMod(String playerName, String modid) {
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName)) {
                incomingPlayer.addNonApprovedMod(modid);
            }
        });
    }

    public static String getNonApprovedMods(String playerName) {
        AtomicReference modsList = new AtomicReference();
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName)) {
                modsList.set(incomingPlayer.getMissingRequiredMods());
            }
        });
        return Util.getModString((List)modsList.get());
    }

    public static void addNonApprovedMod(String playerName, String modid) {
        PLAYERS.forEach(incomingPlayer -> {
            if (incomingPlayer.getName().equals(playerName)) {
                incomingPlayer.addMissingRequiredMod(modid);
            }
        });
    }

    public static class IncomingPlayer {
        private final String name;
        private boolean isApproved = false;
        private boolean hasSendPacket = false;
        private final ArrayList<String> notApprovedMods = new ArrayList();
        private final ArrayList<String> missingRequiredMods = new ArrayList();

        public IncomingPlayer(String name) {
            this.name = name;
        }

        public void setHasSendPacket(boolean send) {
            this.hasSendPacket = send;
        }

        public boolean hasSendPacket() {
            return this.hasSendPacket;
        }

        public void addMissingRequiredMod(String modid) {
            this.missingRequiredMods.add(modid);
        }

        public List<String> getMissingRequiredMods() {
            return this.missingRequiredMods;
        }

        public void addNonApprovedMod(String modid) {
            this.notApprovedMods.add(modid);
        }

        public List<String> getNonApprovedMods() {
            return this.notApprovedMods;
        }

        public String getName() {
            return this.name;
        }

        public boolean isApproved() {
            return this.isApproved;
        }

        public void setApproved(boolean approved) {
            this.isApproved = approved;
        }
    }
}

