/*
 * Decompiled with CFR 0.152.
 */
package net.sn0wix_.modObserverPlugin.players;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import net.sn0wix_.modObserverPlugin.Util;
import net.sn0wix_.modObserverPlugin.config.Config;
import net.sn0wix_.modObserverPlugin.players.WaitingForResponsePlayers;
import org.bukkit.Bukkit;

public class OnlinePlayersToCheck {
    private static final HashMap<String, Long> PLAYERS = new HashMap();

    public static void addPlayer(String playerName) {
        PLAYERS.put(playerName, Instant.now().getEpochSecond());
    }

    public static void addPlayer(String playerName, long time) {
        PLAYERS.put(playerName, time);
    }

    public static boolean contains(String playerName) {
        return PLAYERS.containsKey(playerName);
    }

    public static void removePlayer(String playerName) {
        PLAYERS.remove(playerName);
    }

    public static void tick() {
        if (Config.ALLOW_VERIFICATION_TIMER && !PLAYERS.isEmpty()) {
            ArrayList<String> playersToReset = new ArrayList<String>(0);
            PLAYERS.forEach((playerName, aLong) -> {
                if (Instant.now().getEpochSecond() - aLong >= (long)Config.VERIFICATION_TIMER_DELAY) {
                    playersToReset.add((String)playerName);
                    WaitingForResponsePlayers.addPlayer(new WaitingForResponsePlayers.WaitingForResponsePlayer((String)playerName, Instant.now().getEpochSecond(), modids -> Util.checkPlayer(playerName, modids, true), () -> {
                        if (Bukkit.getPlayerExact((String)playerName) != null) {
                            Bukkit.getPlayerExact((String)playerName).kickPlayer(Config.MOD_OBSERVER_REQUIRED_MESSAGE);
                        } else {
                            PLAYERS.remove(playerName);
                        }
                    }));
                }
            });
            playersToReset.forEach(playerToReset -> PLAYERS.put((String)playerToReset, Instant.now().getEpochSecond()));
        }
    }
}

