/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams;

import dev.xf3d3.ultimateteams.api.UltimateTeamsAPI;
import dev.xf3d3.ultimateteams.api.UltimateTeamsAPIImpl;
import dev.xf3d3.ultimateteams.commands.TeamAdmin;
import dev.xf3d3.ultimateteams.commands.TeamCommand;
import dev.xf3d3.ultimateteams.commands.chat.TeamAllyChatCommand;
import dev.xf3d3.ultimateteams.commands.chat.TeamChatCommand;
import dev.xf3d3.ultimateteams.commands.chat.TeamChatSpyCommand;
import dev.xf3d3.ultimateteams.config.MessagesFileManager;
import dev.xf3d3.ultimateteams.config.Settings;
import dev.xf3d3.ultimateteams.config.TeamsGui;
import dev.xf3d3.ultimateteams.database.Database;
import dev.xf3d3.ultimateteams.database.H2Database;
import dev.xf3d3.ultimateteams.database.MySqlDatabase;
import dev.xf3d3.ultimateteams.database.PostgreSqlDatabase;
import dev.xf3d3.ultimateteams.database.SQLiteDatabase;
import dev.xf3d3.ultimateteams.hooks.FloodgateHook;
import dev.xf3d3.ultimateteams.hooks.HuskHomesHook;
import dev.xf3d3.ultimateteams.hooks.LuckPermsHook;
import dev.xf3d3.ultimateteams.hooks.PapiExpansion;
import dev.xf3d3.ultimateteams.hooks.VaultHook;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BukkitCommandManager;
import dev.xf3d3.ultimateteams.libraries.bstats.bukkit.Metrics;
import dev.xf3d3.ultimateteams.libraries.bstats.charts.SimplePie;
import dev.xf3d3.ultimateteams.libraries.folialib.FoliaLib;
import dev.xf3d3.ultimateteams.libraries.folialib.impl.PlatformScheduler;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.libraries.william278.annotaml.Annotaml;
import dev.xf3d3.ultimateteams.libraries.william278.desertwell.util.ThrowingConsumer;
import dev.xf3d3.ultimateteams.libraries.william278.desertwell.util.Version;
import dev.xf3d3.ultimateteams.listeners.PlayerChatEvent;
import dev.xf3d3.ultimateteams.listeners.PlayerConnectEvent;
import dev.xf3d3.ultimateteams.listeners.PlayerDamageEvent;
import dev.xf3d3.ultimateteams.listeners.PlayerDisconnectEvent;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.User;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.PluginMessageBroker;
import dev.xf3d3.ultimateteams.network.RedisBroker;
import dev.xf3d3.ultimateteams.utils.EnderChestBackupManager;
import dev.xf3d3.ultimateteams.utils.TaskRunner;
import dev.xf3d3.ultimateteams.utils.TeamInviteUtil;
import dev.xf3d3.ultimateteams.utils.TeamsStorage;
import dev.xf3d3.ultimateteams.utils.UpdateCheck;
import dev.xf3d3.ultimateteams.utils.UsersStorage;
import dev.xf3d3.ultimateteams.utils.Utils;
import dev.xf3d3.ultimateteams.utils.gson.GsonUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.geysermc.floodgate.api.FloodgateApi;

public final class UltimateTeams
extends JavaPlugin
implements TaskRunner,
GsonUtils,
PluginMessageListener {
    private static UltimateTeams instance;
    private UltimateTeamsAPI api;
    public boolean loaded = false;
    private static final int METRICS_ID = 18842;
    private final PluginDescriptionFile pluginInfo = this.getDescription();
    private final String pluginVersion = this.pluginInfo.getVersion();
    public MessagesFileManager msgFileManager;
    private Database database;
    @Nullable
    private Broker broker;
    private FoliaLib foliaLib;
    private BukkitCommandManager manager;
    private TeamsStorage teamsStorage;
    private UsersStorage usersStorage;
    private TeamInviteUtil teamInviteUtil;
    private FloodgateHook floodgateHook;
    private UpdateCheck updateChecker;
    private HuskHomesHook huskHomesHook;
    private Utils utils;
    private Settings settings;
    private TeamsGui teamsGui;
    @Nullable
    private VaultHook economyHook;
    private EnderChestBackupManager backupManager;
    private final ConcurrentHashMap<String, Player> bedrockPlayers = new ConcurrentHashMap();

    public void onLoad() {
        instance = this;
    }

    private void initialize(@NotNull String name, @NotNull ThrowingConsumer<UltimateTeams> runner) {
        this.log(Level.INFO, "Initializing " + name + "...", new Throwable[0]);
        try {
            runner.accept(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize " + name, e);
        }
        this.log(Level.INFO, "Successfully initialized " + name, new Throwable[0]);
    }

    public void onEnable() {
        this.foliaLib = new FoliaLib((Plugin)this);
        this.manager = new BukkitCommandManager((Plugin)this);
        this.msgFileManager = new MessagesFileManager(this);
        this.teamsStorage = new TeamsStorage(this);
        this.usersStorage = new UsersStorage(this);
        this.teamInviteUtil = new TeamInviteUtil(this);
        this.utils = new Utils(this);
        this.updateChecker = new UpdateCheck(this);
        this.api = new UltimateTeamsAPIImpl(this);
        this.initialize("plugin config & locale files", plugin -> {
            if (!this.loadConfigs()) {
                throw new IllegalStateException("Failed to load config files. Please check the console for errors");
            }
        });
        this.initialize(this.getSettings().getDatabaseType().getDisplayName() + " database connection", plugin -> {
            this.database = switch (this.getSettings().getDatabaseType()) {
                default -> throw new IncompatibleClassChangeError();
                case Database.Type.MYSQL, Database.Type.MARIADB -> new MySqlDatabase(this);
                case Database.Type.SQLITE -> new SQLiteDatabase(this);
                case Database.Type.H2 -> new H2Database(this);
                case Database.Type.POSTGRESQL -> new PostgreSqlDatabase(this);
            };
            this.database.initialize();
        });
        if (this.getSettings().isEnableCrossServer()) {
            this.initialize(String.valueOf((Object)this.getSettings().getBrokerType()) + " broker", plugin -> {
                Broker.Type brokerType = this.getSettings().getBrokerType();
                this.broker = switch (brokerType) {
                    default -> throw new IncompatibleClassChangeError();
                    case Broker.Type.PLUGIN_MESSAGE -> new PluginMessageBroker(this);
                    case Broker.Type.REDIS -> new RedisBroker(this);
                };
                this.broker.initialize();
            });
        }
        this.initialize("commands", plugin -> {
            this.manager.registerCommand(new TeamCommand(this));
            this.manager.registerCommand(new TeamChatSpyCommand(this));
            this.manager.registerCommand(new TeamChatCommand(this));
            this.manager.registerCommand(new TeamAllyChatCommand(this));
            this.manager.registerCommand(new TeamAdmin(this));
        });
        this.initialize("events", plugin -> {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectEvent(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerDisconnectEvent(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerDamageEvent(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatEvent(this), (Plugin)this);
        });
        this.initialize("teams", plugin -> this.runAsync(task -> this.teamsStorage.loadTeams()));
        this.initialize("ender chest backup manager", plugin -> {
            this.backupManager = new EnderChestBackupManager(this);
        });
        if (Bukkit.getPluginManager().getPlugin("HuskHomes") != null && this.getSettings().HuskHomesHook()) {
            this.initialize("huskhomes", plugin -> {
                this.huskHomesHook = new HuskHomesHook(this);
            });
        }
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null && this.getSettings().LuckPermsHook()) {
            this.initialize("luckperms", plugin -> new LuckPermsHook(this));
        }
        this.manager.getCommandCompletions().registerAsyncCompletion("onlineUsers", c -> this.getUsersStorageUtil().getUserList().stream().map(User::getUsername).collect(Collectors.toList()));
        this.manager.getCommandCompletions().registerAsyncCompletion("teams", c -> this.teamsStorage.getTeamsName().stream().map(Utils::removeColors).collect(Collectors.toList()));
        this.manager.getCommandCompletions().registerAsyncCompletion("warps", c -> this.getTeamStorageUtil().findTeamByMember(c.getPlayer().getUniqueId()).map(team -> team.getWarps().keySet()).orElse(Collections.emptySet()));
        this.manager.getCommandCompletions().registerAsyncCompletion("teamPlayers", c -> this.getTeamStorageUtil().findTeamByMember(c.getPlayer().getUniqueId()).map(team -> team.getMembers().keySet().stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName()).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        this.manager.getCommandCompletions().registerAsyncCompletion("allies", c -> this.getTeamStorageUtil().findTeamByMember(c.getPlayer().getUniqueId()).map(team -> team.getRelations(this).entrySet().stream().filter(teamRelationEntry -> teamRelationEntry.getValue() == Team.Relation.ALLY).map(entry -> ((Team)entry.getKey()).getName()).map(Utils::removeColors).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        this.manager.getCommandCompletions().registerAsyncCompletion("enemies", c -> this.getTeamStorageUtil().findTeamByMember(c.getPlayer().getUniqueId()).map(team -> team.getRelations(this).entrySet().stream().filter(teamRelationEntry -> teamRelationEntry.getValue() == Team.Relation.ENEMY).map(entry -> ((Team)entry.getKey()).getName()).map(Utils::removeColors).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        this.manager.getCommandCompletions().registerAsyncCompletion("teamChests", c -> this.getTeamStorageUtil().findTeamByMember(c.getPlayer().getUniqueId()).map(team -> team.getEnderChests().keySet().stream().map(String::valueOf).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        this.manager.getCommandCompletions().registerAsyncCompletion("teamPermissions", c -> this.getTeamStorageUtil().findTeamByMember(c.getPlayer().getUniqueId()).map(team -> team.getPermissions().stream().map(String::valueOf).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        this.manager.getCommandCompletions().registerAsyncCompletion("permissions", c -> Arrays.stream(Team.Permission.values()).map(String::valueOf).collect(Collectors.toSet()));
        TeamCommand.updateBannedTagsList();
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") || this.isPlaceholderAPIEnabled()) {
            this.sendConsole("-------------------------------------------");
            this.sendConsole("&6UltimateTeams: &3PlaceholderAPI found!");
            this.initialize("placeholderapi", plugin -> new PapiExpansion(this).register());
            this.sendConsole("&6UltimateTeams: &3External placeholders enabled!");
            this.sendConsole("-------------------------------------------");
        } else {
            this.sendConsole("-------------------------------------------");
            this.sendConsole("&6UltimateTeams: &cPlaceholderAPI not found!");
            this.sendConsole("&6UltimateTeams: &cExternal placeholders disabled!");
            this.sendConsole("-------------------------------------------");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("floodgate") && this.getSettings().FloodGateHook()) {
            this.sendConsole("-------------------------------------------");
            this.sendConsole("&6UltimateTeams: &3FloodgateApi found!");
            this.initialize("floodgate", plugin -> {
                this.floodgateHook = new FloodgateHook();
            });
            this.sendConsole("&6UltimateTeams: &3Full Bedrock support enabled!");
            this.sendConsole("-------------------------------------------");
        } else {
            this.sendConsole("-------------------------------------------");
            this.sendConsole("&6UltimateTeams: &3FloodgateApi not found/feature disabled!");
            this.sendConsole("&6UltimateTeams: &3Bedrock support won't work!");
            this.sendConsole("-------------------------------------------");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Vault") && this.getSettings().isEconomyEnabled()) {
            this.initialize("economy", plugin -> {
                this.economyHook = new VaultHook(this);
            });
        }
        if (this.getSettings().enableAutoInviteWipe()) {
            this.runSyncRepeating(() -> {
                this.teamInviteUtil.emptyInviteList();
                if (this.getSettings().enableAutoInviteWipeLog()) {
                    this.sendConsole(this.msgFileManager.getMessagesConfig().getString("auto-invite-wipe-complete"));
                }
            }, 12000L);
        }
        this.initialize("metrics", plugin -> this.registerMetrics(18842));
        if (this.getSettings().doCheckForUpdates()) {
            this.updateChecker.checkForUpdates();
        }
        this.sendConsole("-------------------------------------------");
        this.sendConsole("&6UltimateTeams: &3Plugin by: &b&lxF3d3");
        this.sendConsole("&6UltimateTeams: &3Contributors: &b&ldei0 (TeamEnderChest)");
        this.sendConsole("&6UltimateTeams: &3Version: &d&l" + this.pluginVersion);
        this.sendConsole("&6UltimateTeams: &aSuccessfully enabled!");
        this.sendConsole("-------------------------------------------");
    }

    public void onDisable() {
        this.sendConsole("-------------------------------------------");
        this.sendConsole("&6UltimateTeams: &3Plugin by: &b&lxF3d3");
        this.sendConsole("&6UltimateTeams: &3Contributors: &b&ldei0 (TeamEnderChest)");
        if (this.backupManager != null) {
            this.backupManager.shutdown();
        }
        this.getScheduler().cancelAllTasks();
        this.database.close();
        this.sendConsole("&6UltimateTeams: &3Plugin Version: &d&l" + this.pluginVersion);
        this.sendConsole("&6UltimateTeams: &3Has been shutdown successfully");
        this.sendConsole("&6UltimateTeams: &3Goodbye!");
        this.sendConsole("-------------------------------------------");
    }

    public void setSettings(@NotNull Settings settings) {
        this.settings = settings;
    }

    public void setGuiFile(@NotNull TeamsGui teamsGui) {
        this.teamsGui = teamsGui;
    }

    public boolean loadConfigs() {
        try {
            this.setSettings((Settings)((Object)Annotaml.create(new File(this.getDataFolder(), "config.yml"), Settings.class).get()));
            this.setGuiFile((TeamsGui)((Object)Annotaml.create(new File(this.getDataFolder(), "teamgui.yml"), TeamsGui.class).get()));
            return true;
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.log(Level.SEVERE, "Failed to reload UltimateTeams config or messages file", e);
            return false;
        }
    }

    private boolean isPlaceholderAPIEnabled() {
        try {
            Class.forName("me.clip.placeholderapi.PlaceholderAPIPlugin");
            if (this.getSettings().debugModeEnabled()) {
                this.sendConsole("&6UltimateTeams-Debug: &aFound PlaceholderAPI main class at:");
                this.sendConsole("&6UltimateTeams-Debug: &dme.clip.placeholderapi.PlaceholderAPIPlugin");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            if (this.getSettings().debugModeEnabled()) {
                this.sendConsole("&6UltimateTeams-Debug: &aCould not find PlaceholderAPI main class at:");
                this.sendConsole("&6UltimateTeams-Debug: &dme.clip.placeholderapi.PlaceholderAPIPlugin");
            }
            return false;
        }
    }

    public void registerMetrics(int metricsId) {
        try {
            Metrics metrics = new Metrics((Plugin)this, metricsId);
            metrics.addCustomChart(new SimplePie("database_type", () -> this.getSettings().getDatabaseType().getDisplayName()));
            metrics.addCustomChart(new SimplePie("huskhomes_hook", () -> Boolean.toString(this.getSettings().HuskHomesHook())));
            metrics.addCustomChart(new SimplePie("floodgate_hook", () -> Boolean.toString(this.getSettings().FloodGateHook())));
            metrics.addCustomChart(new SimplePie("economy", () -> Boolean.toString(this.getSettings().isEconomyEnabled())));
            metrics.addCustomChart(new SimplePie("cross_server", () -> Boolean.toString(this.getSettings().isEnableCrossServer())));
            if (this.getSettings().isEnableCrossServer()) {
                metrics.addCustomChart(new SimplePie("broker_type", () -> this.getSettings().getBrokerType().name().toLowerCase()));
            }
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed to register bStats metrics", e);
        }
    }

    public void initializePluginChannels() {
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        Broker broker;
        if (this.broker != null && (broker = this.broker) instanceof PluginMessageBroker) {
            PluginMessageBroker pluginMessenger = (PluginMessageBroker)broker;
            if (this.getSettings().getBrokerType() == Broker.Type.PLUGIN_MESSAGE) {
                pluginMessenger.onReceive(channel, player, message);
            }
        }
    }

    public void log(@NotNull Level level, @NotNull String message, Throwable ... throwable) {
        if (throwable != null && throwable.length > 0) {
            this.getLogger().log(level, message, throwable[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    @NotNull
    public Optional<Broker> getMessageBroker() {
        return Optional.ofNullable(this.broker);
    }

    @NotNull
    public Version getPluginVersion() {
        return Version.fromString(this.getDescription().getVersion());
    }

    public static UltimateTeamsAPI getAPI() {
        return UltimateTeams.instance.api;
    }

    public void sendConsole(String text) {
        Bukkit.getConsoleSender().sendMessage(Utils.Color(text));
    }

    public static UltimateTeams getPlugin() {
        return instance;
    }

    @NotNull
    public TeamsStorage getTeamStorageUtil() {
        return this.teamsStorage;
    }

    @NotNull
    public UsersStorage getUsersStorageUtil() {
        return this.usersStorage;
    }

    @NotNull
    public TeamInviteUtil getTeamInviteUtil() {
        return this.teamInviteUtil;
    }

    public FloodgateApi getFloodgateApi() {
        return this.floodgateHook.getHook();
    }

    @Override
    @NotNull
    public PlatformScheduler getScheduler() {
        return this.foliaLib.getScheduler();
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public HuskHomesHook getHuskHomesHook() {
        return this.huskHomesHook;
    }

    @Generated
    public Utils getUtils() {
        return this.utils;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public TeamsGui getTeamsGui() {
        return this.teamsGui;
    }

    @Nullable
    @Generated
    public VaultHook getEconomyHook() {
        return this.economyHook;
    }

    @Generated
    public EnderChestBackupManager getBackupManager() {
        return this.backupManager;
    }
}

