/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.commands.subCommands.TeamCreateSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.TeamInfoSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.TeamListSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.TeamPermissionsSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.TeamPrefixSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.TeamRenameSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.disband.TeamDisbandConfirmSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.disband.TeamDisbandSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.echest.TeamEnderChestSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.home.TeamDelHomeSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.home.TeamHomeSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.home.TeamSetHomeSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.members.TeamInviteSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.members.TeamKickSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.members.TeamLeaveSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.members.TeamManagersSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.members.TeamPvpSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.members.TeamTransferOwnerSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.relations.TeamAllySubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.relations.TeamEnemySubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.warps.TeamDelWarpSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.warps.TeamSetWarpSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.warps.TeamWarpSubCommand;
import dev.xf3d3.ultimateteams.gui.TeamList;
import dev.xf3d3.ultimateteams.gui.TeamManager;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Optional;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Subcommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Syntax;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Values;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

@CommandAlias(value="team")
@CommandPermission(value="ultimateteams.player")
public class TeamCommand
extends BaseCommand {
    private final FileConfiguration messagesConfig;
    private static List<String> bannedTags;
    private final UltimateTeams plugin;

    public TeamCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public static void updateBannedTagsList() {
        bannedTags = UltimateTeams.getPlugin().getSettings().getTeamTagsDisallowedList();
    }

    @Default
    @CommandCompletion(value="@nothing")
    public void onTeamCommand(@NotNull CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getSettings().useGlobalGui()) {
                if (this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).isPresent()) {
                    new TeamManager(this.plugin, player);
                } else {
                    new TeamList(this.plugin, player);
                }
                return;
            }
            for (int i = 1; i <= 19; ++i) {
                String message = this.messagesConfig.getString(String.format("team-command-incorrect-usage.line-%s", i));
                sender.sendMessage(Utils.Color(message));
            }
        }
    }

    @Subcommand(value="gui")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.gui")
    public void onTeamGUICommand(@NotNull CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getTeamStorageUtil().isInTeam(player)) {
            new TeamManager(this.plugin, player);
        } else {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team")));
        }
    }

    @Subcommand(value="create")
    @CommandCompletion(value="<name> @nothing")
    @Syntax(value="<name>")
    @CommandPermission(value="ultimateteams.team.create")
    public void onTeamCreateCommand(@NotNull CommandSender sender, String name) {
        new TeamCreateSubCommand(this.plugin).createTeamSubCommand(sender, name, bannedTags);
    }

    @Subcommand(value="rename")
    @CommandCompletion(value="<newname> @nothing")
    @Syntax(value="<newname>")
    @CommandPermission(value="ultimateteams.team.rename")
    public void onTeamRenameCommand(@NotNull CommandSender sender, String name) {
        new TeamRenameSubCommand(this.plugin).renameTeamSubCommand(sender, name, bannedTags);
    }

    @Subcommand(value="warp")
    @CommandCompletion(value="@warps @nothing")
    @Syntax(value="<name>")
    @CommandPermission(value="ultimateteams.team.warp")
    public void onTeamWarpCommand(@NotNull CommandSender sender, @Values(value="@warps") String name) {
        new TeamWarpSubCommand(this.plugin).WarpCommand(sender, name);
    }

    @Subcommand(value="setwarp")
    @CommandCompletion(value="<name> @nothing")
    @Syntax(value="<name>")
    @CommandPermission(value="ultimateteams.team.setwarp")
    public void onTeamSetWarpCommand(@NotNull CommandSender sender, String name) {
        new TeamSetWarpSubCommand(this.plugin).setWarpCommand(sender, name);
    }

    @Subcommand(value="delwarp")
    @CommandCompletion(value="@warps @nothing")
    @Syntax(value="<name>")
    @CommandPermission(value="ultimateteams.team.delwarp")
    public void onTeamDelWarpCommand(@NotNull CommandSender sender, @Values(value="@warps") String name) {
        new TeamDelWarpSubCommand(this.plugin).delWarpCommand(sender, name);
    }

    @Subcommand(value="disband")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.disband")
    public void onTeamDisbandCommand(@NotNull CommandSender sender) {
        new TeamDisbandSubCommand(this.plugin).disbandTeamSubCommand(sender);
    }

    @Subcommand(value="disband confirm")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.disband")
    public void onTeamDisbandConfirmCommand(@NotNull CommandSender sender) {
        new TeamDisbandConfirmSubCommand(this.plugin).disbandTeamSubCommand(sender);
    }

    @Subcommand(value="invite send")
    @CommandCompletion(value="@onlineUsers @nothing")
    @Syntax(value="<playername>")
    @CommandPermission(value="ultimateteams.team.invite.send")
    public void onTeamInviteSendCommand(@NotNull CommandSender sender, @Values(value="@onlineUsers") String invitee) {
        new TeamInviteSubCommand(this.plugin).teamInviteSendSubCommand(sender, invitee);
    }

    @Subcommand(value="invite")
    @CommandCompletion(value="@onlineUsers @nothing")
    @Syntax(value="<playername>")
    @CommandPermission(value="ultimateteams.team.invite.send")
    public void onTeamInviteCommand(@NotNull CommandSender sender, @Values(value="@onlineUsers") String invitee) {
        new TeamInviteSubCommand(this.plugin).teamInviteSendSubCommand(sender, invitee);
    }

    @Subcommand(value="invite accept")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.invite.accept")
    public void onTeamInviteAcceptCommand(@NotNull CommandSender sender) {
        new TeamInviteSubCommand(this.plugin).teamInviteAcceptSubCommand(sender);
    }

    @Subcommand(value="invite deny")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.invite.deny")
    public void onTeamInviteDenyCommand(@NotNull CommandSender sender) {
        new TeamInviteSubCommand(this.plugin).teamInviteDenySubCommand(sender);
    }

    @Subcommand(value="sethome")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.sethome")
    public void onTeamSetHomeCommand(@NotNull CommandSender sender) {
        new TeamSetHomeSubCommand(this.plugin).setTeamHomeSubCommand(sender);
    }

    @Subcommand(value="delhome")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.delhome")
    public void onTeamDelHomeCommand(@NotNull CommandSender sender) {
        new TeamDelHomeSubCommand(this.plugin).deleteTeamHomeSubCommand(sender);
    }

    @Subcommand(value="home")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.home")
    public void onTeamHomeCommand(@NotNull CommandSender sender) {
        new TeamHomeSubCommand(this.plugin).tpTeamHomeSubCommand(sender);
    }

    @Subcommand(value="pvp")
    @CommandCompletion(value="@nothing")
    @Syntax(value="<true/false>")
    @CommandPermission(value="ultimateteams.team.pvp")
    public void onTeamPvPCommand(@NotNull CommandSender sender) {
        new TeamPvpSubCommand(this.plugin).teamPvpSubCommand(sender);
    }

    @Subcommand(value="enemy")
    public void onTeamEnemyCommand(@NotNull CommandSender sender) {
        for (int i = 1; i <= 19; ++i) {
            String message = this.messagesConfig.getString(String.format("team-command-incorrect-usage.line-%s", i));
            sender.sendMessage(Utils.Color(message));
        }
    }

    @Subcommand(value="enemy add")
    @CommandCompletion(value="@teams @nothing")
    @Syntax(value="<teamName>")
    @CommandPermission(value="ultimateteams.team.enemy.add")
    public void onTeamEnemyAddCommand(@NotNull CommandSender sender, @Values(value="@teams") String teamName) {
        new TeamEnemySubCommand(this.plugin).teamEnemySubAddCommand(sender, teamName);
    }

    @Subcommand(value="enemy remove")
    @CommandCompletion(value="@enemies @nothing")
    @Syntax(value="<teamName>")
    @CommandPermission(value="ultimateteams.team.enemy.remove")
    public void onTeamEnemyRemoveCommand(@NotNull CommandSender sender, @Values(value="@enemies") String teamName) {
        new TeamEnemySubCommand(this.plugin).teamEnemySubRemoveCommand(sender, teamName);
    }

    @Subcommand(value="ally")
    public void onTeamAllyCommand(@NotNull CommandSender sender) {
        for (int i = 1; i <= 19; ++i) {
            String message = this.messagesConfig.getString(String.format("team-command-incorrect-usage.line-%s", i));
            sender.sendMessage(Utils.Color(message));
        }
    }

    @Subcommand(value="ally add")
    @CommandCompletion(value="@teams @nothing")
    @Syntax(value="<teamName>")
    @CommandPermission(value="ultimateteams.team.ally.add")
    public void onTeamAllyAddCommand(@NotNull CommandSender sender, @Values(value="@teams") String teamName) {
        new TeamAllySubCommand(this.plugin).teamAllyAddSubCommand(sender, teamName);
    }

    @Subcommand(value="ally remove")
    @CommandCompletion(value="@allies  @nothing")
    @Syntax(value="<teamName>")
    @CommandPermission(value="ultimateteams.team.ally.remove")
    public void onTeamAllyRemoveCommand(@NotNull CommandSender sender, @Values(value="@allies") String teamName) {
        new TeamAllySubCommand(this.plugin).teamAllyRemoveSubCommand(sender, teamName);
    }

    @Subcommand(value="leave")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.leave")
    public void onTeamLeaveCommand(@NotNull CommandSender sender) {
        new TeamLeaveSubCommand(this.plugin).teamLeaveSubCommand(sender);
    }

    @Subcommand(value="kick")
    @CommandCompletion(value="@teamPlayers @nothing")
    @Syntax(value="<player>")
    @CommandPermission(value="ultimateteams.team.kick")
    public void onTeamKickCommand(@NotNull CommandSender sender, @Values(value="@teamPlayers") OfflinePlayer offlinePlayer) {
        new TeamKickSubCommand(this.plugin).teamKickSubCommand(sender, offlinePlayer);
    }

    @Subcommand(value="list")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.list")
    public void onTeamListCommand(@NotNull CommandSender sender) {
        new TeamListSubCommand(this.plugin).teamListSubCommand(sender);
    }

    @Subcommand(value="transfer")
    @CommandCompletion(value="@teamPlayers @nothing")
    @Syntax(value="<player>")
    @CommandPermission(value="ultimateteams.team.transfer")
    public void onTeamTransferCommand(@NotNull CommandSender sender, @Values(value="@teamPlayers") String user) {
        new TeamTransferOwnerSubCommand(this.plugin).transferTeamOwnerSubCommand(sender, user);
    }

    @Subcommand(value="prefix")
    @CommandCompletion(value="<prefix> @nothing")
    @Syntax(value="<prefix>")
    @CommandPermission(value="ultimateteams.team.prefix")
    public void onTeamPrefixCommand(@NotNull CommandSender sender, String prefix) {
        new TeamPrefixSubCommand(this.plugin).teamPrefixSubCommand(sender, prefix, bannedTags);
    }

    @Subcommand(value="info")
    @CommandCompletion(value="@teams")
    @CommandPermission(value="ultimateteams.team.info")
    public void onTeamInfoCommand(@NotNull CommandSender sender, @Optional @Values(value="@teams") String teamName) {
        new TeamInfoSubCommand(this.plugin).teamInfoSubCommand(sender, teamName);
    }

    @Subcommand(value="promote")
    @CommandCompletion(value="@teamPlayers")
    @CommandPermission(value="ultimateteams.team.promote")
    public void onTeamPromoteCommand(@NotNull Player sender, @Values(value="@teamPlayers") OfflinePlayer offlinePlayer) {
        new TeamManagersSubCommand(this.plugin).teamPromoteSubCommand((CommandSender)sender, offlinePlayer);
    }

    @Subcommand(value="demote")
    @CommandCompletion(value="@teamPlayers")
    @CommandPermission(value="ultimateteams.team.demote")
    public void onTeamDemoteCommand(@NotNull Player sender, @Values(value="@teamPlayers") OfflinePlayer offlinePlayer) {
        new TeamManagersSubCommand(this.plugin).teamDemoteSubCommand((CommandSender)sender, offlinePlayer);
    }

    @Subcommand(value="permissions")
    public void onTeamPermissionsCommand(@NotNull CommandSender sender) {
        for (int i = 1; i <= 19; ++i) {
            String message = this.messagesConfig.getString(String.format("team-command-incorrect-usage.line-%s", i));
            sender.sendMessage(Utils.Color(message));
        }
    }

    @Subcommand(value="permissions add")
    @CommandCompletion(value="@permissions @nothing")
    @Syntax(value="<permission>")
    @CommandPermission(value="ultimateteams.team.permissions.add")
    public void onTeamPermissionsAddCommand(@NotNull CommandSender sender, @Values(value="@permissions") String permission) {
        new TeamPermissionsSubCommand(this.plugin).teamPermissionsAddSubCommand(sender, permission);
    }

    @Subcommand(value="permissions remove")
    @CommandCompletion(value="@teamPermissions @nothing")
    @Syntax(value="<permission>")
    @CommandPermission(value="ultimateteams.team.permissions.remove")
    public void onTeamPermissionsRemoveCommand(@NotNull CommandSender sender, @Values(value="@teamPermissions") String permission) {
        new TeamPermissionsSubCommand(this.plugin).teamPermissionsRemoveSubCommand(sender, permission);
    }

    @Subcommand(value="echest")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.team.echest")
    public void onTeamEnderChestCommand(@NotNull CommandSender sender) {
        new TeamEnderChestSubCommand(this.plugin).openEnderChest(sender, 1);
    }

    @Subcommand(value="echest")
    @CommandCompletion(value="@teamChests @nothing")
    @CommandPermission(value="ultimateteams.team.echest")
    public void onTeamEnderChestNumberCommand(@NotNull CommandSender sender, int chestNumber) {
        new TeamEnderChestSubCommand(this.plugin).openEnderChest(sender, chestNumber);
    }
}

