/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.chat;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

@CommandAlias(value="chatspy")
public class TeamChatSpyCommand
extends BaseCommand {
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamChatSpyCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    @CommandCompletion(value="@nothing")
    @Default
    public void onCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getSettings().teamChatSpyEnabled()) {
                if (player.hasPermission("ultimateteams.chat.spy")) {
                    if (this.plugin.getUsersStorageUtil().toggleChatSpy(player)) {
                        player.sendMessage(Utils.Color(this.messagesConfig.getString("chatspy-toggle-on")));
                    } else {
                        player.sendMessage(Utils.Color(this.messagesConfig.getString("chatspy-toggle-off")));
                    }
                } else {
                    player.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                }
            } else {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            }
        }
    }
}

