/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamPermissionsSubCommand {
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamPermissionsSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public void teamPermissionsAddSubCommand(CommandSender sender, String permission) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-must-be-owner")));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            Optional<Team.Permission> perm = Team.Permission.parse(permission);
            if (perm.isEmpty()) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("permission-not-found").replace("%PERM%", permission)));
                return;
            }
            team.addPermission(perm.get());
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-permission-added-successful")).replace("%PERM%", String.valueOf((Object)perm.get())));
        }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }

    public void teamPermissionsRemoveSubCommand(CommandSender sender, String permission) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-must-be-owner")));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            Optional<Team.Permission> perm = Team.Permission.parse(permission);
            if (perm.isEmpty()) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("permission-not-found").replace("%PERM%", permission)));
                return;
            }
            team.removePermission(perm.get());
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-permission-removed-successful")).replace("%PERM%", String.valueOf((Object)perm.get())));
        }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }
}

