/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamPrefixSubCommand {
    private final int MIN_CHAR_LIMIT;
    private final int MAX_CHAR_LIMIT;
    private final FileConfiguration messagesConfig;
    private final UltimateTeams plugin;

    public TeamPrefixSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
        this.MAX_CHAR_LIMIT = plugin.getSettings().getTeamTagsMaxCharLimit();
        this.MIN_CHAR_LIMIT = plugin.getSettings().getTeamTagsMinCharLimit();
    }

    public void teamPrefixSubCommand(CommandSender sender, String prefix, List<String> bannedTags) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (bannedTags.stream().map(String::toLowerCase).toList().contains(prefix.toLowerCase())) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-prefix-is-banned").replace("%TEAMPREFIX%", prefix)));
            return;
        }
        if (this.plugin.getTeamStorageUtil().getTeams().stream().map(Team::getPrefix).toList().contains(prefix)) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-prefix-already-taken").replace("%TEAMPREFIX%", prefix)));
            return;
        }
        if (!this.plugin.getSettings().isTeamTagAllowColorCodes() && (prefix.contains("&") || prefix.contains("#"))) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-tag-cannot-contain-colours")));
            return;
        }
        if (this.plugin.getSettings().isTeamTagRequirePermColorCodes() && !player.hasPermission("ultimateteams.team.tag.usecolors") && (prefix.contains("&") || prefix.contains("#"))) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("use-colours-missing-permission")));
            return;
        }
        int prefixLength = Utils.removeColors(prefix).length();
        if (prefixLength >= this.MIN_CHAR_LIMIT && prefixLength <= this.MAX_CHAR_LIMIT) {
            this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
                if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.PREFIX))) {
                    sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                    return;
                }
                team.setPrefix(prefix);
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-prefix-change-successful")).replace("%TEAMPREFIX%", Utils.Color(prefix)));
            }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
        } else if (prefixLength > this.MAX_CHAR_LIMIT) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-prefix-too-long").replace("%CHARMAX%", String.valueOf(this.MAX_CHAR_LIMIT))));
        } else {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-prefix-too-short").replace("%CHARMIN%", String.valueOf(this.MIN_CHAR_LIMIT))));
        }
    }
}

