/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.echest;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.commands.subCommands.echest.TeamEnderChestSubCommand;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamEnderChest;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Comparator;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class TeamAdminEnderChestSubCommand {
    private final UltimateTeams plugin;
    private final FileConfiguration messagesConfig;
    private final TeamEnderChestSubCommand teamEnderChestSubCommand;

    public TeamAdminEnderChestSubCommand(@NotNull UltimateTeams plugin, @NotNull TeamEnderChestSubCommand teamEnderChestSubCommand) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
        this.teamEnderChestSubCommand = teamEnderChestSubCommand;
    }

    public void addEnderChest(@NotNull CommandSender sender, @NotNull String teamName, @NotNull String rowsOrType) {
        int rows;
        if (!this.plugin.getSettings().isTeamEnderChestEnabled()) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
        if (teamOpt.isEmpty()) {
            String message = this.messagesConfig.getString("team-not-found");
            if (message != null) {
                message = message.replace("%TEAM%", teamName);
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam not found: " + teamName));
            }
            return;
        }
        Team team = teamOpt.get();
        boolean isNewPage = false;
        if (rowsOrType.equalsIgnoreCase("chest")) {
            rows = 3;
            isNewPage = true;
        } else if (rowsOrType.equalsIgnoreCase("doublechest")) {
            rows = 6;
            isNewPage = true;
        } else {
            try {
                int rowsToAdd = Integer.parseInt(rowsOrType);
                if (rowsToAdd < 1 || rowsToAdd > 6) {
                    sender.sendMessage(Utils.Color("&cRows must be between 1 and 6!"));
                    return;
                }
                Optional<TeamEnderChest> lastChestOpt = team.getEnderChests().values().stream().max(Comparator.comparingInt(TeamEnderChest::getChestNumber));
                if (lastChestOpt.isPresent()) {
                    TeamEnderChest lastChest = lastChestOpt.get();
                    int newRows = lastChest.getRows() + rowsToAdd;
                    if (newRows > 6) {
                        sender.sendMessage(Utils.Color("&cCannot add " + rowsToAdd + " rows! Current chest has " + lastChest.getRows() + " rows. Maximum is 6 rows (54 slots)."));
                        sender.sendMessage(Utils.Color("&eYou can add up to " + (6 - lastChest.getRows()) + " more rows, or use 'chest' or 'doublechest' to create a new page."));
                        return;
                    }
                    lastChest.setRows(newRows);
                    team.setEnderChest(lastChest);
                    Player randomPlayer = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
                    this.plugin.runAsync(task1 -> this.plugin.getTeamStorageUtil().updateTeamData(randomPlayer, team));
                    String message = this.messagesConfig.getString("team-echest-rows-added");
                    if (message != null) {
                        message = message.replace("%ROWS%", String.valueOf(rowsToAdd)).replace("%TOTAL%", String.valueOf(newRows)).replace("%SLOTS%", String.valueOf(lastChest.getSize())).replace("%NUMBER%", String.valueOf(lastChest.getChestNumber())).replace("%TEAM%", team.getName());
                        sender.sendMessage(Utils.Color(message));
                    } else {
                        sender.sendMessage(Utils.Color("&aAdded " + rowsToAdd + " rows to chest #" + lastChest.getChestNumber() + " (now " + newRows + " rows / " + lastChest.getSize() + " slots) for team " + team.getName()));
                    }
                    return;
                }
                rows = rowsToAdd;
                isNewPage = true;
            }
            catch (NumberFormatException e) {
                sender.sendMessage(Utils.Color("&cInvalid input! Use: <1-6> (rows to add), 'chest' (new single chest page), or 'doublechest' (new double chest page)"));
                return;
            }
        }
        int chestNumber = 1;
        while (team.hasEnderChest(chestNumber)) {
            ++chestNumber;
        }
        TeamEnderChest chest = TeamEnderChest.builder().chestNumber(chestNumber).rows(rows).serializedContents("").build();
        team.setEnderChest(chest);
        Player randomPlayer = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
        this.plugin.runAsync(task1 -> this.plugin.getTeamStorageUtil().updateTeamData(randomPlayer, team));
        String chestType = rows == 6 ? "double chest" : "single chest";
        String message = this.messagesConfig.getString("team-echest-page-added");
        if (message != null) {
            message = message.replace("%NUMBER%", String.valueOf(chestNumber)).replace("%TYPE%", chestType).replace("%ROWS%", String.valueOf(rows)).replace("%SLOTS%", String.valueOf(chest.getSize())).replace("%TEAM%", team.getName());
            sender.sendMessage(Utils.Color(message));
        } else {
            sender.sendMessage(Utils.Color("&aAdded " + chestType + " page #" + chestNumber + " (" + rows + " rows / " + chest.getSize() + " slots) to team " + team.getName()));
        }
    }

    public void removeEnderChest(@NotNull CommandSender sender, @NotNull String teamName, int chestNumber) {
        if (!this.plugin.getSettings().isTeamEnderChestEnabled()) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
        if (teamOpt.isEmpty()) {
            String message = this.messagesConfig.getString("team-not-found");
            if (message != null) {
                message = message.replace("%TEAM%", teamName);
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam not found: " + teamName));
            }
            return;
        }
        Team team = teamOpt.get();
        if (!team.hasEnderChest(chestNumber)) {
            String message = this.messagesConfig.getString("team-echest-not-exist");
            if (message != null) {
                message = message.replace("%NUMBER%", String.valueOf(chestNumber));
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam ender chest #" + chestNumber + " does not exist!"));
            }
            return;
        }
        team.removeEnderChest(chestNumber);
        Player randomPlayer = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
        this.plugin.runAsync(task1 -> this.plugin.getTeamStorageUtil().updateTeamData(randomPlayer, team));
        String message = this.messagesConfig.getString("team-echest-removed");
        if (message != null) {
            message = message.replace("%NUMBER%", String.valueOf(chestNumber)).replace("%TEAM%", team.getName());
            sender.sendMessage(Utils.Color(message));
        } else {
            sender.sendMessage(Utils.Color("&aRemoved ender chest #" + chestNumber + " from team " + team.getName()));
        }
    }

    public void listEnderChests(@NotNull CommandSender sender, @NotNull String teamName) {
        if (!this.plugin.getSettings().isTeamEnderChestEnabled()) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
        if (teamOpt.isEmpty()) {
            String message = this.messagesConfig.getString("team-not-found");
            if (message != null) {
                message = message.replace("%TEAM%", teamName);
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam not found: " + teamName));
            }
            return;
        }
        Team team = teamOpt.get();
        if (team.getEnderChestCount() == 0) {
            sender.sendMessage(Utils.Color("&eTeam " + team.getName() + " has no ender chests."));
            return;
        }
        sender.sendMessage(Utils.Color("&6=== Ender Chests for Team: " + team.getName() + " ==="));
        team.getEnderChests().values().forEach(chest -> {
            String chestType = chest.getRows() == 6 ? "Double Chest" : chest.getRows() + " rows";
            sender.sendMessage(Utils.Color("&e  #" + chest.getChestNumber() + " - " + chestType + " (" + chest.getSize() + " slots)"));
        });
    }

    public void seeEnderChest(@NotNull CommandSender sender, @NotNull String teamName, int chestNumber) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().isTeamEnderChestEnabled()) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
        if (teamOpt.isEmpty()) {
            String message = this.messagesConfig.getString("team-not-found");
            if (message != null) {
                message = message.replace("%TEAM%", teamName);
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam not found: " + teamName));
            }
            return;
        }
        Team team = teamOpt.get();
        if (!team.hasEnderChest(chestNumber)) {
            String message = this.messagesConfig.getString("team-echest-not-exist");
            if (message != null) {
                message = message.replace("%NUMBER%", String.valueOf(chestNumber));
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam ender chest #" + chestNumber + " does not exist!"));
            }
            return;
        }
        TeamEnderChest chest = team.getEnderChest(chestNumber).get();
        Inventory sharedInventory = this.teamEnderChestSubCommand.getOrCreateSharedInventory(team, chest, chestNumber);
        this.teamEnderChestSubCommand.trackAdminViewer(player.getUniqueId(), team.getId(), chestNumber);
        player.openInventory(sharedInventory);
        sender.sendMessage(Utils.Color("&c[ADMIN] &aOpened team ender chest #" + chestNumber + " for team &6" + team.getName() + "&a (Real-time View)"));
        sender.sendMessage(Utils.Color("&eChanges are synchronized in real-time with all viewers."));
        if (this.plugin.getSettings().debugModeEnabled()) {
            this.plugin.log(Level.INFO, "Admin " + player.getName() + " opened shared chest #" + chestNumber + " for team " + team.getName(), new Throwable[0]);
        }
    }

    public void backupAllChests(@NotNull CommandSender sender, @NotNull String teamName) {
        if (!this.plugin.getSettings().isTeamEnderChestEnabled()) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
        if (teamOpt.isEmpty()) {
            String message = this.messagesConfig.getString("team-not-found");
            if (message != null) {
                message = message.replace("%TEAM%", teamName);
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam not found: " + teamName));
            }
            return;
        }
        Team team = teamOpt.get();
        if (team.getEnderChestCount() == 0) {
            sender.sendMessage(Utils.Color("&eTeam " + team.getName() + " has no ender chests to backup."));
            return;
        }
        int backedUp = this.plugin.getBackupManager().backupTeamChests(team.getId());
        this.plugin.getBackupManager().saveBackups();
        sender.sendMessage(Utils.Color("&a\u2713 Successfully backed up all " + backedUp + " ender chest(s) for team " + team.getName() + "!"));
    }

    public void removeRows(@NotNull CommandSender sender, @NotNull String teamName, int chestNumber, int rowsToRemove) {
        if (!this.plugin.getSettings().isTeamEnderChestEnabled()) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeamByName(teamName);
        if (teamOpt.isEmpty()) {
            String message = this.messagesConfig.getString("team-not-found");
            if (message != null) {
                message = message.replace("%TEAM%", teamName);
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam not found: " + teamName));
            }
            return;
        }
        Team team = teamOpt.get();
        if (!team.hasEnderChest(chestNumber)) {
            String message = this.messagesConfig.getString("team-echest-not-exist");
            if (message != null) {
                message = message.replace("%NUMBER%", String.valueOf(chestNumber)).replace("%CHEST%", String.valueOf(chestNumber));
                sender.sendMessage(Utils.Color(message));
            } else {
                sender.sendMessage(Utils.Color("&cTeam ender chest #" + chestNumber + " does not exist!"));
            }
            return;
        }
        TeamEnderChest chest = team.getEnderChest(chestNumber).get();
        if (rowsToRemove < 1 || rowsToRemove > 5) {
            sender.sendMessage(Utils.Color("&cRows to remove must be between 1 and 5!"));
            return;
        }
        int newRows = chest.getRows() - rowsToRemove;
        if (newRows < 1) {
            sender.sendMessage(Utils.Color("&cCannot remove " + rowsToRemove + " rows! Chest #" + chestNumber + " only has " + chest.getRows() + " rows."));
            sender.sendMessage(Utils.Color("&eMinimum is 1 row. Use &6/ta removechest " + teamName + " " + chestNumber + " &eto delete the entire chest."));
            return;
        }
        chest.setRows(newRows);
        team.setEnderChest(chest);
        Player randomPlayer = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
        this.plugin.runAsync(task1 -> this.plugin.getTeamStorageUtil().updateTeamData(randomPlayer, team));
        sender.sendMessage(Utils.Color("&a\u2713 Removed " + rowsToRemove + " row(s) from chest #" + chestNumber + " for team " + team.getName()));
        sender.sendMessage(Utils.Color("&7New size: " + newRows + " rows (" + chest.getSize() + " slots)"));
        sender.sendMessage(Utils.Color("&c\u26a0 Warning: Items in removed slots will be lost!"));
    }
}

