/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.echest;

import com.google.common.collect.Maps;
import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamEnderChest;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TeamEnderChestSubCommand
implements Listener {
    private final UltimateTeams plugin;
    private final FileConfiguration messagesConfig;
    private static final Map<UUID, TeamChestView> activeViews = Maps.newConcurrentMap();
    private static final Map<String, Inventory> sharedInventories = Maps.newConcurrentMap();
    private static final Map<String, Set<UUID>> inventoryViewers = Maps.newConcurrentMap();
    private static final Map<String, Integer> pendingSaveTasks = Maps.newConcurrentMap();
    private static final long SAVE_DELAY_TICKS = 20L;

    public TeamEnderChestSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private String getInventoryKey(int teamId, int chestNumber) {
        return teamId + "-" + chestNumber;
    }

    public Inventory getOrCreateSharedInventory(@NotNull Team team, @NotNull TeamEnderChest chest, int chestNumber) {
        String key = this.getInventoryKey(team.getId(), chestNumber);
        Inventory inventory = sharedInventories.get(key);
        if (inventory == null) {
            String title = "Team Chest #" + chestNumber;
            inventory = Bukkit.createInventory((InventoryHolder)new TeamChestHolder(team.getId(), chestNumber), (int)chest.getSize(), (String)title);
            ItemStack[] contents = chest.getContents();
            for (int i = 0; i < contents.length && i < inventory.getSize(); ++i) {
                inventory.setItem(i, contents[i]);
            }
            sharedInventories.put(key, inventory);
            inventoryViewers.put(key, new HashSet());
            if (this.plugin.getSettings().debugModeEnabled()) {
                this.plugin.log(Level.INFO, "Created shared inventory for team " + team.getName() + " chest #" + chestNumber, new Throwable[0]);
            }
        }
        return inventory;
    }

    public void trackAdminViewer(@NotNull UUID adminUUID, int teamId, int chestNumber) {
        String key = this.getInventoryKey(teamId, chestNumber);
        activeViews.put(adminUUID, new TeamChestView(teamId, chestNumber));
        inventoryViewers.computeIfAbsent(key, k -> new HashSet()).add(adminUUID);
        if (this.plugin.getSettings().debugModeEnabled()) {
            this.plugin.log(Level.INFO, "Admin viewer added to chest " + key + " (total viewers: " + inventoryViewers.get(key).size() + ")", new Throwable[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInventoryAsync(@NotNull Team team, int chestNumber, @NotNull Inventory inventory) {
        String key = this.getInventoryKey(team.getId(), chestNumber);
        Map<String, Integer> map = pendingSaveTasks;
        synchronized (map) {
            Integer existingTaskId = pendingSaveTasks.get(key);
            if (existingTaskId != null) {
                Bukkit.getScheduler().cancelTask(existingTaskId.intValue());
                pendingSaveTasks.remove(key);
            }
            int taskId = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Map<String, Integer> map = pendingSaveTasks;
                synchronized (map) {
                    pendingSaveTasks.remove(key);
                }
                this.plugin.runAsync(task -> {
                    Optional<TeamEnderChest> chestOpt = team.getEnderChest(chestNumber);
                    if (chestOpt.isPresent()) {
                        TeamEnderChest chest = chestOpt.get();
                        ItemStack[] contents = inventory.getContents();
                        chest.setContents(contents);
                        Player randomPlayer = Bukkit.getOnlinePlayers().stream().findAny().orElse(null);
                        this.plugin.runAsync(task1 -> this.plugin.getTeamStorageUtil().updateTeamData(randomPlayer, team));
                        if (this.plugin.getSettings().debugModeEnabled()) {
                            this.plugin.log(Level.INFO, "Auto-saved team ender chest #" + chestNumber + " for team " + team.getName(), new Throwable[0]);
                        }
                    }
                });
            }, 20L).getTaskId();
            pendingSaveTasks.put(key, taskId);
        }
    }

    public void openEnderChest(@NotNull CommandSender sender, int chestNumber) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().isTeamEnderChestEnabled()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("function-disabled")));
            return;
        }
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId());
        if (teamOpt.isEmpty()) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team")));
            return;
        }
        Team team = teamOpt.get();
        if (!team.hasEnderChest(chestNumber)) {
            String message = this.messagesConfig.getString("team-echest-not-exist");
            if (message != null) {
                message = message.replace("%NUMBER%", String.valueOf(chestNumber));
                player.sendMessage(Utils.Color(message));
            } else {
                player.sendMessage(Utils.Color("&cTeam ender chest #" + chestNumber + " does not exist!"));
            }
            return;
        }
        TeamEnderChest chest = team.getEnderChest(chestNumber).get();
        Inventory inventory = this.getOrCreateSharedInventory(team, chest, chestNumber);
        String key = this.getInventoryKey(team.getId(), chestNumber);
        activeViews.put(player.getUniqueId(), new TeamChestView(team.getId(), chestNumber));
        inventoryViewers.get(key).add(player.getUniqueId());
        player.openInventory(inventory);
        String message = this.messagesConfig.getString("team-echest-opened");
        if (message != null) {
            message = message.replace("%NUMBER%", String.valueOf(chestNumber));
            player.sendMessage(Utils.Color(message));
        }
        if (this.plugin.getSettings().debugModeEnabled()) {
            this.plugin.log(Level.INFO, "Player " + player.getName() + " opened shared chest #" + chestNumber + " for team " + team.getName() + " (viewers: " + inventoryViewers.get(key).size() + ")", new Throwable[0]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof TeamChestHolder)) {
            return;
        }
        TeamChestHolder holder = (TeamChestHolder)inventoryHolder;
        if (event.isCancelled()) {
            return;
        }
        String key = this.getInventoryKey(holder.teamId, holder.chestNumber);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeam(holder.teamId);
            if (teamOpt.isPresent()) {
                this.saveInventoryAsync(teamOpt.get(), holder.chestNumber, event.getInventory());
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof TeamChestHolder)) {
            return;
        }
        TeamChestHolder holder = (TeamChestHolder)inventoryHolder;
        if (event.isCancelled()) {
            return;
        }
        String key = this.getInventoryKey(holder.teamId, holder.chestNumber);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeam(holder.teamId);
            if (teamOpt.isPresent()) {
                this.saveInventoryAsync(teamOpt.get(), holder.chestNumber, event.getInventory());
            }
        }, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerUUID = player.getUniqueId();
        TeamChestView view = activeViews.get(playerUUID);
        if (view == null) {
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof TeamChestHolder)) {
            activeViews.remove(playerUUID);
            return;
        }
        TeamChestHolder holder = (TeamChestHolder)inventoryHolder;
        activeViews.remove(playerUUID);
        String key = this.getInventoryKey(view.teamId, view.chestNumber);
        Set<UUID> viewers = inventoryViewers.get(key);
        if (viewers != null) {
            viewers.remove(playerUUID);
            if (viewers.isEmpty()) {
                Team team;
                Optional<TeamEnderChest> chestOpt;
                Map<String, Integer> map = pendingSaveTasks;
                synchronized (map) {
                    Integer pendingTaskId = pendingSaveTasks.remove(key);
                    if (pendingTaskId != null) {
                        Bukkit.getScheduler().cancelTask(pendingTaskId.intValue());
                    }
                }
                Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeam(view.teamId);
                if (teamOpt.isPresent() && (chestOpt = (team = teamOpt.get()).getEnderChest(view.chestNumber)).isPresent()) {
                    TeamEnderChest chest = chestOpt.get();
                    ItemStack[] contents = event.getInventory().getContents();
                    chest.setContents(contents);
                    this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, team));
                    if (this.plugin.getSettings().debugModeEnabled()) {
                        this.plugin.log(Level.INFO, "Saved and unloaded team ender chest #" + view.chestNumber + " for team " + team.getName(), new Throwable[0]);
                    }
                }
                sharedInventories.remove(key);
                inventoryViewers.remove(key);
                if (this.plugin.getSettings().debugModeEnabled()) {
                    this.plugin.log(Level.INFO, "Removed shared inventory " + key + " (no more viewers)", new Throwable[0]);
                }
            } else if (this.plugin.getSettings().debugModeEnabled()) {
                this.plugin.log(Level.INFO, "Player " + player.getName() + " closed chest, " + viewers.size() + " viewer(s) remaining", new Throwable[0]);
            }
        }
    }

    private record TeamChestHolder(int teamId, int chestNumber) implements InventoryHolder
    {
        @NotNull
        public Inventory getInventory() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private record TeamChestView(int teamId, int chestNumber) {
    }
}

