/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamInvite;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TeamInviteSubCommand {
    private final FileConfiguration messagesConfig;
    private static final String INVITED_PLAYER = "%INVITED%";
    public static final String PLAYER_PLACEHOLDER = "%PLAYER%";
    public static final String TEAM_PLACEHOLDER = "%TEAM%";
    private final UltimateTeams plugin;

    public TeamInviteSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.messagesConfig = plugin.msgFileManager.getMessagesConfig();
    }

    public void teamInviteSendSubCommand(CommandSender sender, String inviteeName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)inviteeName);
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.INVITE))) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("no-permission")));
                return;
            }
            if (offlinePlayer.getUniqueId().toString().equals(player.getUniqueId().toString())) {
                sender.sendMessage(Utils.Color(this.messagesConfig.getString("team-invite-self-error")));
                return;
            }
            if (this.plugin.getTeamStorageUtil().findTeamByMember(offlinePlayer.getUniqueId()).isPresent()) {
                String playerAlreadyInTeam = Utils.Color(this.messagesConfig.getString("team-invite-invited-already-in-team")).replace(INVITED_PLAYER, inviteeName);
                sender.sendMessage(playerAlreadyInTeam);
                return;
            }
            if (this.plugin.getTeamInviteUtil().hasInvitee(offlinePlayer.getUniqueId())) {
                player.sendMessage(Utils.Color(this.messagesConfig.getString("team-invite-failed").replaceAll(INVITED_PLAYER, inviteeName)));
                return;
            }
            this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAccept(teamPlayer -> {
                int maxMembers = teamPlayer.getMaxMembers(player, this.plugin.getSettings().getTeamMaxSize(), this.plugin.getSettings().getStackedTeamSize());
                if (team.getMembers().size() >= maxMembers) {
                    player.sendMessage(Utils.Color(this.messagesConfig.getString("team-invite-max-size-reached")).replace("%LIMIT%", String.valueOf(maxMembers)));
                    return;
                }
                boolean invited = this.plugin.getTeamInviteUtil().createInvite(team.getId(), player, offlinePlayer.getUniqueId());
                if (invited) {
                    String confirmationString = Utils.Color(this.messagesConfig.getString("team-invite-successful")).replace(INVITED_PLAYER, inviteeName);
                    player.sendMessage(confirmationString);
                    String invitationString = Utils.Color(this.messagesConfig.getString("team-invited-player-invite-pending")).replace("%TEAMOWNER%", player.getName());
                    Optional.ofNullable(offlinePlayer.getPlayer()).ifPresent(invitedPlayer -> {
                        invitedPlayer.sendMessage(invitationString);
                        this.sendClickableInvite((Player)invitedPlayer, team.getName(), player.getName());
                    });
                } else {
                    player.sendMessage(Utils.Color(this.messagesConfig.getString("team-invite-failed")).replace(INVITED_PLAYER, inviteeName));
                }
            });
        }, () -> sender.sendMessage(Utils.Color(this.messagesConfig.getString("not-in-team"))));
    }

    public void teamInviteDenySubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamInviteUtil().hasInvitee(player.getUniqueId())) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-invite-deny-failed-no-invite")));
            return;
        }
        if (this.plugin.getTeamInviteUtil().declineInvite(player)) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-invite-denied")));
        } else {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-invite-deny-fail")));
        }
    }

    public void teamInviteAcceptSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.Color(this.messagesConfig.getString("player-only-command")));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamInviteUtil().hasInvitee(player.getUniqueId())) {
            player.sendMessage(Utils.Color(this.messagesConfig.getString("team-join-failed-no-invite")));
            return;
        }
        this.plugin.getTeamInviteUtil().getInvite(player.getUniqueId()).ifPresentOrElse(invite -> this.plugin.getTeamStorageUtil().findTeamByMember(invite.getInviter()).ifPresentOrElse(team -> {
            this.plugin.getTeamStorageUtil().addTeamMember((Team)team, player);
            this.plugin.getTeamInviteUtil().acceptInvite((TeamInvite)invite, player);
            String joinMessage = Utils.Color(this.messagesConfig.getString("team-join-successful")).replace(TEAM_PLACEHOLDER, team.getName());
            player.sendMessage(joinMessage);
            if (!this.plugin.getSettings().teamJoinAnnounce()) {
                return;
            }
            team.sendTeamMessage(Utils.Color(this.messagesConfig.getString("team-join-broadcast-chat").replace(PLAYER_PLACEHOLDER, player.getName()).replace(TEAM_PLACEHOLDER, Utils.Color(team.getName()))));
        }, () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("team-join-failed-no-valid-team")))), () -> player.sendMessage(Utils.Color(this.messagesConfig.getString("team-join-failed-no-invite"))));
    }

    private void sendClickableInvite(Player invitedPlayer, String teamName, String inviterName) {
        TextComponent message = new TextComponent(Utils.Color("&7&m                                                    "));
        invitedPlayer.spigot().sendMessage((BaseComponent)message);
        TextComponent header = new TextComponent(Utils.Color("&6&lTeam Invitation"));
        invitedPlayer.spigot().sendMessage((BaseComponent)header);
        TextComponent info = new TextComponent(Utils.Color("&eYou've been invited to join &6" + teamName + " &eby &6" + inviterName));
        invitedPlayer.spigot().sendMessage((BaseComponent)info);
        TextComponent message2 = new TextComponent("");
        invitedPlayer.spigot().sendMessage((BaseComponent)message2);
        TextComponent buttons = new TextComponent("");
        TextComponent acceptButton = new TextComponent(Utils.Color("&a&l[\u2714 ACCEPT]"));
        acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team invite accept"));
        acceptButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(Utils.Color("&aClick to accept the invitation")).create()));
        TextComponent space = new TextComponent("  ");
        TextComponent declineButton = new TextComponent(Utils.Color("&c&l[\u2716 DECLINE]"));
        declineButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team invite deny"));
        declineButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(Utils.Color("&cClick to decline the invitation")).create()));
        buttons.addExtra((BaseComponent)acceptButton);
        buttons.addExtra((BaseComponent)space);
        buttons.addExtra((BaseComponent)declineButton);
        invitedPlayer.spigot().sendMessage((BaseComponent)buttons);
        TextComponent footer = new TextComponent(Utils.Color("&7&m                                                    "));
        invitedPlayer.spigot().sendMessage((BaseComponent)footer);
    }
}

