/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.config;

import dev.xf3d3.ultimateteams.database.Database;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.william278.annotaml.YamlComment;
import dev.xf3d3.ultimateteams.libraries.william278.annotaml.YamlFile;
import dev.xf3d3.ultimateteams.libraries.william278.annotaml.YamlKey;
import dev.xf3d3.ultimateteams.network.Broker;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@YamlFile(header="\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503     UltimateTeams Config     \u2503\n\u2503      Developed by xF3d3      \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2503\n\u2517\u2578 Information: https://modrinth.com/plugin/ultimate-teams")
public class Settings {
    @YamlComment(value="Do you want to use the GUI system? [Default value: true]")
    @YamlKey(value="use-global-GUI-system")
    private boolean useGlobalGui = true;
    @YamlComment(value="Type of database to use (SQLITE, H2, MYSQL, MARIADB, or POSTGRESQL). MARIADB is preferred over MYSQL. H2 is preferred over SQLITE")
    @YamlKey(value="database.type")
    private Database.Type databaseType = Database.Type.SQLITE;
    @YamlComment(value="Specify credentials here if you are using MYSQL as your database type")
    @YamlKey(value="database.mysql.credentials.host")
    private String mySqlHost = "localhost";
    @YamlKey(value="database.mysql.credentials.port")
    private int mySqlPort = 3306;
    @YamlKey(value="database.mysql.credentials.database")
    private String mySqlDatabase = "ultimate_teams";
    @YamlKey(value="database.mysql.credentials.username")
    private String mySqlUsername = "root";
    @YamlKey(value="database.mysql.credentials.password")
    private String mySqlPassword = "pa55w0rd";
    @YamlKey(value="database.mysql.credentials.parameters")
    private String mySqlConnectionParameters = "?autoReconnect=true&useSSL=false&useUnicode=true&characterEncoding=UTF-8";
    @YamlComment(value="MYSQL / MARIADB / POSTGRESQL database connection pool properties. Don't modify this unless you know what you're doing!")
    @YamlKey(value="database.mysql.connection_pool.size")
    private int mySqlConnectionPoolSize = 12;
    @YamlKey(value="database.mysql.connection_pool.idle")
    private int mySqlConnectionPoolIdle = 12;
    @YamlKey(value="database.mysql.connection_pool.lifetime")
    private long mySqlConnectionPoolLifetime = 1800000L;
    @YamlKey(value="database.mysql.connection_pool.keepalive")
    private long mySqlConnectionPoolKeepAlive = 30000L;
    @YamlKey(value="database.mysql.connection_pool.timeout")
    private long mySqlConnectionPoolTimeout = 20000L;
    @YamlComment(value="Names of tables to use on your database. Don't modify this unless you know what you're doing!")
    @YamlKey(value="database.table_names")
    private Map<String, String> tableNames = Map.of(Database.Table.TEAM_DATA.name().toLowerCase(), Database.Table.TEAM_DATA.getDefaultName(), Database.Table.USER_DATA.name().toLowerCase(), Database.Table.USER_DATA.getDefaultName());
    @YamlComment(value="Whether enable cross-server mode. You must use MYSQL/MARIADB/POSTGRESQL to use cross-server")
    @YamlKey(value="cross-server.enable")
    private boolean enableCrossServer = false;
    @YamlComment(value="The name of the server as it appears on Bungee/Velocity (case-sensitive)")
    @YamlKey(value="cross-server.server-name")
    private String serverName = "Survival";
    @YamlComment(value="The cluster ID, for if you're networking multiple separate groups of UltimateTeams-enabled servers. Do not change unless you know what you're doing")
    @YamlKey(value="cross-server.cluster-id")
    private String clusterId = "main";
    @YamlComment(value="Type of network message broker to ues for data synchronization (PLUGIN_MESSAGE or REDIS). Always use REDIS if possible.")
    @YamlKey(value="cross-server.broker")
    private Broker.Type brokerType = Broker.Type.PLUGIN_MESSAGE;
    @YamlComment(value="Settings for if you're using REDIS as your message broker")
    @YamlKey(value="cross-server.redis.host")
    private String redisHost = "localhost";
    @YamlKey(value="cross-server.redis.port")
    private int redisPort = 6379;
    @YamlKey(value="cross-server.redis.password")
    private String redisPassword = "";
    @YamlKey(value="cross-server.redis.use-ssl")
    private boolean redisUseSSL = false;
    @YamlComment(value="Hook into luckperms to create contexts (e.g. is-in-team) [Default value: false]. Needs LuckPerms")
    @YamlKey(value="luckperms-hook")
    private boolean luckpermshook = false;
    @YamlComment(value="use HuskHomes to teleport players instead of built-in teleport handler [Default value: true]")
    @YamlKey(value="use-huskhomes")
    private boolean useHuskhomes = false;
    @YamlComment(value="Hook into floodgate to handle bedrock players properly [Default value: false]. Needs FloodGate")
    @YamlKey(value="floodgate-hook")
    private boolean floodgateHook = false;
    @YamlComment(value="When the placeholder would be blank, the text below will be shown instead (you can use color codes)")
    @YamlKey(value="placeholder.not-in-a-team")
    private String notInTeamPlaceholder = "Not in a team";
    @YamlComment(value="Whether to allow color codes (& and #) in the teams name")
    @YamlKey(value="team.name.allow-color-codes")
    private boolean teamCreateAllowColorCodes = false;
    @YamlComment(value="If enabled, players need the ultimateteams.team.create.usecolors permission to use color codes")
    @YamlKey(value="team.name.require-perm-for-color-codes")
    private boolean teamCreateRequirePermColorCodes = false;
    @YamlKey(value="team.name.min-length")
    private int teamNameMinLength = 4;
    @YamlKey(value="team.name.max-length")
    private int teamNameMaxLength = 10;
    @YamlComment(value="Do you want a message to be sent to team players when a player joins a team? [Default value: true]")
    @YamlKey(value="team.join.announce")
    private boolean teamJoinAnnounce = true;
    @YamlComment(value="Do you want a message to be sent to team players when a player leaves a team? [Default value: true]")
    @YamlKey(value="team.leave.announce")
    private boolean teamLeftAnnounce = true;
    @YamlComment(value="Set the default maximum amount of members that can join a players' team. [Default value: 8]")
    @YamlKey(value="team.size.default-max-team-size")
    private int maxTeamSize = 8;
    @YamlComment(value="If true, the default members limit will be stacked with permission limit.\n If a player has ultimateteams.max_members.2 and the default limit is 8, he will be able to have 10 members. otherwise only 2.")
    @YamlKey(value="team.size.stack-members")
    private boolean stackTeamSizeWithPermission = false;
    @YamlComment(value="Enable the '/team [sethome|home]' system. [Default value: true]")
    @YamlKey(value="team.home.enabled")
    private boolean teamHomeEnabled = true;
    @YamlComment(value="Define the delay (cooldown) in seconds before the tp starts.\nThis value has no effect if using HuskHomes as teleport handler")
    @YamlKey(value="team.home.tp-delay")
    private int teamHomeTpDelay = 3;
    @YamlComment(value="Enable the cool down on the '/team warp <name>' command to prevent tp spamming (RECOMMENDED). [Default value: true]")
    @YamlKey(value="team.home.cool-down.enabled")
    private boolean teamHomeCooldownEnabled = true;
    @YamlComment(value="Cool-down time in seconds. [Default value: 120 = 2 minutes]")
    @YamlKey(value="team.home.cool-down.time")
    private int teamHomeCooldownValue = 120;
    @YamlComment(value="Globally enable the team friendly fire system (the friendly fire is disabled by default in new teams). [Default value: true]")
    @YamlKey(value="team.pvp.enabled")
    private boolean pvpCommandEnabled = true;
    @YamlComment(value="Enable the ability for a player to bypass the pvp protection using 'ultimateteams.bypass.pvp'. [Default value: true]")
    @YamlKey(value="team.pvp.bypass-permission")
    private boolean pvpCommandBypassPerm = true;
    @YamlComment(value="If this is enabled, new teams will have PvP (friendly fire) enabled by default. [Default value: false]")
    @YamlKey(value="team.pvp.default-allow-pvp")
    private boolean pvpDefaultAllow = false;
    @YamlComment(value="Enable the '/team [setwarp|warp]' system. [Default value: true]")
    @YamlKey(value="team.warp.enable")
    private boolean teamWarpEnable = true;
    @YamlComment(value="Define the delay (cooldown) in seconds before the tp starts.\nThis value has no effect if using HuskHomes as teleport handler")
    @YamlKey(value="team.warp.tp-delay")
    private int teamWarpTpDelay = 3;
    @YamlComment(value="Decide how many warps a team owner can set.\n Can be overwritten by ultimateteams.max_warps.<number>")
    @YamlKey(value="team.warp.limit")
    private int teamWarpLimit = 2;
    @YamlComment(value="If true, the default warp limit will be stacked with permission limit.\n If a player has ultimateteams.max_warps.3 and the default limit is 2, he will be able to set 5 warps.")
    @YamlKey(value="team.warp.stack-warps")
    private boolean stackWarpLimitWithPermission = false;
    @YamlComment(value="Enable the cool down on the '/team warp <name>' command to prevent tp spamming (RECOMMENDED). [Default value: true]")
    @YamlKey(value="team.warp.cool-down.enabled")
    private boolean teamWarpCooldownEnabled = true;
    @YamlComment(value="Cool-down time in seconds. [Default value: 120 = 2 minutes]")
    @YamlKey(value="team.warp.cool-down.time")
    private int teamWarpCooldownValue = 120;
    @YamlComment(value="Enable the team chat system. [Default value: true]")
    @YamlKey(value="team.chat.enabled")
    private boolean teamChatEnabled = true;
    @YamlComment(value="Below is the prefix for the team chat messages. (Placeholders: %TEAM% %PLAYER%)")
    @YamlKey(value="team.chat.prefix")
    private String teamChatPrefix = "&6[&3TC&6]&r";
    @YamlComment(value="Set the maximum amount of allied teams that can a team can have. [Default value: 4]")
    @YamlKey(value="team.allies.max-allies")
    private int maxAllies = 4;
    @YamlComment(value="Enable the team ally chat system. [Default value: true]")
    @YamlKey(value="team.allies.chat.enabled")
    private boolean teamAllyChatEnabled = true;
    @YamlComment(value="Below is the prefix for the team ally chat messages. (Placeholders: %TEAM% %PLAYER%)")
    @YamlKey(value="team.allies.chat.prefix")
    private String teamAllyChatPrefix = "&6[&eAC&6]&r";
    @YamlComment(value="Set the maximum amount of enemies teams that can a team can have. [Default value: 2")
    @YamlKey(value="team.enemies.max-enemies")
    private int maxEnemies = 2;
    @YamlComment(value="Whether to allow color codes (& and #) in the teams tag")
    @YamlKey(value="team.tag.allow-color-codes")
    private boolean teamTagAllowColorCodes = true;
    @YamlComment(value="If enabled, players need the ultimateteams.team.tag.usecolors permission to use color codes")
    @YamlKey(value="team.tag.require-perm-for-color-codes")
    private boolean teamTagRequirePermColorCodes = false;
    @YamlComment(value="Set the minimum length of the team prefix. [Default value: 3]")
    @YamlKey(value="team.tag.min-length")
    private int minCharacterLimit = 3;
    @YamlComment(value="Set the minimum length of the team prefix. [Default value: 8]")
    @YamlKey(value="team.tag.max-length")
    private int maxCharacterLimit = 8;
    @YamlComment(value="Set below names that are not allowed to be used in prefixes or names. [They are NOT casesensitive]")
    @YamlKey(value="team.tag.disallowed-tags")
    private List<String> disallowedTags = List.of("Gamers", "Rise", "Up");
    @YamlComment(value="Add a space after the team prefix in chat. [Default value: false].")
    @YamlKey(value="team.tag.prefix-add-space-after")
    private boolean addPrefixChatAfter = false;
    @YamlComment(value="Add `[]` characters before and after the team prefix in the chat. [Default value: false]")
    @YamlKey(value="team.tag.prefix-add-brackets")
    private boolean addPrefixBrackets = false;
    @YamlComment(value="Below is how the above brackets should appear.")
    @YamlKey(value="team.tag.brackets-opening")
    private String bracketsOpening = "&f[";
    @YamlKey(value="team.tag.brackets-closing")
    private String bracketsClosing = "&f]";
    @YamlComment(value="Enable the team enderchest system. [Default value: true]\nThis is not compatible with cross-server (yet).")
    @YamlKey(value="team.echest.enabled")
    private boolean teamEnderChestEnabled = true;
    @YamlComment(value="How many rows will the default enderchest have? [Default value: 3]\nValue can go from 1 to 6, being 3 a normal chest and 6 a double chest")
    @YamlKey(value="team.echest.rows")
    private int teamEnderChestRows = 3;
    @YamlComment(value="ONLY FOR SERVERS WHO JUST UPDATED TO A VERSION THAT SUPPORTS THIS FEATURE!\nShould the plugin add an enderchest to each team on startup? [Default value: false]\nSince teams created before this version didn't have enderchests, add one.\nAFTER A FULL STARTUP DISABLE THIS AND RESTART THE SERVER!")
    @YamlKey(value="team.echest.migrate")
    private boolean teamEnderChestMigrate = false;
    @YamlComment(value="Do you want players with the perm 'ultimateteams.chat.spy' be able to spy on all team chat messages? [Default value: true]")
    @YamlKey(value="chat.chat-spy.enabled")
    private boolean teamChatSpyEnabled = true;
    @YamlComment(value="Below is the prefix for th chat spy messages. [Default value: &6[&cSPY&6]&r]")
    @YamlKey(value="chat.chat-spy.prefix")
    private String teamChatSpyPrefix = "&6[&cSPY&6]&r";
    @YamlComment(value="Whether to enable economy (Vault is required)")
    @YamlKey(value="economy.enable")
    private boolean economyEnabled = false;
    @YamlComment(value="The cost to create a team")
    @YamlKey(value="economy.team-create")
    private double teamCreateCost = 100.0;
    @YamlComment(value="Do you want to enable in game plugin update notifications? (Permission:'ultimateteams.update'). [Default value: true]")
    @YamlKey(value="plugin-update-notifications.enabled")
    private boolean checkForUpdates = true;
    @YamlComment(value="Do you want to enable the plugins ability to auto-wipe the invites list? [Default value: true]")
    @YamlKey(value="general.run-auto-invite-wipe-task")
    private boolean autoInviteWipeTask = true;
    @YamlComment(value="Do you want the plugin to send a message in console when it does the auto-wipe of the invites list? [Default value: true]")
    @YamlKey(value="general.run-auto-invite-wipe-task-log")
    private boolean autoInviteWipeTaskLog = true;
    @YamlComment(value="Do you want to see a lot of debug messages in console when most actions are performed? [Default value: false]")
    @YamlKey(value="general.developer-debug-mode")
    private boolean debugMode = false;

    private Settings() {
    }

    public boolean doCheckForUpdates() {
        return this.checkForUpdates;
    }

    public boolean useGlobalGui() {
        return this.useGlobalGui;
    }

    public Database.Type getDatabaseType() {
        return this.databaseType;
    }

    public String getMySqlHost() {
        return this.mySqlHost;
    }

    public int getMySqlPort() {
        return this.mySqlPort;
    }

    public String getMySqlDatabase() {
        return this.mySqlDatabase;
    }

    public String getMySqlUsername() {
        return this.mySqlUsername;
    }

    public String getMySqlPassword() {
        return this.mySqlPassword;
    }

    public String getMySqlConnectionParameters() {
        return this.mySqlConnectionParameters;
    }

    public int getMySqlConnectionPoolSize() {
        return this.mySqlConnectionPoolSize;
    }

    public int getMySqlConnectionPoolIdle() {
        return this.mySqlConnectionPoolIdle;
    }

    public long getMySqlConnectionPoolLifetime() {
        return this.mySqlConnectionPoolLifetime;
    }

    public long getMySqlConnectionPoolKeepAlive() {
        return this.mySqlConnectionPoolKeepAlive;
    }

    public long getMySqlConnectionPoolTimeout() {
        return this.mySqlConnectionPoolTimeout;
    }

    public Map<String, String> getTableNames() {
        return this.tableNames;
    }

    @NotNull
    public String getTableName(@NotNull Database.Table table) {
        return Optional.ofNullable(this.getTableNames().get(table.name().toLowerCase())).orElse(table.getDefaultName());
    }

    public String getNotInTeamPlaceholder() {
        return this.notInTeamPlaceholder;
    }

    public boolean LuckPermsHook() {
        return this.luckpermshook;
    }

    public boolean HuskHomesHook() {
        return this.useHuskhomes;
    }

    public boolean FloodGateHook() {
        return this.floodgateHook;
    }

    public int getTeamTagsMinCharLimit() {
        return this.minCharacterLimit;
    }

    public int getTeamTagsMaxCharLimit() {
        return this.maxCharacterLimit;
    }

    public boolean isTagsBanned(@NotNull String tag) {
        return this.disallowedTags.stream().anyMatch(name -> name.equalsIgnoreCase(tag));
    }

    public List<String> getTeamTagsDisallowedList() {
        return this.disallowedTags;
    }

    public boolean addSpaceAfterPrefix() {
        return this.addPrefixChatAfter;
    }

    public boolean addPrefixBrackets() {
        return this.addPrefixBrackets;
    }

    public String getPrefixBracketsOpening() {
        return this.bracketsOpening;
    }

    public String getPrefixBracketsClosing() {
        return this.bracketsClosing;
    }

    public int getTeamMaxSize() {
        return this.maxTeamSize;
    }

    public boolean getStackedTeamSize() {
        return this.stackTeamSizeWithPermission;
    }

    public boolean teamJoinAnnounce() {
        return this.teamJoinAnnounce;
    }

    public boolean teamLeftAnnounce() {
        return this.teamLeftAnnounce;
    }

    public boolean teamWarpEnabled() {
        return this.teamWarpEnable;
    }

    public int getTeamWarpTpDelay() {
        return this.teamWarpTpDelay;
    }

    public int getTeamWarpLimit() {
        return this.teamWarpLimit;
    }

    public boolean getTeamWarpStackEnabled() {
        return this.stackWarpLimitWithPermission;
    }

    public boolean teamWarpCooldownEnabled() {
        return this.teamWarpCooldownEnabled;
    }

    public int getTeamWarpCooldownValue() {
        return this.teamWarpCooldownValue;
    }

    public boolean teamChatEnabled() {
        return this.teamChatEnabled;
    }

    public String getTeamChatPrefix() {
        return this.teamChatPrefix;
    }

    public boolean teamAllyChatEnabled() {
        return this.teamAllyChatEnabled;
    }

    public String getTeamAllyChatPrefix() {
        return this.teamAllyChatPrefix;
    }

    public boolean teamChatSpyEnabled() {
        return this.teamChatSpyEnabled;
    }

    public String getTeamChatSpyPrefix() {
        return this.teamChatSpyPrefix;
    }

    public int getMaxTeamAllies() {
        return this.maxAllies;
    }

    public int getMaxTeamEnemies() {
        return this.maxEnemies;
    }

    public boolean isPvpCommandEnabled() {
        return this.pvpCommandEnabled;
    }

    public boolean enablePvPBypassPermission() {
        return this.pvpCommandBypassPerm;
    }

    public boolean teamHomeEnabled() {
        return this.teamHomeEnabled;
    }

    public int getTeamHomeTpDelay() {
        return this.teamHomeTpDelay;
    }

    public boolean teamHomeCooldownEnabled() {
        return this.teamHomeCooldownEnabled;
    }

    public int getTeamHomeCooldownValue() {
        return this.teamHomeCooldownValue;
    }

    public boolean enableAutoInviteWipe() {
        return this.autoInviteWipeTask;
    }

    public boolean enableAutoInviteWipeLog() {
        return this.autoInviteWipeTaskLog;
    }

    public boolean debugModeEnabled() {
        return this.debugMode;
    }

    @Generated
    public boolean isEnableCrossServer() {
        return this.enableCrossServer;
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public String getClusterId() {
        return this.clusterId;
    }

    @Generated
    public Broker.Type getBrokerType() {
        return this.brokerType;
    }

    @Generated
    public String getRedisHost() {
        return this.redisHost;
    }

    @Generated
    public int getRedisPort() {
        return this.redisPort;
    }

    @Generated
    public String getRedisPassword() {
        return this.redisPassword;
    }

    @Generated
    public boolean isRedisUseSSL() {
        return this.redisUseSSL;
    }

    @Generated
    public boolean isTeamCreateAllowColorCodes() {
        return this.teamCreateAllowColorCodes;
    }

    @Generated
    public boolean isTeamCreateRequirePermColorCodes() {
        return this.teamCreateRequirePermColorCodes;
    }

    @Generated
    public int getTeamNameMinLength() {
        return this.teamNameMinLength;
    }

    @Generated
    public int getTeamNameMaxLength() {
        return this.teamNameMaxLength;
    }

    @Generated
    public boolean isPvpDefaultAllow() {
        return this.pvpDefaultAllow;
    }

    @Generated
    public boolean isTeamTagAllowColorCodes() {
        return this.teamTagAllowColorCodes;
    }

    @Generated
    public boolean isTeamTagRequirePermColorCodes() {
        return this.teamTagRequirePermColorCodes;
    }

    @Generated
    public boolean isTeamEnderChestEnabled() {
        return this.teamEnderChestEnabled;
    }

    @Generated
    public int getTeamEnderChestRows() {
        return this.teamEnderChestRows;
    }

    @Generated
    public boolean isTeamEnderChestMigrate() {
        return this.teamEnderChestMigrate;
    }

    @Generated
    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }

    @Generated
    public double getTeamCreateCost() {
        return this.teamCreateCost;
    }
}

