/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.database;

import com.zaxxer.hikari.HikariDataSource;
import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.database.Database;
import dev.xf3d3.ultimateteams.libraries.gson.JsonSyntaxException;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class MySqlDatabase
extends Database {
    private static final String DATA_POOL_NAME = "UltimateTeamsHikariPool";
    private final String driverClass;
    private HikariDataSource dataSource;
    final String type;

    public MySqlDatabase(@NotNull UltimateTeams plugin) {
        super(plugin);
        this.type = plugin.getSettings().getDatabaseType().getProtocol();
        this.driverClass = plugin.getSettings().getDatabaseType() == Database.Type.MARIADB ? "org.mariadb.jdbc.Driver" : "com.mysql.cj.jdbc.Driver";
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private void setConnection() {
        this.plugin.log(Level.INFO, "Attempting to connect to database", new Throwable[0]);
        this.dataSource = new HikariDataSource();
        this.dataSource.setDriverClassName(this.driverClass);
        this.dataSource.setJdbcUrl(String.format("jdbc:%s://%s:%s/%s%s", this.type, this.plugin.getSettings().getMySqlHost(), this.plugin.getSettings().getMySqlPort(), this.plugin.getSettings().getMySqlDatabase(), this.plugin.getSettings().getMySqlConnectionParameters()));
        this.dataSource.setUsername(this.plugin.getSettings().getMySqlUsername());
        this.dataSource.setPassword(this.plugin.getSettings().getMySqlPassword());
        this.dataSource.setMaximumPoolSize(this.plugin.getSettings().getMySqlConnectionPoolSize());
        this.dataSource.setMinimumIdle(this.plugin.getSettings().getMySqlConnectionPoolIdle());
        this.dataSource.setMaxLifetime(this.plugin.getSettings().getMySqlConnectionPoolLifetime());
        this.dataSource.setKeepaliveTime(this.plugin.getSettings().getMySqlConnectionPoolKeepAlive());
        this.dataSource.setConnectionTimeout(this.plugin.getSettings().getMySqlConnectionPoolTimeout());
        this.dataSource.setPoolName(DATA_POOL_NAME);
        this.dataSource.setDataSourceProperties(new Properties(){
            {
                this.put("cachePrepStmts", "true");
                this.put("prepStmtCacheSize", "250");
                this.put("prepStmtCacheSqlLimit", "2048");
                this.put("useServerPrepStmts", "true");
                this.put("useLocalSessionState", "true");
                this.put("useLocalTransactionState", "true");
                this.put("rewriteBatchedStatements", "true");
                this.put("cacheResultSetMetadata", "true");
                this.put("cacheServerConfiguration", "true");
                this.put("elideSetAutoCommits", "true");
                this.put("maintainTimeStats", "false");
            }
        });
    }

    @Override
    public void initialize() {
        this.setConnection();
        try (Connection connection = this.getConnection();){
            this.plugin.log(Level.INFO, "MySQL Database Connected!", new Throwable[0]);
            try (Statement statement = connection.createStatement();){
                for (String tableCreationStatement : this.getSchema(String.format("database/%s_schema.sql", this.type))) {
                    statement.execute(tableCreationStatement);
                }
            }
            catch (SQLException e) {
                this.setLoaded(false);
                throw new IllegalStateException("Failed to create database tables. Please ensure you are running MySQL v8.0+ and that your connecting user account has privileges to create tables.", e);
            }
            this.setLoaded(true);
        }
        catch (IOException | SQLException e) {
            this.setLoaded(false);
            throw new IllegalStateException("Failed to establish a connection to the MySQL database. Please check the supplied database credentials in the config file", e);
        }
        this.plugin.getLogger().info("Database tables created");
    }

    @Override
    public List<Team> getAllTeams() {
        ArrayList<Team> teams = new ArrayList<Team>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT `id`, `data`\nFROM `%team_table%`\n"));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String data = new String(resultSet.getBytes("data"), StandardCharsets.UTF_8);
                Team team = this.plugin.getGson().fromJson(data, Team.class);
                if (team == null) continue;
                team.setId(resultSet.getInt(1));
                teams.add(team);
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch list of teams from table", e);
        }
        return teams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Team> getTeam(@NotNull Integer id) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT *\nFROM `%team_table%`\nWHERE `id` = ?\n"));){
            statement.setInt(1, id);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            String data = new String(resultSet.getBytes("data"), StandardCharsets.UTF_8);
            Team team = this.plugin.getGson().fromJson(data, Team.class);
            if (team == null) return Optional.empty();
            team.setId(resultSet.getInt(1));
            Optional<Team> optional = Optional.of(team);
            return optional;
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update team in table", e);
        }
        return Optional.empty();
    }

    @Override
    public void createPlayer(@NotNull TeamPlayer teamplayer) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%user_table%` (`uuid`, `username`, `isBedrock`, `bedrockUUID`, `preferences`)\nVALUES (?, ?, ?, ?, ?)\n"));){
            statement.setString(1, String.valueOf(teamplayer.getJavaUUID()));
            statement.setString(2, teamplayer.getLastPlayerName());
            statement.setBoolean(3, teamplayer.isBedrockPlayer());
            statement.setString(4, teamplayer.getBedrockUUID());
            statement.setBytes(5, this.plugin.getGson().toJson(teamplayer.getPreferences()).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create player in table", e);
        }
    }

    @Override
    public void updatePlayer(@NotNull TeamPlayer teamplayer) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("UPDATE `%user_table%`\nSET `username` = ?, `isBedrock` = ?, `bedrockUUID` = ?, `preferences` = ?\nWHERE `uuid` = ?\n"));){
            statement.setString(1, teamplayer.getLastPlayerName());
            statement.setBoolean(2, teamplayer.isBedrockPlayer());
            statement.setString(3, teamplayer.getBedrockUUID());
            statement.setBytes(4, this.plugin.getGson().toJson(teamplayer.getPreferences()).getBytes(StandardCharsets.UTF_8));
            statement.setString(5, String.valueOf(teamplayer.getJavaUUID()));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update player in table", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<TeamPlayer> getPlayer(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT *\nFROM `%user_table%`\nWHERE `uuid` = ?\n"));){
            statement.setString(1, String.valueOf(uuid));
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            TeamPlayer teamPlayer = new TeamPlayer(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username"), resultSet.getBoolean("isBedrock"), resultSet.getString("bedrockUUID"), this.plugin.getPreferencesFromJson(new String(resultSet.getBytes("preferences"), StandardCharsets.UTF_8)));
            Optional<TeamPlayer> optional = Optional.of(teamPlayer);
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to get player from table", e);
        }
        return Optional.empty();
    }

    @Override
    public void deleteAllUsers() {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("DELETE FROM `%user_table%`"));){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete all users from table", e);
        }
    }

    @Override
    public Team createTeam(@NotNull String name, @NotNull Player creator) {
        Team team = Team.create(name, creator, this.plugin.getSettings().isPvpDefaultAllow(), this.plugin.getSettings().getTeamEnderChestRows());
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%team_table%` (`name`, `data`)\nVALUES (?, ?)\n"), 1);){
            statement.setString(1, team.getName());
            statement.setBytes(2, this.plugin.getGson().toJson(team).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
            ResultSet insertedRow = statement.getGeneratedKeys();
            if (insertedRow.next()) {
                team.setId(insertedRow.getInt(1));
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create team in table", e);
        }
        return team;
    }

    @Override
    public Team createTeam(@NotNull Team team) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%team_table%` (`name`, `data`)\nVALUES (?, ?)\n"), 1);){
            statement.setString(1, team.getName());
            statement.setBytes(2, this.plugin.getGson().toJson(team).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
            ResultSet insertedRow = statement.getGeneratedKeys();
            if (insertedRow.next()) {
                team.setId(insertedRow.getInt(1));
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create migrated team in table", e);
        }
        return team;
    }

    @Override
    public void updateTeam(@NotNull Team team) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("UPDATE `%team_table%`\nSET `name` = ?, `data` = ?\nWHERE `id` = ?\n"));){
            statement.setString(1, team.getName());
            statement.setBytes(2, this.plugin.getGson().toJson(team).getBytes(StandardCharsets.UTF_8));
            statement.setInt(3, team.getId());
            statement.executeUpdate();
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update team in table", e);
        }
    }

    @Override
    public void deleteTeam(@NotNull Integer id) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("DELETE FROM `%team_table%`\nWHERE `id` = ?\n"));){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete team in table", e);
        }
    }

    @Override
    public void deleteAllTeams() {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("DELETE FROM `%team_table%`"));){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete all teams from table", e);
        }
    }

    @Override
    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }
}

