/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.listeners;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.Payload;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class PlayerChatEvent
implements Listener {
    private final UltimateTeams plugin;

    public PlayerChatEvent(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getUsersStorageUtil().getChatPlayers().containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            this.sendToAlternateChat(player, event.getMessage());
        }
    }

    private void sendToAlternateChat(Player player, String message) {
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            String chatSpyPrefix = this.plugin.getSettings().getTeamChatSpyPrefix();
            String messageString = this.plugin.getSettings().getTeamChatPrefix() + " &d" + player.getName() + ":&r " + message + " ";
            String msg = messageString.replace("%TEAM%", team.getName()).replace("%PLAYER%", player.getName());
            team.sendTeamMessage(Utils.Color(msg));
            if (this.plugin.getSettings().teamChatSpyEnabled()) {
                String spyMessage = Utils.Color(chatSpyPrefix + " " + msg);
                Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("ultimateteams.chat.spy")).forEach(p -> p.sendMessage(spyMessage));
            }
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_CHAT_MESSAGE).payload(Payload.string(msg)).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, player));
        }, () -> this.plugin.getUsersStorageUtil().getChatPlayers().remove(player.getUniqueId()));
    }
}

