/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.listeners;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.models.User;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerConnectEvent
implements Listener {
    private final UltimateTeams plugin;

    public PlayerConnectEvent(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        this.plugin.getUsersStorageUtil().getOnlineUserMap().remove(uuid);
        this.plugin.getUsersStorageUtil().getOnlineUserMap().put(player.getUniqueId(), player);
        this.plugin.runSyncDelayed(() -> this.plugin.getUsersStorageUtil().syncGlobalUserList(player, this.plugin.getUsersStorageUtil().getOnlineUserMap().values().stream().map(online -> User.of(online.getUniqueId(), online.getName())).toList()), 40L);
        if (this.plugin.getSettings().FloodGateHook() && this.plugin.getFloodgateApi() != null) {
            if (this.plugin.getFloodgateApi().isFloodgatePlayer(uuid)) {
                this.plugin.getUsersStorageUtil().getBedrockPlayer(player).thenAccept(p -> {
                    if (this.plugin.getUsersStorageUtil().hasPlayerNameChanged(player)) {
                        this.plugin.getUsersStorageUtil().updatePlayerName(player);
                    }
                    if (this.plugin.getUsersStorageUtil().hasBedrockPlayerJavaUUIDChanged(player)) {
                        this.plugin.getUsersStorageUtil().updateBedrockPlayerJavaUUID(player);
                    }
                });
            } else {
                this.handleJavaPlayer(player);
            }
            return;
        }
        this.handleJavaPlayer(player);
    }

    private void handleJavaPlayer(Player player) {
        this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAccept(teamPlayer -> teamPlayer.getPreferences().getTeleportTarget().ifPresent(position -> {
            Location location = new Location(Bukkit.getWorld((String)position.getWorld()), position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
            this.plugin.getUtils().teleportPlayer(player, location, this.plugin.getSettings().getServerName(), Utils.TeleportType.SERVER, null);
            teamPlayer.getPreferences().clearTeleportTarget();
            this.plugin.getUsersStorageUtil().updatePlayer((TeamPlayer)teamPlayer);
        }));
    }
}

