/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.models;

import dev.xf3d3.ultimateteams.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.TeamEnderChest;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;

public class TeamEnderChestBackup {
    @Expose
    private int teamId;
    @Expose
    private int chestNumber;
    @Expose
    private long timestamp;
    @Expose
    private String serializedContents;
    @Expose
    private int rows;

    @NotNull
    public static TeamEnderChestBackup fromChest(int teamId, @NotNull TeamEnderChest chest) {
        return TeamEnderChestBackup.builder().teamId(teamId).chestNumber(chest.getChestNumber()).timestamp(System.currentTimeMillis()).serializedContents(chest.getSerializedContents()).rows(chest.getRows()).build();
    }

    @NotNull
    public String getFormattedTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(this.timestamp));
    }

    @NotNull
    public String getTimeAgo() {
        long diff = System.currentTimeMillis() - this.timestamp;
        long minutes = diff / 60000L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + " day" + (days > 1L ? "s" : "") + " ago";
        }
        if (hours > 0L) {
            return hours + " hour" + (hours > 1L ? "s" : "") + " ago";
        }
        if (minutes > 0L) {
            return minutes + " minute" + (minutes > 1L ? "s" : "") + " ago";
        }
        return "just now";
    }

    @Generated
    public static TeamEnderChestBackupBuilder builder() {
        return new TeamEnderChestBackupBuilder();
    }

    @Generated
    private TeamEnderChestBackup() {
    }

    @Generated
    private TeamEnderChestBackup(int teamId, int chestNumber, long timestamp, String serializedContents, int rows) {
        this.teamId = teamId;
        this.chestNumber = chestNumber;
        this.timestamp = timestamp;
        this.serializedContents = serializedContents;
        this.rows = rows;
    }

    @Generated
    public int getTeamId() {
        return this.teamId;
    }

    @Generated
    public int getChestNumber() {
        return this.chestNumber;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getSerializedContents() {
        return this.serializedContents;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public void setTeamId(int teamId) {
        this.teamId = teamId;
    }

    @Generated
    public void setChestNumber(int chestNumber) {
        this.chestNumber = chestNumber;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setSerializedContents(String serializedContents) {
        this.serializedContents = serializedContents;
    }

    @Generated
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeamEnderChestBackup)) {
            return false;
        }
        TeamEnderChestBackup other = (TeamEnderChestBackup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTeamId() != other.getTeamId()) {
            return false;
        }
        if (this.getChestNumber() != other.getChestNumber()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        String this$serializedContents = this.getSerializedContents();
        String other$serializedContents = other.getSerializedContents();
        return !(this$serializedContents == null ? other$serializedContents != null : !this$serializedContents.equals(other$serializedContents));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TeamEnderChestBackup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTeamId();
        result = result * 59 + this.getChestNumber();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + this.getRows();
        String $serializedContents = this.getSerializedContents();
        result = result * 59 + ($serializedContents == null ? 43 : $serializedContents.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TeamEnderChestBackup(teamId=" + this.getTeamId() + ", chestNumber=" + this.getChestNumber() + ", timestamp=" + this.getTimestamp() + ", serializedContents=" + this.getSerializedContents() + ", rows=" + this.getRows() + ")";
    }

    @Generated
    public static class TeamEnderChestBackupBuilder {
        @Generated
        private int teamId;
        @Generated
        private int chestNumber;
        @Generated
        private long timestamp;
        @Generated
        private String serializedContents;
        @Generated
        private int rows;

        @Generated
        TeamEnderChestBackupBuilder() {
        }

        @Generated
        public TeamEnderChestBackupBuilder teamId(int teamId) {
            this.teamId = teamId;
            return this;
        }

        @Generated
        public TeamEnderChestBackupBuilder chestNumber(int chestNumber) {
            this.chestNumber = chestNumber;
            return this;
        }

        @Generated
        public TeamEnderChestBackupBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public TeamEnderChestBackupBuilder serializedContents(String serializedContents) {
            this.serializedContents = serializedContents;
            return this;
        }

        @Generated
        public TeamEnderChestBackupBuilder rows(int rows) {
            this.rows = rows;
            return this;
        }

        @Generated
        public TeamEnderChestBackup build() {
            return new TeamEnderChestBackup(this.teamId, this.chestNumber, this.timestamp, this.serializedContents, this.rows);
        }

        @Generated
        public String toString() {
            return "TeamEnderChestBackup.TeamEnderChestBackupBuilder(teamId=" + this.teamId + ", chestNumber=" + this.chestNumber + ", timestamp=" + this.timestamp + ", serializedContents=" + this.serializedContents + ", rows=" + this.rows + ")";
        }
    }
}

