/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.network;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamInvite;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.models.User;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.Payload;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public interface MessageHandler {
    default public void handleRequestUserList(@NotNull Message message, @Nullable Player receiver) {
        if (receiver == null) {
            return;
        }
        Message.builder().type(Message.Type.UPDATE_USER_LIST).payload(Payload.userList(Bukkit.getOnlinePlayers().stream().map(online -> User.of(online.getUniqueId(), online.getName())).toList())).target(message.getSourceServer(), Message.TargetType.SERVER).build().send(this.getBroker(), receiver);
    }

    default public void handleUpdateUserList(@NotNull Message message) {
        message.getPayload().getUserList().ifPresent(players -> this.getPlugin().getUsersStorageUtil().setUserList(message.getSourceServer(), (List<User>)players));
    }

    default public void handleTeamDelete(@NotNull Message message) {
        message.getPayload().getInteger().flatMap(teamID -> this.getPlugin().getTeamStorageUtil().getTeams().stream().filter(team -> team.getId() == teamID.intValue()).findFirst()).ifPresent(team -> this.getPlugin().getTeamStorageUtil().getTeams().remove(team));
    }

    default public void handleTeamUpdate(@NotNull Message message) {
        message.getPayload().getInteger().ifPresent(id -> this.getPlugin().runAsync(task -> this.getPlugin().getDatabase().getTeam((Integer)id).ifPresentOrElse(team -> this.getPlugin().getTeamStorageUtil().updateTeamLocal((Team)team, team.getId()), () -> this.getPlugin().log(Level.WARNING, "Failed to update team: Team not found", new Throwable[0]))));
    }

    default public void handleTeamInviteRequest(@NotNull Message message, @Nullable Player receiver) {
        if (receiver == null) {
            return;
        }
        message.getPayload().getInvite().ifPresentOrElse(invite -> this.getPlugin().getTeamInviteUtil().handleInboundInvite(receiver, (TeamInvite)invite), () -> this.getPlugin().log(Level.WARNING, "Invalid team invite request payload!", new Throwable[0]));
    }

    default public void handleTeamInviteReply(@NotNull Message message, @Nullable Player receiver) {
        Optional<TeamInvite> optionalTeamInvite = message.getPayload().getInvite();
        if (optionalTeamInvite.isEmpty()) {
            return;
        }
        TeamInvite invite = optionalTeamInvite.get();
        Optional<Team> team = this.getPlugin().getTeamStorageUtil().findTeamByMember(invite.getInviter());
        if (team.isEmpty()) {
            return;
        }
        this.getPlugin().getTeamInviteUtil().removeInvitee(invite.getInvitee());
        if (!this.getPlugin().getSettings().teamJoinAnnounce()) {
            return;
        }
        if (Boolean.FALSE.equals(invite.getAccepted())) {
            Player inviter = Bukkit.getPlayer((UUID)invite.getInviter());
            if (inviter != null) {
                inviter.sendMessage(Utils.Color(this.getPlugin().msgFileManager.getMessagesConfig().getString("team-invite-denied-inviter").replace("%PLAYER%", Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)invite.getInvitee()).getName(), "?"))));
            }
            return;
        }
        team.get().sendTeamMessage(Utils.Color(this.getPlugin().msgFileManager.getMessagesConfig().getString("team-join-broadcast-chat").replace("%PLAYER%", Objects.requireNonNullElse(Bukkit.getOfflinePlayer((UUID)invite.getInvitee()).getName(), "?")).replace("%TEAM%", Utils.Color(team.get().getName()))));
    }

    default public void handleTeamChatMessage(@NotNull Message message) {
        message.getPayload().getString().ifPresent(text -> this.getPlugin().getTeamStorageUtil().findTeamByMember(Bukkit.getOfflinePlayer((String)message.getSender()).getUniqueId()).ifPresent(team -> {
            team.sendTeamMessage(Utils.Color(text));
            if (this.getPlugin().getSettings().teamChatSpyEnabled()) {
                String spyMessage = Utils.Color(this.getPlugin().getSettings().getTeamChatSpyPrefix() + " " + text);
                Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("ultimateteams.chat.spy")).forEach(p -> p.sendMessage(spyMessage));
            }
        }));
    }

    default public void handleTeamAllyChatMessage(@NotNull Message message) {
        message.getPayload().getString().ifPresent(text -> this.getPlugin().getTeamStorageUtil().findTeamByMember(Bukkit.getOfflinePlayer((String)message.getSender()).getUniqueId()).ifPresent(team -> {
            Set<Team> allies = team.getRelations(this.getPlugin()).entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ALLY).map(Map.Entry::getKey).filter(otherTeam -> team.areRelationsBilateral((Team)otherTeam, Team.Relation.ALLY)).collect(Collectors.toSet());
            team.sendTeamMessage(Utils.Color(text));
            allies.forEach(alliedTeam -> alliedTeam.sendTeamMessage(Utils.Color(text)));
            if (this.getPlugin().getSettings().teamChatSpyEnabled()) {
                String spyMessage = Utils.Color(this.getPlugin().getSettings().getTeamChatSpyPrefix() + " " + text);
                Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("ultimateteams.chat.spy")).forEach(p -> p.sendMessage(spyMessage));
            }
        }));
    }

    default public void handleTeamAction(@NotNull Message message) {
        message.getPayload().getInteger().flatMap(id -> this.getPlugin().getTeamStorageUtil().getTeams().stream().filter(team -> team.getId() == id.intValue()).findFirst()).ifPresent(team -> {
            Player owner;
            if (message.getType() == Message.Type.TEAM_TRANSFERRED && (owner = Bukkit.getPlayer((UUID)team.getOwner())) != null) {
                owner.sendMessage(Utils.Color(this.getPlugin().msgFileManager.getMessagesConfig().getString("team-ownership-transfer-new-owner").replace("%TEAM%", team.getName())));
            }
        });
    }

    default public void handleTeamUserAction(@NotNull Message message, @Nullable Player receiver) {
        if (receiver == null) {
            return;
        }
        receiver.sendMessage(Utils.Color(this.getPlugin().msgFileManager.getMessagesConfig().getString("team-kicked-player-message")).replace("%TEAM%", this.getPlugin().getTeamStorageUtil().findTeamByMember(receiver.getUniqueId()).map(Team::getName).orElse("?")));
        this.getPlugin().getUsersStorageUtil().getPlayer(receiver.getUniqueId()).thenAccept(teamPlayer -> {
            teamPlayer.getPreferences().setTeamChatTalking(false);
            this.getPlugin().getUsersStorageUtil().updatePlayer((TeamPlayer)teamPlayer);
        });
    }

    @NotNull
    public Broker getBroker();

    @NotNull
    public UltimateTeams getPlugin();
}

