/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.utils;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.gson.Gson;
import dev.xf3d3.ultimateteams.libraries.gson.GsonBuilder;
import dev.xf3d3.ultimateteams.libraries.gson.reflect.TypeToken;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamEnderChest;
import dev.xf3d3.ultimateteams.models.TeamEnderChestBackup;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class EnderChestBackupManager {
    private final UltimateTeams plugin;
    private final File backupsFile;
    private final Gson gson;
    private final Map<String, List<TeamEnderChestBackup>> backups;
    private BukkitTask backupTask;
    private static final int BACKUP_INTERVAL_MINUTES = 30;
    private static final int BACKUP_INTERVAL_TICKS = 36000;
    private static final int MAX_BACKUPS_PER_CHEST = 10;

    public EnderChestBackupManager(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.backupsFile = new File(plugin.getDataFolder(), "echest_backups.json");
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
        this.backups = new ConcurrentHashMap<String, List<TeamEnderChestBackup>>();
        this.loadBackups();
        this.startAutoBackup();
    }

    private void startAutoBackup() {
        if (this.backupTask != null) {
            this.backupTask.cancel();
        }
        this.backupTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            this.plugin.getLogger().info("Creating automatic ender chest backups...");
            this.backupAllChests();
            this.saveBackups();
            this.plugin.getLogger().info("Automatic ender chest backups completed.");
        }, 36000L, 36000L);
    }

    public void shutdown() {
        if (this.backupTask != null) {
            this.backupTask.cancel();
            this.backupTask = null;
        }
        this.saveBackups();
    }

    public void backupAllChests() {
        for (Team team : this.plugin.getTeamStorageUtil().getTeams()) {
            for (int chestNumber = 1; chestNumber <= team.getEnderChestCount(); ++chestNumber) {
                team.getEnderChest(chestNumber).ifPresent(chest -> this.backupChest(team.getId(), (TeamEnderChest)chest));
            }
        }
    }

    public int backupTeamChests(int teamId) {
        int count = 0;
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeam(teamId);
        if (teamOpt.isPresent()) {
            Team team = teamOpt.get();
            for (int chestNumber = 1; chestNumber <= team.getEnderChestCount(); ++chestNumber) {
                team.getEnderChest(chestNumber).ifPresent(chest -> this.backupChest(team.getId(), (TeamEnderChest)chest));
                ++count;
            }
        }
        return count;
    }

    public void backupChest(int teamId, @NotNull TeamEnderChest chest) {
        String key = this.getKey(teamId, chest.getChestNumber());
        TeamEnderChestBackup backup = TeamEnderChestBackup.fromChest(teamId, chest);
        List chestBackups = this.backups.computeIfAbsent(key, k -> new ArrayList());
        chestBackups.add(backup);
        if (chestBackups.size() > 10) {
            chestBackups.sort(Comparator.comparingLong(TeamEnderChestBackup::getTimestamp));
            chestBackups.subList(0, chestBackups.size() - 10).clear();
        }
    }

    @NotNull
    public List<TeamEnderChestBackup> getBackups(int teamId, int chestNumber) {
        String key = this.getKey(teamId, chestNumber);
        List chestBackups = this.backups.getOrDefault(key, new ArrayList());
        chestBackups.sort(Comparator.comparingLong(TeamEnderChestBackup::getTimestamp).reversed());
        return new ArrayList<TeamEnderChestBackup>(chestBackups);
    }

    @NotNull
    public Optional<TeamEnderChestBackup> getBackup(int teamId, int chestNumber, int index) {
        List<TeamEnderChestBackup> chestBackups = this.getBackups(teamId, chestNumber);
        if (index >= 0 && index < chestBackups.size()) {
            return Optional.of(chestBackups.get(index));
        }
        return Optional.empty();
    }

    public boolean restoreBackup(int teamId, int chestNumber, int backupIndex) {
        Optional<Team> teamOpt = this.plugin.getTeamStorageUtil().findTeam(teamId);
        if (teamOpt.isEmpty()) {
            return false;
        }
        Team team = teamOpt.get();
        Optional<TeamEnderChest> chestOpt = team.getEnderChest(chestNumber);
        if (chestOpt.isEmpty()) {
            return false;
        }
        Optional<TeamEnderChestBackup> backupOpt = this.getBackup(teamId, chestNumber, backupIndex);
        if (backupOpt.isEmpty()) {
            return false;
        }
        TeamEnderChestBackup backup = backupOpt.get();
        TeamEnderChest chest = chestOpt.get();
        chest.setSerializedContents(backup.getSerializedContents());
        chest.setRows(backup.getRows());
        this.plugin.getDatabase().updateTeam(team);
        return true;
    }

    public void deleteBackups(int teamId, int chestNumber) {
        String key = this.getKey(teamId, chestNumber);
        this.backups.remove(key);
        this.saveBackups();
    }

    public void deleteTeamBackups(int teamId) {
        this.backups.keySet().removeIf(key -> key.startsWith(teamId + "-"));
        this.saveBackups();
    }

    private String getKey(int teamId, int chestNumber) {
        return teamId + "-" + chestNumber;
    }

    private void loadBackups() {
        if (!this.backupsFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.backupsFile);){
            Type type = new TypeToken<Map<String, List<TeamEnderChestBackup>>>(){}.getType();
            Map loaded = (Map)this.gson.fromJson((Reader)reader, type);
            if (loaded != null) {
                this.backups.putAll(loaded);
                this.plugin.getLogger().info("Loaded " + this.backups.size() + " ender chest backup entries.");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to load ender chest backups: " + e.getMessage());
        }
    }

    public void saveBackups() {
        try {
            if (!this.backupsFile.exists()) {
                this.backupsFile.getParentFile().mkdirs();
                this.backupsFile.createNewFile();
            }
            try (FileWriter writer = new FileWriter(this.backupsFile);){
                this.gson.toJson(this.backups, (Appendable)writer);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save ender chest backups: " + e.getMessage());
        }
    }
}

