/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.api;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.config.Messages;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.ApiStatus;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.models.User;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class UltimateTeamsAPI {
    private final UltimateTeams plugin;
    private static UltimateTeamsAPI instance;

    private UltimateTeamsAPI(UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public boolean isLoaded() {
        return this.plugin.isLoaded();
    }

    @ApiStatus.Internal
    public static void register(@NotNull UltimateTeams plugin) {
        instance = new UltimateTeamsAPI(plugin);
    }

    @NotNull
    public static UltimateTeamsAPI getInstance() throws NotRegisteredException {
        if (instance == null) {
            throw new NotRegisteredException();
        }
        return instance;
    }

    public Set<Team> getAllTeams() {
        return this.plugin.getTeamStorageUtil().getTeams();
    }

    public Messages getMessages() {
        return this.plugin.getMessages();
    }

    public Optional<Team> findTeamById(int id) {
        return this.plugin.getTeamStorageUtil().findTeam(id);
    }

    public Optional<Team> findTeamByName(@NotNull String name) {
        return this.plugin.getTeamStorageUtil().findTeamByName(name);
    }

    public Optional<Team> findTeamByOwner(@NotNull UUID uuid) {
        return this.plugin.getTeamStorageUtil().findTeamByOwner(uuid);
    }

    public Optional<Team> findTeamByMember(@NotNull UUID uuid) {
        return this.plugin.getTeamStorageUtil().findTeamByMember(uuid);
    }

    public void addMember(@NotNull Team team, @NotNull Player newMember) {
        this.plugin.getTeamStorageUtil().addTeamMember(team, newMember);
    }

    public void kickMember(@NotNull Team team, OfflinePlayer member, @NotNull Player actor) {
        this.plugin.getTeamStorageUtil().kickPlayer(actor, team, member);
    }

    public void transferTeam(@NotNull Team team, @NotNull UUID newOwner) {
        this.plugin.getTeamStorageUtil().transferTeamOwner(team, newOwner);
    }

    public void addTeamEnemy(@NotNull Team team, @NotNull Team enemyTeam, @NotNull Player actor) {
        this.plugin.getTeamStorageUtil().addTeamEnemy(team, enemyTeam, actor);
    }

    public void removeTeamEnemy(@NotNull Team team, @NotNull Team enemyTeam, @NotNull Player actor) {
        this.plugin.getTeamStorageUtil().removeTeamEnemy(team, enemyTeam, actor);
    }

    public void addTeamAlly(@NotNull Team team, @NotNull Team allyTeam, @NotNull Player actor) {
        this.plugin.getTeamStorageUtil().addTeamAlly(team, allyTeam, actor);
    }

    public void removeTeamAlly(@NotNull Team team, @NotNull Team allyTeam, @NotNull Player actor) {
        this.plugin.getTeamStorageUtil().removeTeamAlly(team, allyTeam, actor);
    }

    public void updateTeam(@NotNull Player actor, @NotNull Team team) {
        this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(actor, team));
    }

    public void createTeam(@NotNull Player player, @NotNull String teamName) {
        this.plugin.getTeamStorageUtil().createTeam(player, teamName);
    }

    public boolean isInTeam(@NotNull Player player) {
        return this.plugin.getTeamStorageUtil().isInTeam(player);
    }

    public boolean isTeamOwner(@NotNull Player player) {
        return this.plugin.getTeamStorageUtil().isTeamOwner(player);
    }

    public boolean isTeamManager(@NotNull Player player) {
        return this.plugin.getTeamStorageUtil().isTeamManager(player);
    }

    public List<User> getOnlineUsers() {
        return this.plugin.getUsersStorageUtil().getUserList();
    }

    public CompletableFuture<TeamPlayer> getTeamPlayer(@NotNull UUID uuid) {
        return this.plugin.getUsersStorageUtil().getPlayer(uuid);
    }

    public void updatePlayer(@NotNull TeamPlayer teamPlayer) {
        this.plugin.getUsersStorageUtil().updatePlayer(teamPlayer);
    }

    public static final class NotRegisteredException
    extends IllegalStateException {
        private static final String MESSAGE = "Could not access the UltimateTeams API as it has not yet been initialized. This could be because:\n1) UltimateTeams did not load\n2) Your plugin isn't set to load after UltimateTeams (check the docs)\n3) You are attempting to access UltimateTeams on plugin construction/before your plugin has enabled.";

        NotRegisteredException() {
            super(MESSAGE);
        }
    }
}

