/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamMemberJoinEvent;
import dev.xf3d3.ultimateteams.api.events.TeamTransferOwnershipEvent;
import dev.xf3d3.ultimateteams.commands.TeamCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.echest.TeamAdminEnderChestSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.echest.TeamEnderChestRollbackSubCommand;
import dev.xf3d3.ultimateteams.commands.subCommands.echest.TeamEnderChestSubCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Subcommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Syntax;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Values;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.bukkit.contexts.OnlinePlayer;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.migrator.Migrator;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="teamadmin|ta")
public class TeamAdmin
extends BaseCommand {
    private static final String PLAYER_TO_KICK = "%KICKEDPLAYER%";
    private final UltimateTeams plugin;
    private Migrator migrator;
    private final TeamEnderChestSubCommand teamEnderChestSubCommand;
    private final TeamAdminEnderChestSubCommand teamAdminEnderChestSubCommand;

    public TeamAdmin(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.teamEnderChestSubCommand = new TeamEnderChestSubCommand(plugin);
        this.teamAdminEnderChestSubCommand = new TeamAdminEnderChestSubCommand(plugin, this.teamEnderChestSubCommand);
    }

    @Default
    @Subcommand(value="about")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.admin.about")
    public void aboutSubcommand(CommandSender sender) {
        sender.sendMessage(Utils.Color("&3~~~~~~~~~~ &6&nUltimateTeams&r &3~~~~~~~~~~"));
        sender.sendMessage(Utils.Color("&3Version: &6" + this.plugin.getDescription().getVersion()));
        sender.sendMessage(Utils.Color("&3Database Type: &6" + this.plugin.getSettings().getDatabaseType().getDisplayName()));
        this.plugin.getMessageBroker().ifPresent(broker -> sender.sendMessage(Utils.Color("&3Broker Type: &6" + this.plugin.getSettings().getBrokerType().getDisplayName())));
        sender.sendMessage(Utils.Color("&3Author: &6" + String.valueOf(this.plugin.getDescription().getAuthors())));
        sender.sendMessage(Utils.Color("&3Contributors: &6" + String.valueOf(this.plugin.getDescription().getContributors())));
        sender.sendMessage(Utils.Color("&3Description: &6" + this.plugin.getDescription().getDescription()));
        sender.sendMessage(Utils.Color("&3Website: "));
        sender.sendMessage(Utils.Color("&6" + this.plugin.getDescription().getWebsite()));
        sender.sendMessage(Utils.Color("&3~~~~~~~~~~ &6&nUltimateTeams&r &3~~~~~~~~~~"));
    }

    @Subcommand(value="reload")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.admin.reload")
    public void reloadSubcommand(CommandSender sender) {
        sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPluginReloadBegin(), new String[0]));
        this.plugin.runSync(task -> {
            this.plugin.loadConfigs();
            TeamCommand.updateBannedTagsList();
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPluginReloadSuccessful(), new String[0]));
        });
    }

    @Subcommand(value="migrate")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimateteams.admin.migrate")
    public void migrateSubcommand(CommandSender sender) {
        sender.sendMessage("Visit: https://github.com/xF3d33/UltimateTeams/blob/main/HowToMigrate.md for a guida on how to migrate");
    }

    @Subcommand(value="migrate set")
    @CommandCompletion(value="<parameter> <value>")
    @CommandPermission(value="ultimateteams.admin.migrate")
    public void migrateSetSubcommand(CommandSender sender, String parameter, String value) {
        if (this.migrator == null) {
            this.migrator = new Migrator(this.plugin);
        }
        this.migrator.setParameter(parameter, value);
        sender.sendMessage(Utils.Color(String.format("Parameter %s set to %s", parameter, value)));
    }

    @Subcommand(value="migrate start")
    @CommandCompletion(value="<parameter> <value>")
    @CommandPermission(value="ultimateteams.admin.migrate")
    public void migrateStartSubcommand(CommandSender sender) {
        if (this.migrator == null) {
            sender.sendMessage(Utils.Color("&3Set migrator's parameters first!"));
            return;
        }
        this.migrator.startMigration();
    }

    @Subcommand(value="team disband")
    @CommandCompletion(value="@teams")
    @CommandPermission(value="ultimateteams.admin.team.disband")
    @Syntax(value="<teamName>")
    public void disbandSubcommand(CommandSender sender, @Values(value="@teams") String teamName) {
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            if (!this.plugin.getSettings().isEnableCrossServer()) {
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().deleteTeamData(null, (Team)team));
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamSuccessfullyDisbanded(), new String[0]));
                return;
            }
            Bukkit.getOnlinePlayers().stream().findAny().ifPresentOrElse(randomPlayer -> this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().deleteTeamData((Player)randomPlayer, (Team)team)), () -> this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().deleteTeamData(null, (Team)team)));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamAdminDisbandFailure(), new String[0])));
    }

    @Subcommand(value="team join")
    @CommandCompletion(value="@players @teams @nothing")
    @CommandPermission(value="ultimateteams.admin.team.join")
    @Syntax(value="<Player> <teamName>")
    public void teamJoinSubCommand(CommandSender sender, OnlinePlayer user, @Values(value="@teams") String teamName) {
        Player player = user.getPlayer();
        if (this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).isPresent()) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteInvitedAlreadyInTeam(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            if (new TeamMemberJoinEvent(player, (Team)team, TeamMemberJoinEvent.JoinReason.ADMIN_ACTION).callEvent()) {
                return;
            }
            this.plugin.getTeamStorageUtil().addTeamMember((Team)team, player);
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinSuccessful().replace("%TEAM%", team.getName()), new String[0]));
            team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinBroadcastChat().replace("%PLAYER%", player.getName()).replace("%TEAM%", Utils.Color(team.getName())), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinFailed().replace("%TEAM%", teamName), new String[0])));
    }

    @Subcommand(value="team transfer")
    @CommandCompletion(value="@teams @onlineUsers @nothing")
    @CommandPermission(value="ultimateteams.admin.team.transfer")
    @Syntax(value="<team> <player>")
    public void teamTransferSubCommand(CommandSender sender, @Values(value="@teams") String teamName, @Values(value="@onlineUsers") OfflinePlayer user) {
        if (!user.hasPlayedBefore() || user.getName() == null) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerNotFound(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            if (!team.getMembers().containsKey(user.getUniqueId())) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamOwnershipTransferFailureNotSameTeam(), new String[0]));
                return;
            }
            if (new TeamTransferOwnershipEvent(team.getOwner(), user.getUniqueId(), (Team)team).callEvent()) {
                return;
            }
            this.plugin.getTeamStorageUtil().transferTeamOwner((Team)team, user.getUniqueId());
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamOwnershipTransferSuccessful().replace("%PLAYER%", user.getName()), new String[0]));
            if (user.isOnline() && user.getPlayer() != null) {
                user.getPlayer().sendMessage(MineDown.parse(this.plugin.getMessages().getTeamOwnershipTransferNewOwner().replace("%TEAM%", team.getName()), new String[0]));
            }
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNotFound(), new String[0])));
    }

    @Subcommand(value="echest add")
    @CommandCompletion(value="@teams 1-6|chest|doublechest @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.add")
    @Syntax(value="<team-name> <rows|chest|doublechest>")
    public void addEnderChestSubCommand(CommandSender sender, @Values(value="@teams") String teamName, String rowsOrType) {
        this.teamAdminEnderChestSubCommand.addEnderChest(sender, teamName, rowsOrType);
    }

    @Subcommand(value="echest remove")
    @CommandCompletion(value="@teams <chest-number> @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.remove")
    @Syntax(value="<team-name> <chest-number>")
    public void removeEnderChestSubCommand(CommandSender sender, @Values(value="@teams") String teamName, int chestNumber) {
        this.teamAdminEnderChestSubCommand.removeEnderChest(sender, teamName, chestNumber);
    }

    @Subcommand(value="echest list")
    @CommandCompletion(value="@teams @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.list")
    @Syntax(value="<team-name>")
    public void listEnderChestsSubCommand(CommandSender sender, @Values(value="@teams") String teamName) {
        this.teamAdminEnderChestSubCommand.listEnderChests(sender, teamName);
    }

    @Subcommand(value="echest see")
    @CommandCompletion(value="@teams <chest-number> @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.see")
    @Syntax(value="<team-name> <chest-number>")
    public void seeEnderChestSubCommand(CommandSender sender, @Values(value="@teams") String teamName, int chestNumber) {
        this.teamAdminEnderChestSubCommand.seeEnderChest(sender, teamName, chestNumber);
    }

    @Subcommand(value="echest backups")
    @CommandCompletion(value="@teams <chest-number> @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.rollback")
    @Syntax(value="<team-name> <chest-number>")
    public void echestBackupsSubCommand(CommandSender sender, @Values(value="@teams") String teamName, int chestNumber) {
        new TeamEnderChestRollbackSubCommand(this.plugin).listBackupsAdmin(sender, teamName, chestNumber);
    }

    @Subcommand(value="echest rollback")
    @CommandCompletion(value="@teams <chest-number> <backup#> @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.rollback")
    @Syntax(value="<team-name> <chest-number> <backup-number>")
    public void echestRollbackSubCommand(CommandSender sender, @Values(value="@teams") String teamName, int chestNumber, int backupNumber) {
        new TeamEnderChestRollbackSubCommand(this.plugin).rollbackChestAdmin(sender, teamName, chestNumber, backupNumber, false);
    }

    @Subcommand(value="echest forcerollback")
    @CommandCompletion(value="@teams <chest-number> <backup#> @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.rollback")
    @Syntax(value="<team-name> <chest-number> <backup-number>")
    public void echestForceRollbackSubCommand(CommandSender sender, @Values(value="@teams") String teamName, int chestNumber, int backupNumber) {
        new TeamEnderChestRollbackSubCommand(this.plugin).rollbackChestAdmin(sender, teamName, chestNumber, backupNumber, true);
    }

    @Subcommand(value="echest backupall")
    @CommandCompletion(value="@teams @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.backup")
    @Syntax(value="<team-name>")
    public void echestAllBackupSubCommand(CommandSender sender, @Values(value="@teams") String teamName) {
        this.teamAdminEnderChestSubCommand.backupAllChests(sender, teamName);
    }

    @Subcommand(value="echest removerow")
    @CommandCompletion(value="@teams <chest-number> <rows> @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.remove")
    @Syntax(value="<team-name> <chest-number> <rows-to-remove>")
    public void removeRowSubCommand(CommandSender sender, @Values(value="@teams") String teamName, int chestNumber, int rowsToRemove) {
        this.teamAdminEnderChestSubCommand.removeRows(sender, teamName, chestNumber, rowsToRemove);
    }

    @Subcommand(value="echest removechest")
    @CommandCompletion(value="@teams <chest-number> @nothing")
    @CommandPermission(value="ultimateteams.admin.echest.remove")
    @Syntax(value="<team-name> <chest-number>")
    public void removeChestSubCommand(CommandSender sender, @Values(value="@teams") String teamName, int chestNumber) {
        this.teamAdminEnderChestSubCommand.removeEnderChest(sender, teamName, chestNumber);
    }
}

