/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.chat;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Syntax;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.network.Broker;
import dev.xf3d3.ultimateteams.network.Message;
import dev.xf3d3.ultimateteams.network.Payload;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="tc|teamchat|tchat")
public class TeamChatCommand
extends BaseCommand {
    private final Logger logger;
    private final UltimateTeams plugin;

    public TeamChatCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    @Default
    @CommandCompletion(value="<message>")
    @Syntax(value="/tc <message>")
    @CommandPermission(value="ultimateteams.teamchat")
    public void onCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamChatEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        if (args.length < 1) {
            if (this.plugin.getUsersStorageUtil().getChatPlayers().containsKey(player.getUniqueId())) {
                this.plugin.getUsersStorageUtil().getChatPlayers().remove(player.getUniqueId());
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getChatToggleOff(), new String[0]));
                this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAcceptAsync(teamPlayer -> {
                    teamPlayer.getPreferences().setTeamChatTalking(false);
                    this.plugin.getDatabase().updatePlayer((TeamPlayer)teamPlayer);
                });
            } else {
                this.plugin.getUsersStorageUtil().getChatPlayers().put(player.getUniqueId(), true);
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getChatToggleOn(), new String[0]));
                this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAcceptAsync(teamPlayer -> {
                    teamPlayer.getPreferences().setTeamChatTalking(true);
                    this.plugin.getDatabase().updatePlayer((TeamPlayer)teamPlayer);
                });
            }
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            String chatSpyPrefix = this.plugin.getSettings().getTeamChatSpyPrefix();
            StringBuilder messageString = new StringBuilder();
            messageString.append(this.plugin.getSettings().getTeamChatPrefix()).append(" ");
            messageString.append("&d").append(player.getName()).append(":&r").append(" ");
            for (String arg : args) {
                messageString.append(arg).append(" ");
            }
            String msg = messageString.toString().replace("%TEAM%", team.getName()).replace("%PLAYER%", player.getName());
            team.sendTeamMessage(Utils.Color(msg));
            if (this.plugin.getSettings().teamChatSpyEnabled()) {
                String spyMessage = Utils.Color(chatSpyPrefix + " " + msg);
                Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("ultimateteams.chat.spy")).forEach(p -> p.sendMessage(spyMessage));
            }
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.TEAM_CHAT_MESSAGE).payload(Payload.string(msg)).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, player));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

