/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.chat;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="chatspy|teamchatspy|tchatspy")
public class TeamChatSpyCommand
extends BaseCommand {
    private final UltimateTeams plugin;

    public TeamChatSpyCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    @CommandCompletion(value="@nothing")
    @Default
    public void onCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getSettings().teamChatSpyEnabled()) {
                if (player.hasPermission("ultimateteams.chat.spy")) {
                    if (this.plugin.getUsersStorageUtil().toggleChatSpy(player)) {
                        player.sendMessage(MineDown.parse(this.plugin.getMessages().getChatspyToggleOn(), new String[0]));
                    } else {
                        player.sendMessage(MineDown.parse(this.plugin.getMessages().getChatspyToggleOff(), new String[0]));
                    }
                } else {
                    player.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                }
            } else {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            }
        }
    }
}

