/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamPreCreateEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.utils.TeamsStorage;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamCreateSubCommand {
    private final UltimateTeams plugin;
    private final TeamsStorage storageUtil;
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    int MIN_CHAR_LIMIT;
    int MAX_CHAR_LIMIT;

    public TeamCreateSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.storageUtil = plugin.getTeamStorageUtil();
        this.MIN_CHAR_LIMIT = plugin.getSettings().getTeamNameMinLength();
        this.MAX_CHAR_LIMIT = plugin.getSettings().getTeamNameMaxLength();
    }

    public void createTeamSubCommand(CommandSender sender, String name, List<String> bannedTags) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (name.contains(" ")) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameContainsSpace().replace(TEAM_PLACEHOLDER, name), new String[0]));
            return;
        }
        if (bannedTags.stream().map(String::toLowerCase).toList().contains(name.toLowerCase())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameIsBanned().replace(TEAM_PLACEHOLDER, name), new String[0]));
            return;
        }
        if (this.plugin.getTeamStorageUtil().getTeamsName().stream().map(String::toLowerCase).toList().contains(name.toLowerCase())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameAlreadyTaken().replace(TEAM_PLACEHOLDER, name), new String[0]));
            return;
        }
        if (!this.plugin.getSettings().isTeamCreateAllowColorCodes() && (name.contains("&") || name.contains("#"))) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameCannotContainColours(), new String[0]));
            return;
        }
        if (this.plugin.getSettings().isTeamCreateRequirePermColorCodes() && !player.hasPermission("ultimateteams.team.create.usecolors") && (name.contains("&") || name.contains("#"))) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getUseColoursMissingPermission(), new String[0]));
            return;
        }
        if (this.storageUtil.isInTeam(player)) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamCreationFailed().replace(TEAM_PLACEHOLDER, Utils.Color(name)), new String[0]));
            return;
        }
        int nameLength = Utils.removeColors(name).length();
        if (nameLength < this.MIN_CHAR_LIMIT) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameTooShort().replace("%CHARMIN%", Integer.toString(this.MIN_CHAR_LIMIT)), new String[0]));
            return;
        }
        if (nameLength > this.MAX_CHAR_LIMIT) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameTooLong().replace("%CHARMAX%", Integer.toString(this.MAX_CHAR_LIMIT)), new String[0]));
            return;
        }
        if (this.plugin.getEconomyHook() != null && !this.plugin.getEconomyHook().takeMoney(player, this.plugin.getSettings().getTeamCreateCost())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotEnoughMoney().replace("%MONEY%", String.valueOf(this.plugin.getSettings().getTeamCreateCost())), new String[0]));
            return;
        }
        TeamPreCreateEvent event = new TeamPreCreateEvent(player, name);
        if (event.callEvent()) {
            return;
        }
        this.storageUtil.createTeam(player, event.getName());
        player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamCreatedSuccessfully().replace(TEAM_PLACEHOLDER, Utils.Color(name)), new String[0]));
    }
}

