/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamInfoSubCommand {
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    private static final String OWNER = "%OWNER%";
    private static final String TEAM_MEMBER = "%MEMBER%";
    private static final String ALLY_TEAM = "%ALLYTEAM%";
    private static final String ENEMY_TEAM = "%ENEMYTEAM%";
    private final UltimateTeams plugin;

    public TeamInfoSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamInfoSubCommand(CommandSender sender, @Nullable String teamName) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (teamName != null) {
                this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> player.sendMessage(Utils.Color(this.getInfo((Team)team))), () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNotFound(), new String[0])));
                return;
            }
            this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> player.sendMessage(Utils.Color(this.getInfo((Team)team))), () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
        } else {
            this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> sender.sendMessage(Utils.Color(this.getInfo((Team)team))), () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNotFound(), new String[0])));
        }
    }

    private String getInfo(@NotNull Team team) {
        String offlinePlayer;
        Player teamPlayer;
        Map<Team, Team.Relation> relations = team.getRelations(this.plugin);
        Map<Team, Team.Relation> allies = relations.entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ALLY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Team, Team.Relation> enemies = relations.entrySet().stream().filter(entry -> entry.getValue() == Team.Relation.ENEMY).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set teamMembers = team.getMembers().entrySet().stream().filter(entry -> (Integer)entry.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set teamManagers = team.getMembers().entrySet().stream().filter(entry -> (Integer)entry.getValue() == 2).map(Map.Entry::getKey).collect(Collectors.toSet());
        StringBuilder teamInfo = new StringBuilder(Utils.Color(this.plugin.getMessages().getTeamInfoHeader().replace(TEAM_PLACEHOLDER, Utils.Color(team.getName()))).replace("%TEAMPREFIX%", Utils.Color(team.getPrefix() != null ? team.getPrefix() : "")));
        teamInfo.append("\n");
        Player teamOwner = Bukkit.getPlayer((UUID)team.getOwner());
        if (teamOwner != null) {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoOwnerOnline()).replace(OWNER, teamOwner.getName())).append("\n");
        } else {
            String offlineOwner = Bukkit.getOfflinePlayer((UUID)team.getOwner()).getName();
            offlineOwner = offlineOwner != null ? offlineOwner : "player not found";
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoOwnerOffline()).replace(OWNER, offlineOwner)).append("\n");
        }
        if (!teamMembers.isEmpty()) {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoMembersHeader()).replace("%NUMBER%", Utils.Color(String.valueOf(teamMembers.size())))).append("\n");
            for (UUID teamMember : teamMembers) {
                teamPlayer = Bukkit.getPlayer((UUID)teamMember);
                if (teamPlayer != null) {
                    teamInfo.append((this.plugin.getMessages().getTeamInfoMembersOnline() + "\n").replace(TEAM_MEMBER, teamPlayer.getName()));
                    continue;
                }
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)teamMember).getName();
                teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoMembersOffline() + "\n").replace(TEAM_MEMBER, offlinePlayer != null ? offlinePlayer : "player not found"));
            }
        }
        if (!teamManagers.isEmpty()) {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoManagersHeader().replace("%NUMBER%", Utils.Color(String.valueOf(teamManagers.size()))))).append("\n");
            for (UUID teamMember : teamManagers) {
                teamPlayer = Bukkit.getPlayer((UUID)teamMember);
                if (teamPlayer != null) {
                    teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoMembersOnline() + "\n").replace(TEAM_MEMBER, teamPlayer.getName()));
                    continue;
                }
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)teamMember).getName();
                teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoMembersOffline() + "\n").replace(TEAM_MEMBER, offlinePlayer != null ? offlinePlayer : "player not found"));
            }
        }
        if (!allies.isEmpty()) {
            teamInfo.append(" ");
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoAlliesHeader())).append("\n");
            allies.keySet().forEach(t -> teamInfo.append(this.plugin.getMessages().getTeamAllyMembers().replace(ALLY_TEAM, t.getName())).append("\n"));
        }
        if (!enemies.isEmpty()) {
            teamInfo.append(" ");
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoEnemiesHeader())).append("\n");
            enemies.keySet().forEach(t -> teamInfo.append(this.plugin.getMessages().getTeamEnemyMembers().replace(ENEMY_TEAM, t.getName())).append("\n"));
        }
        teamInfo.append(" ");
        if (this.plugin.getSettings().isEconomyEnabled()) {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoBankAmount().replace("%AMOUNT%", String.format("%.2f", team.getBalance())))).append("\n");
            if (this.plugin.getSettings().isTeamJoinFeeEnabled()) {
                teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoJoinFee().replace("%AMOUNT%", String.valueOf(team.getJoin_fee())))).append("\n");
            }
        }
        if (team.isFriendlyFire()) {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamPvpStatusEnabled())).append("\n");
        } else {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamPvpStatusDisabled())).append("\n");
        }
        if (this.plugin.getTeamStorageUtil().isHomeSet(team)) {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamHomeSetTrue())).append("\n");
        } else {
            teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamHomeSetFalse())).append("\n");
        }
        teamInfo.append(" ");
        teamInfo.append(Utils.Color(this.plugin.getMessages().getTeamInfoFooter())).append("\n");
        return teamInfo.toString();
    }
}

