/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamPermissionsSubCommand {
    private final UltimateTeams plugin;

    public TeamPermissionsSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamPermissionsAddSubCommand(CommandSender sender, String permission) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamMustBeOwner(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            Optional<Team.Permission> perm = Team.Permission.parse(permission);
            if (perm.isEmpty()) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPermissionNotFound().replace("%PERM%", permission), new String[0]));
                return;
            }
            team.addPermission(perm.get());
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPermissionAddedSuccessful().replace("%PERM%", String.valueOf((Object)perm.get())), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    public void teamPermissionsRemoveSubCommand(CommandSender sender, String permission) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamMustBeOwner(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            Optional<Team.Permission> perm = Team.Permission.parse(permission);
            if (perm.isEmpty()) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPermissionNotFound().replace("%PERM%", permission), new String[0]));
                return;
            }
            team.removePermission(perm.get());
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPermissionRemovedSuccessful().replace("%PERM%", String.valueOf((Object)perm.get())), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

