/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamPrefixSubCommand {
    private final int MIN_CHAR_LIMIT;
    private final int MAX_CHAR_LIMIT;
    private final UltimateTeams plugin;

    public TeamPrefixSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.MAX_CHAR_LIMIT = plugin.getSettings().getTeamTagsMaxCharLimit();
        this.MIN_CHAR_LIMIT = plugin.getSettings().getTeamTagsMinCharLimit();
    }

    public void teamPrefixSubCommand(CommandSender sender, String prefix, List<String> bannedTags) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (bannedTags.stream().map(String::toLowerCase).toList().contains(prefix.toLowerCase())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPrefixIsBanned().replace("%TEAMPREFIX%", prefix), new String[0]));
            return;
        }
        if (this.plugin.getTeamStorageUtil().getTeams().stream().map(Team::getPrefix).toList().contains(prefix)) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPrefixAlreadyTaken().replace("%TEAMPREFIX%", prefix), new String[0]));
            return;
        }
        if (!this.plugin.getSettings().isTeamTagAllowColorCodes() && (prefix.contains("&") || prefix.contains("#"))) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamTagCannotContainColours(), new String[0]));
            return;
        }
        if (this.plugin.getSettings().isTeamTagRequirePermColorCodes() && !player.hasPermission("ultimateteams.team.tag.usecolors") && (prefix.contains("&") || prefix.contains("#"))) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getUseColoursMissingPermission(), new String[0]));
            return;
        }
        int prefixLength = Utils.removeColors(prefix).length();
        if (prefixLength >= this.MIN_CHAR_LIMIT && prefixLength <= this.MAX_CHAR_LIMIT) {
            this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
                if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.PREFIX))) {
                    sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                    return;
                }
                team.setPrefix(prefix);
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPrefixChangeSuccessful().replace("%TEAMPREFIX%", Utils.Color(prefix)), new String[0]));
            }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
        } else if (prefixLength > this.MAX_CHAR_LIMIT) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPrefixTooLong().replace("%CHARMAX%", String.valueOf(this.MAX_CHAR_LIMIT)), new String[0]));
        } else {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPrefixTooShort().replace("%CHARMIN%", String.valueOf(this.MIN_CHAR_LIMIT)), new String[0]));
        }
    }
}

