/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamRenameSubCommand {
    private final int MIN_CHAR_LIMIT;
    private final int MAX_CHAR_LIMIT;
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    private final UltimateTeams plugin;

    public TeamRenameSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.MIN_CHAR_LIMIT = plugin.getSettings().getTeamNameMinLength();
        this.MAX_CHAR_LIMIT = plugin.getSettings().getTeamNameMaxLength();
    }

    public void renameTeamSubCommand(CommandSender sender, String newname, List<String> bannedTags) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (newname.contains(" ")) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameContainsSpace().replace(TEAM_PLACEHOLDER, newname), new String[0]));
            return;
        }
        if (bannedTags.stream().map(String::toLowerCase).toList().contains(newname.toLowerCase())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameIsBanned().replace(TEAM_PLACEHOLDER, newname), new String[0]));
            return;
        }
        if (this.plugin.getTeamStorageUtil().getTeamsName().stream().map(String::toLowerCase).toList().contains(newname.toLowerCase())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameAlreadyTaken().replace(TEAM_PLACEHOLDER, newname), new String[0]));
            return;
        }
        if (!this.plugin.getSettings().isTeamCreateAllowColorCodes() && (newname.contains("&") || newname.contains("#"))) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameCannotContainColours(), new String[0]));
            return;
        }
        if (this.plugin.getSettings().isTeamCreateRequirePermColorCodes() && !player.hasPermission("ultimateteams.team.create.usecolors") && (newname.contains("&") || newname.contains("#"))) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getUseColoursMissingPermission(), new String[0]));
            return;
        }
        int nameLength = Utils.removeColors(newname).length();
        if (nameLength < this.MIN_CHAR_LIMIT) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameTooShort().replace("%CHARMIN%", Integer.toString(this.MIN_CHAR_LIMIT)), new String[0]));
            return;
        }
        if (nameLength > this.MAX_CHAR_LIMIT) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameTooLong().replace("%CHARMAX%", Integer.toString(this.MAX_CHAR_LIMIT)), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.RENAME))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            team.setName(newname);
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamNameChangeSuccessful().replace(TEAM_PLACEHOLDER, newname), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

