/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.disband;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamDisbandEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamDisbandConfirmSubCommand {
    private final UltimateTeams plugin;

    public TeamDisbandConfirmSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void disbandTeamSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamMustBeOwner(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            if (new TeamDisbandEvent(player, (Team)team).callEvent()) {
                return;
            }
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().deleteTeamData(player, (Team)team));
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamSuccessfullyDisbanded(), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamDisbandFailure(), new String[0])));
    }
}

