/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.echest;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.TeamEnderChestBackup;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamEnderChestRollbackSubCommand {
    private final UltimateTeams plugin;

    public TeamEnderChestRollbackSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void listBackupsAdmin(@NotNull CommandSender sender, @NotNull String teamName, int chestNumber) {
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            if (!team.hasEnderChest(chestNumber)) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamEchestNotExist().replace("%CHEST%", String.valueOf(chestNumber)).replace("%NUMBER%", String.valueOf(chestNumber)), new String[0]));
                return;
            }
            List<TeamEnderChestBackup> backups = this.plugin.getBackupManager().getBackups(team.getId(), chestNumber);
            if (backups.isEmpty()) {
                sender.sendMessage(Utils.Color("&cNo backups available for chest #" + chestNumber));
                return;
            }
            sender.sendMessage(Utils.Color("&6&l\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
            sender.sendMessage(Utils.Color("&e&lEnder Chest #" + chestNumber + " Backups"));
            sender.sendMessage(Utils.Color("&7Team: &f" + team.getName()));
            sender.sendMessage(Utils.Color("&6&l\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
            for (int i = 0; i < backups.size(); ++i) {
                TeamEnderChestBackup backup = backups.get(i);
                sender.sendMessage(Utils.Color("&e#" + (i + 1) + " &7- &f" + backup.getFormattedTimestamp() + " &7(" + backup.getTimeAgo() + ")"));
            }
            sender.sendMessage(Utils.Color("&6&l\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
            sender.sendMessage(Utils.Color("&7Use &e/ta echest rollback " + teamName + " " + chestNumber + " <backup#> &7to restore"));
            sender.sendMessage(Utils.Color("&7Use &e/ta echest forcerollback " + teamName + " " + chestNumber + " <backup#> &7to force restore"));
        }, () -> sender.sendMessage(Utils.Color("&cTeam '" + teamName + "' not found!")));
    }

    public void rollbackChestAdmin(@NotNull CommandSender sender, @NotNull String teamName, int chestNumber, int backupNumber, boolean force) {
        this.plugin.getTeamStorageUtil().findTeamByName(teamName).ifPresentOrElse(team -> {
            if (!team.hasEnderChest(chestNumber)) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamEchestNotExist().replace("%CHEST%", String.valueOf(chestNumber)).replace("%NUMBER%", String.valueOf(chestNumber)), new String[0]));
                return;
            }
            int backupIndex = backupNumber - 1;
            if (backupIndex < 0) {
                sender.sendMessage(Utils.Color("&cInvalid backup number! Use a positive number."));
                return;
            }
            List<TeamEnderChestBackup> backups = this.plugin.getBackupManager().getBackups(team.getId(), chestNumber);
            if (backups.isEmpty()) {
                sender.sendMessage(Utils.Color("&cNo backups available for chest #" + chestNumber));
                return;
            }
            if (backupIndex >= backups.size()) {
                sender.sendMessage(Utils.Color("&cBackup #" + backupNumber + " does not exist! Only " + backups.size() + " backup(s) available."));
                sender.sendMessage(Utils.Color("&7Use &e/ta echest backups " + teamName + " " + chestNumber + " &7to see available backups."));
                return;
            }
            TeamEnderChestBackup backup = backups.get(backupIndex);
            boolean success = this.plugin.getBackupManager().restoreBackup(team.getId(), chestNumber, backupIndex);
            if (success) {
                String rollbackType = force ? "&c&lFORCE ROLLBACK" : "&aROLLBACK";
                sender.sendMessage(Utils.Color("&a\u2713 Successfully rolled back Ender Chest #" + chestNumber + " for team " + team.getName() + "!"));
                sender.sendMessage(Utils.Color("&7Restored from: &f" + backup.getFormattedTimestamp() + " &7(" + backup.getTimeAgo() + ")"));
                if (force) {
                    sender.sendMessage(Utils.Color("&c&l\u26a0 FORCE ROLLBACK - Team was not notified"));
                }
                if (!force) {
                    team.getMembers().keySet().forEach(uuid -> {
                        Player member = this.plugin.getServer().getPlayer(uuid);
                        if (member != null) {
                            member.sendMessage(Utils.Color("&c&l[!] &cADMIN ALERT: &eTeam Ender Chest #" + chestNumber + " has been rolled back by an administrator"));
                            member.sendMessage(Utils.Color("&7Restored from: &f" + backup.getFormattedTimestamp()));
                        }
                    });
                }
            } else {
                sender.sendMessage(Utils.Color("&c\u2717 Failed to rollback Ender Chest #" + chestNumber + "!"));
            }
        }, () -> sender.sendMessage(Utils.Color("&cTeam '" + teamName + "' not found!")));
    }
}

