/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.economy;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamBankDepositEvent;
import dev.xf3d3.ultimateteams.api.events.TeamBankWithdrawEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamBankSubCommand {
    private final UltimateTeams plugin;

    public TeamBankSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamBankDepositSubCommand(CommandSender sender, double amount) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getEconomyHook() == null) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.DEPOSIT))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (!this.plugin.getEconomyHook().hasMoney(player, amount)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotEnoughMoney().replace("%MONEY%", String.valueOf(amount)), new String[0]));
                return;
            }
            if (amount <= 0.0) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getEconomyInvalidAmount().replace("%MONEY%", String.valueOf(amount)), new String[0]));
                return;
            }
            if (new TeamBankDepositEvent(player, (Team)team, team.getBalance(), team.getBalance() + amount).callEvent()) {
                return;
            }
            if (this.plugin.getEconomyHook().takeMoney(player, amount)) {
                String currencyName = amount > 1.0 ? this.plugin.getEconomyHook().getCurrencyNameSingular() : this.plugin.getEconomyHook().getCurrencyNamePlural();
                team.addBalance(amount);
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getMoneyDeposited().replace("%MONEY%", String.valueOf(amount)).replace("%CURRENCY%", currencyName), new String[0]));
            }
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    public void teamBankWithdrawSubCommand(CommandSender sender, double amount) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getEconomyHook() == null) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.WITHDRAW))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (amount <= 0.0) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getEconomyInvalidAmount().replace("%MONEY%", String.valueOf(amount)), new String[0]));
                return;
            }
            if (amount > team.getBalance()) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getMoneyWithdrawNotEnoughFunds().replace("%MONEY%", String.valueOf(amount)), new String[0]));
                return;
            }
            if (new TeamBankWithdrawEvent(player, (Team)team, team.getBalance(), team.getBalance() - amount).callEvent()) {
                return;
            }
            if (team.subBalance(amount)) {
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
                String currencyName = amount > 1.0 ? this.plugin.getEconomyHook().getCurrencyNameSingular() : this.plugin.getEconomyHook().getCurrencyNamePlural();
                this.plugin.getEconomyHook().giveMoney(player, amount);
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getMoneyWithdrawn().replace("%MONEY%", String.valueOf(amount)).replace("%CURRENCY%", currencyName), new String[0]));
            }
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

