/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.economy;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamFeeSubCommand {
    private final UltimateTeams plugin;

    public TeamFeeSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamFeeSeeSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getEconomyHook() == null) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.FEE))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamFeeCurrent().replace("%AMOUNT%", String.valueOf(team.getJoin_fee())), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    public void teamSetFeeSubCommand(CommandSender sender, double amount) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getEconomyHook() == null || !this.plugin.getSettings().isTeamJoinFeeEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.FEE))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (amount <= 0.0) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getEconomyInvalidAmount().replace("%AMOUNT%", String.valueOf(team.getJoin_fee())), new String[0]));
                return;
            }
            if (amount > this.plugin.getSettings().getTeamJoinFeeMax()) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamFeeTooBig().replace("%AMOUNT%", String.valueOf(this.plugin.getSettings().getTeamJoinFeeMax())), new String[0]));
                return;
            }
            team.setJoin_fee(amount);
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamFeeSet().replace("%AMOUNT%", String.valueOf(team.getJoin_fee())), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    public void teamDisableFeeSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getEconomyHook() == null) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.FEE))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            team.setJoin_fee(0.0);
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamFeeDisable(), new String[0]));
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

