/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.home;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamHomeDeleteEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamDelHomeSubCommand {
    private final UltimateTeams plugin;

    public TeamDelHomeSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void deleteTeamHomeSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamHomeEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.HOME))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (this.plugin.getTeamStorageUtil().isHomeSet((Team)team)) {
                if (new TeamHomeDeleteEvent(player, (Team)team).callEvent()) {
                    return;
                }
                this.plugin.getTeamStorageUtil().deleteHome(player, (Team)team);
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getSuccessfullyDeletedTeamHome(), new String[0]));
            } else {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedNoHomeSet(), new String[0]));
            }
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamMustBeOwner(), new String[0])));
    }
}

