/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.home;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamTeleportEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamHome;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamHomeSubCommand {
    private static final String TIME_LEFT = "%TIMELEFT%";
    private static TeamTeleportEvent homePreTeleportEvent = null;
    private static final ConcurrentHashMap<UUID, Long> homeCoolDownTimer = new ConcurrentHashMap();
    private final UltimateTeams plugin;

    public TeamHomeSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void tpTeamHomeSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getSettings().teamHomeEnabled()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getFunctionDisabled(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            TeamHome home = team.getHome();
            if (home == null) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedNoHomeSet(), new String[0]));
                return;
            }
            if (this.plugin.getSettings().teamHomeCooldownEnabled()) {
                if (!player.hasPermission("ultimateteams.bypass.homecooldown") && homeCoolDownTimer.containsKey(player.getUniqueId())) {
                    if (homeCoolDownTimer.get(player.getUniqueId()) > System.currentTimeMillis()) {
                        long timeLeft = (homeCoolDownTimer.get(player.getUniqueId()) - System.currentTimeMillis()) / 1000L;
                        player.sendMessage(MineDown.parse(this.plugin.getMessages().getHomeCoolDownTimerWait().replaceAll(TIME_LEFT, Long.toString(timeLeft)), new String[0]));
                    } else {
                        homeCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
                        if (new TeamTeleportEvent(player, (Team)team, home.getLocation()).callEvent()) {
                            return;
                        }
                        this.tpHome(player, home);
                    }
                } else {
                    if (new TeamTeleportEvent(player, (Team)team, home.getLocation()).callEvent()) {
                        return;
                    }
                    this.tpHome(player, home);
                    homeCoolDownTimer.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.plugin.getSettings().getTeamHomeCooldownValue() * 1000L);
                }
                return;
            }
            if (new TeamTeleportEvent(player, (Team)team, home.getLocation()).callEvent()) {
                return;
            }
            this.tpHome(player, home);
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedTpNotInTeam(), new String[0])));
    }

    private void tpHome(@NotNull Player player, @NotNull TeamHome home) {
        this.plugin.getUtils().teleportPlayer(player, home.getLocation(), home.getServer(), Utils.TeleportType.HOME, null);
    }
}

