/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamMemberJoinEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamInvite;
import dev.xf3d3.ultimateteams.utils.Utils;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamInviteSubCommand {
    private static final String INVITED_PLAYER = "%INVITED%";
    public static final String PLAYER_PLACEHOLDER = "%PLAYER%";
    public static final String TEAM_PLACEHOLDER = "%TEAM%";
    private final UltimateTeams plugin;

    public TeamInviteSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamInviteSendSubCommand(CommandSender sender, String inviteeName) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)inviteeName);
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.INVITE))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (offlinePlayer.getUniqueId().toString().equals(player.getUniqueId().toString())) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteSelfError(), new String[0]));
                return;
            }
            if (this.plugin.getTeamStorageUtil().findTeamByMember(offlinePlayer.getUniqueId()).isPresent()) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteInvitedAlreadyInTeam().replace(INVITED_PLAYER, inviteeName), new String[0]));
                return;
            }
            if (this.plugin.getTeamInviteUtil().hasInvitee(offlinePlayer.getUniqueId())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteFailed().replaceAll(INVITED_PLAYER, inviteeName), new String[0]));
                return;
            }
            this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAccept(teamPlayer -> {
                int maxMembers = teamPlayer.getMaxMembers(player, this.plugin.getSettings().getTeamMaxSize(), this.plugin.getSettings().getStackedTeamSize());
                if (team.getMembers().size() >= maxMembers) {
                    player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteMaxSizeReached().replace("%LIMIT%", String.valueOf(maxMembers)), new String[0]));
                    return;
                }
                this.plugin.getUsersStorageUtil().getPlayer(offlinePlayer.getUniqueId()).thenAccept(invitedTeamPlayer -> {
                    if (!invitedTeamPlayer.getPreferences().isAcceptInvitations()) {
                        player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteFailInvitesOff().replace("%NAME%", inviteeName), new String[0]));
                        return;
                    }
                    boolean invited = this.plugin.getTeamInviteUtil().createInvite(team.getId(), player, offlinePlayer.getUniqueId());
                    if (invited) {
                        player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteSuccessful().replace(INVITED_PLAYER, inviteeName), new String[0]));
                        Optional.ofNullable(offlinePlayer.getPlayer()).ifPresent(invitedPlayer -> invitedPlayer.sendMessage(MineDown.parse(String.join((CharSequence)"\n", this.plugin.getMessages().getTeamInviteInvitedMessage()).replace(TEAM_PLACEHOLDER, team.getName()).replace("%INVITER%", player.getName()), new String[0])));
                    } else {
                        player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteFailed().replace(INVITED_PLAYER, inviteeName), new String[0]));
                    }
                });
            });
        }, () -> sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    public void teamInviteDenySubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamInviteUtil().hasInvitee(player.getUniqueId())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteDenyFail(), new String[0]));
            return;
        }
        if (this.plugin.getTeamInviteUtil().declineInvite(player)) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteDenied(), new String[0]));
        } else {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamInviteDenyFail(), new String[0]));
        }
    }

    public void teamInviteAcceptSubCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getTeamInviteUtil().hasInvitee(player.getUniqueId())) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinFailedNoInvite(), new String[0]));
            return;
        }
        this.plugin.getTeamInviteUtil().getInvite(player.getUniqueId()).ifPresentOrElse(invite -> this.plugin.getTeamStorageUtil().findTeamByMember(invite.getInviter()).ifPresentOrElse(team -> {
            if (this.plugin.getEconomyHook() != null && team.getJoin_fee() > 0.0) {
                if (!this.plugin.getEconomyHook().takeMoney(player, team.getJoin_fee())) {
                    player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamFeeCantJoin().replace(TEAM_PLACEHOLDER, team.getName()).replace("%AMOUNT%", String.valueOf(team.getJoin_fee())), new String[0]));
                    return;
                }
                team.addBalance(team.getJoin_fee());
                team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamFeeDeposited().replace(PLAYER_PLACEHOLDER, player.getName()).replace("%AMOUNT%", String.valueOf(team.getJoin_fee())), new String[0]));
            }
            if (new TeamMemberJoinEvent(player, (Team)team, TeamMemberJoinEvent.JoinReason.ACCEPT_INVITE).callEvent()) {
                return;
            }
            this.plugin.getTeamStorageUtil().addTeamMember((Team)team, player);
            this.plugin.getTeamInviteUtil().acceptInvite((TeamInvite)invite, player);
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinSuccessful().replace(TEAM_PLACEHOLDER, team.getName()), new String[0]));
            if (!this.plugin.getSettings().teamJoinAnnounce()) {
                return;
            }
            team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinBroadcastChat().replace(PLAYER_PLACEHOLDER, player.getName()).replace(TEAM_PLACEHOLDER, Utils.Color(team.getName())), new String[0]));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinFailedNoValidTeam(), new String[0]))), () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamJoinFailedNoInvite(), new String[0])));
    }
}

