/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimateteams.libraries.aikar.commands.annotation.Subcommand;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="invites|teaminvites")
public class TeamInvites
extends BaseCommand {
    private final Logger logger;
    private final UltimateTeams plugin;

    public TeamInvites(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    @Default
    @CommandCompletion(value="@nothing")
    @Subcommand(value="enable")
    @CommandPermission(value="ultimateteams.invites.enable")
    public void onInvitesEnable(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAccept(teamPlayer -> {
            teamPlayer.getPreferences().setAcceptInvitations(true);
            this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer((TeamPlayer)teamPlayer));
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getInvitesEnabled(), new String[0]));
        });
    }

    @CommandCompletion(value="@nothing")
    @Subcommand(value="disable")
    @CommandPermission(value="ultimateteams.invites.disable")
    public void onInvitesDisable(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAccept(teamPlayer -> {
            teamPlayer.getPreferences().setAcceptInvitations(false);
            this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer((TeamPlayer)teamPlayer));
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getInvitesDisabled(), new String[0]));
        });
    }
}

