/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamMemberLeaveEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamKickSubCommand {
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    private static final String PLAYER_TO_KICK = "%KICKEDPLAYER%";
    private final UltimateTeams plugin;

    public TeamKickSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamKickSubCommand(CommandSender sender, OfflinePlayer offlinePlayer) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!offlinePlayer.hasPlayedBefore()) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getCouldNotFindSpecifiedPlayer().replace(PLAYER_TO_KICK, offlinePlayer.toString()), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.KICK))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (player.getName().equalsIgnoreCase(offlinePlayer.getName())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedCannotKickYourself(), new String[0]));
                return;
            }
            if (!team.getMembers().containsKey(offlinePlayer.getUniqueId())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTargetedPlayerIsNotInYourTeam().replace(PLAYER_TO_KICK, offlinePlayer.getName()), new String[0]));
            }
            if (new TeamMemberLeaveEvent(player.getUniqueId(), (Team)team, TeamMemberLeaveEvent.LeaveReason.EVICTED).callEvent()) {
                return;
            }
            this.plugin.getTeamStorageUtil().kickPlayer(player, (Team)team, offlinePlayer);
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamMemberKickSuccessful().replace(PLAYER_TO_KICK, offlinePlayer.getName()), new String[0]));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

