/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.api.events.TeamMemberLeaveEvent;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import dev.xf3d3.ultimateteams.models.TeamPlayer;
import dev.xf3d3.ultimateteams.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamLeaveSubCommand {
    private static final String Team_PLACEHOLDER = "%TEAM%";
    private final UltimateTeams plugin;

    public TeamLeaveSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamLeaveSubCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getFailedTeamOwner(), new String[0]));
                return;
            }
            this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
                if (new TeamMemberLeaveEvent(player.getUniqueId(), (Team)team, TeamMemberLeaveEvent.LeaveReason.MEMBER_LEFT).callEvent()) {
                    return;
                }
                team.removeMember(player.getUniqueId());
                this.plugin.getUsersStorageUtil().getPlayer(player.getUniqueId()).thenAcceptAsync(teamPlayer -> {
                    if (teamPlayer.getPreferences().isTeamChatTalking()) {
                        teamPlayer.getPreferences().setTeamChatTalking(false);
                        this.plugin.getDatabase().updatePlayer((TeamPlayer)teamPlayer);
                    }
                });
                this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamLeaveSuccessful().replace(Team_PLACEHOLDER, Utils.Color(team.getName())), new String[0]));
                if (this.plugin.getSettings().teamLeftAnnounce()) {
                    team.sendTeamMessage(MineDown.parse(this.plugin.getMessages().getTeamLeftBroadcastChat().replace("%PLAYER%", player.getName()).replace(Team_PLACEHOLDER, Utils.Color(team.getName())), new String[0]));
                }
            }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamLeaveFailed(), new String[0])));
        }
    }
}

