/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimateteams.commands.subCommands.members;

import dev.xf3d3.ultimateteams.UltimateTeams;
import dev.xf3d3.ultimateteams.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimateteams.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimateteams.models.Team;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamManagersSubCommand {
    private static final String TEAM_PLACEHOLDER = "%TEAM%";
    private static final String PLAYER_TO_KICK = "%KICKEDPLAYER%";
    private final UltimateTeams plugin;

    public TeamManagersSubCommand(@NotNull UltimateTeams plugin) {
        this.plugin = plugin;
    }

    public void teamPromoteSubCommand(CommandSender sender, OfflinePlayer offlinePlayer) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!offlinePlayer.hasPlayedBefore() || offlinePlayer.getName() == null) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getCouldNotFindSpecifiedPlayer().replace(PLAYER_TO_KICK, offlinePlayer.toString()), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByMember(player.getUniqueId()).ifPresentOrElse(team -> {
            if (!(this.plugin.getTeamStorageUtil().isTeamOwner(player) || this.plugin.getTeamStorageUtil().isTeamManager(player) && team.hasPermission(Team.Permission.PROMOTE))) {
                sender.sendMessage(MineDown.parse(this.plugin.getMessages().getNoPermission(), new String[0]));
                return;
            }
            if (player.getName().equalsIgnoreCase(offlinePlayer.getName())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPromoteSelfError(), new String[0]));
                return;
            }
            if (!team.getMembers().containsKey(offlinePlayer.getUniqueId())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTargetedPlayerIsNotInYourTeam().replace(PLAYER_TO_KICK, offlinePlayer.getName()), new String[0]));
            }
            team.getMembers().put(offlinePlayer.getUniqueId(), 2);
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamPromoteSuccessful().replace("%PLAYER%", offlinePlayer.getName()), new String[0]));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }

    public void teamDemoteSubCommand(CommandSender sender, OfflinePlayer offlinePlayer) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getPlayerOnlyCommand(), new String[0]));
            return;
        }
        Player player = (Player)sender;
        if (!offlinePlayer.hasPlayedBefore() || offlinePlayer.getName() == null) {
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getCouldNotFindSpecifiedPlayer().replace(PLAYER_TO_KICK, offlinePlayer.toString()), new String[0]));
            return;
        }
        if (!this.plugin.getTeamStorageUtil().isTeamOwner(player)) {
            sender.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamMustBeOwner(), new String[0]));
            return;
        }
        this.plugin.getTeamStorageUtil().findTeamByOwner(player.getUniqueId()).ifPresentOrElse(team -> {
            if (player.getName().equalsIgnoreCase(offlinePlayer.getName())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamDemoteSelfError(), new String[0]));
                return;
            }
            if (!team.getMembers().containsKey(offlinePlayer.getUniqueId())) {
                player.sendMessage(MineDown.parse(this.plugin.getMessages().getTargetedPlayerIsNotInYourTeam().replace(PLAYER_TO_KICK, offlinePlayer.getName()), new String[0]));
            }
            team.getMembers().put(offlinePlayer.getUniqueId(), 1);
            this.plugin.runAsync(task -> this.plugin.getTeamStorageUtil().updateTeamData(player, (Team)team));
            player.sendMessage(MineDown.parse(this.plugin.getMessages().getTeamDemoteSuccessful().replace("%PLAYER%", offlinePlayer.getName()), new String[0]));
        }, () -> player.sendMessage(MineDown.parse(this.plugin.getMessages().getNotInTeam(), new String[0])));
    }
}

